﻿<%

function GuDateTimeInitialization(ObjectType,ObjectNumerical,YearFormerDigit,YearAfterDigit)

	if trim(ObjectType)="" or isNull(ObjectType)=true then
		GuDateTimeInitialization="0"
		exit function
	end if

	if ObjectType="Year" then

		dim DateTimeYear
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)<>4 then
			DateTimeYear=year(now())
		else
			DateTimeYear=ObjectNumerical
		end if

		if year(now())-DateTimeYear>=80 then
			DateTimeYear=year(now())-20
		end if

		if trim(YearFormerDigit)="" or isNull(YearFormerDigit)=true or isNumeric(YearFormerDigit)=false or len(YearFormerDigit)>=3 then
			YearFormerDigit=1
		else
			YearFormerDigit=YearFormerDigit
		end if

		if year(now())-(DateTimeYear-YearFormerDigit)>=80 then
			YearFormerDigit=DateTimeYear-(year(now())-80)
		end if

		if trim(YearAfterDigit)="" or isNull(YearAfterDigit)=true or isNumeric(YearAfterDigit)=false or len(YearAfterDigit)>=3 then
			YearAfterDigit=1
		else
			YearAfterDigit=YearAfterDigit
		end if

		if YearFormerDigit>=1 then
		for YY=DateTimeYear-YearFormerDigit to DateTimeYear-1 step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&DateTimeYear&""" selected=""true"">"&DateTimeYear&"</option>"

		if YearAfterDigit>=1 then
		for YY=DateTimeYear+1 to DateTimeYear+YearAfterDigit step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

		if (DateTimeYear+YearAfterDigit)<=year(now()) then
		for YY=DateTimeYear+YearAfterDigit+1 to year(now())+YearAfterDigit step 1
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&YY&""">"&YY&"</option>"
		next
		end if

	end if

	if ObjectType="Month" then

		dim DateTimeMonth,MonthSelected
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)>=3 then
			DateTimeMonth=month(now())
		else
			DateTimeMonth=ObjectNumerical
		end if

		if DateTimeMonth<=0 or DateTimeMonth>=13 then
			DateTimeMonth=1
		end if

		for MM=1 to 12 step 1
			if MM=DateTimeMonth then
				MonthSelected="selected=""true"""
			else
				MonthSelected=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&MM&""" "&MonthSelected&">"&MM&"</option>"
		next

	end if

	if ObjectType="Day" then

		dim DateTimeDay,DaySelected
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)>=3 then
			DateTimeDay=day(now())
		else
			DateTimeDay=ObjectNumerical
		end if

		if DateTimeDay<=0 or DateTimeDay>=32 then
			DateTimeMonth=1
		end if

		for DD=1 to 31 step 1
			if DD=DateTimeDay then
				DaySelected="selected=""true"""
			else
				DaySelected=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&DD&""" "&DaySelected&">"&DD&"</option>"
		next

	end if

	if ObjectType="Hour" then

		dim DateTimeHour,HourSelected
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)>=3 then
			DateTimeHour=hour(now())
		else
			DateTimeHour=ObjectNumerical
		end if

		if DateTimeHour<=0 or DateTimeHour>=24 then
			DateTimeHour=1
		end if

		for HH=0 to 23 step 1
			if HH=DateTimeHour then
				HourSelected="selected=""true"""
			else
				HourSelected=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&HH&""" "&HourSelected&">"&HH&"</option>"
		next

	end if

	if ObjectType="Minute" then

		dim DateTimeMinute,MinuteSelected
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)>=3 then
			DateTimeMinute=minute(now())
		else
			DateTimeMinute=ObjectNumerical
		end if

		if DateTimeMinute<=0 or DateTimeMinute>=60 then
			DateTimeMinute=1
		end if

		for MM=0 to 59 step 1
			if MM=DateTimeMinute then
				MinuteSelected="selected=""true"""
			else
				MinuteSelected=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&MM&""" "&MinuteSelected&">"&MM&"</option>"
		next

	end if

	if ObjectType="Second" then

		dim DateTimeSecond,SecondSelected
		if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or isNumeric(ObjectNumerical)=false or len(ObjectNumerical)>=3 then
			DateTimeSecond=second(now())
		else
			DateTimeSecond=ObjectNumerical
		end if

		if DateTimeSecond<=0 or DateTimeSecond>=60 then
			DateTimeSecond=1
		end if

		for SS=0 to 59 step 1
			if SS=DateTimeSecond then
				SecondSelected="selected=""true"""
			else
				SecondSelected=""
			end if
			GuDateTimeInitialization=GuDateTimeInitialization&"<option value="""&SS&""" "&SecondSelected&">"&SS&"</option>"
		next

	end if

	GuDateTimeInitialization=GuDateTimeInitialization

end function


function GuDateTimeStyle(DateTimeData)

	if trim(DateTimeData)="" or isDate(DateTimeData)=false then
		GuDateTimeStyle="BlackS12"
		exit function
	end if

	if DateValue(DateTimeData)=date() then
		GuDateTimeStyle="MaroonS12"
	elseif datediff("d",DateTimeData,now())<=3 then
		GuDateTimeStyle="LightgrayS12"
	elseif datediff("d",DateTimeData,now())<=7 then
		GuDateTimeStyle="TealS12"
	else
		GuDateTimeStyle="BlackS12"
	end if

end function


function GuDateTimeVerify(ObjectNumerical)

	if trim(ObjectNumerical)="" or isNull(ObjectNumerical)=true or (instr(ObjectNumerical,"-")<=0 and instr(ObjectNumerical,":")<=0) then
		GuDateTimeVerify=now()
		exit function
	end if

	if instr(split(ObjectNumerical&" 0"," ")(0),"-")>=1 then

		dim DateTimeYear,DateTimeMonth,DateTimeDay

		DateTimeYear=split(split(ObjectNumerical&" 0"," ")(0),"-")(0)
		if trim(DateTimeYear)="" or isNull(DateTimeYear)=true or isNumeric(DateTimeYear)=false or len(DateTimeYear)<>4 then
			DateTimeYear=year(now())
		else
			if DateTimeYear<=1900 or DateTimeYear>=2100 then
				DateTimeYear=year(now())
			else
				DateTimeYear=DateTimeYear
			end if
		end if

		DateTimeMonth=split(split(ObjectNumerical&" 0"," ")(0),"-")(1)
		if trim(DateTimeMonth)="" or isNull(DateTimeMonth)=true or isNumeric(DateTimeMonth)=false or len(DateTimeMonth)>=3 then
			DateTimeMonth=month(now())
		else
			if DateTimeMonth<=0 or DateTimeMonth>=13 then
				DateTimeMonth=month(now())
			else
				DateTimeMonth=DateTimeMonth
			end if
		end if

		DateTimeDay=split(split(ObjectNumerical&" 0"," ")(0),"-")(2)
		if trim(DateTimeDay)="" or isNull(DateTimeDay)=true or isNumeric(DateTimeDay)=false or len(DateTimeDay)>=3 then
			DateTimeDay=day(now())
		else
			if DateTimeDay<=0 then
				DateTimeDay=day(now())
			else
				if (DateTimeMonth=1 or DateTimeMonth=3 or DateTimeMonth=5 or DateTimeMonth=7 or DateTimeMonth=8 or DateTimeMonth=10 or DateTimeMonth=12) and DateTimeDay>=32 then
					DateTimeDay=31
				elseif DateTimeMonth=2 and (DateTimeYear mod 4)<>0 and DateTimeDay>=29 then
					DateTimeDay=28
				elseif DateTimeMonth=2 and (DateTimeYear mod 4)=0 and DateTimeDay>=30 then
					DateTimeDay=29
				elseif (DateTimeMonth=4 or DateTimeMonth=6 or DateTimeMonth=9 or DateTimeMonth=11) and DateTimeDay>=31 then
					DateTimeDay=30
				else
					DateTimeDay=DateTimeDay
				end if
			end if
		end if

	end if

	if instr(split(ObjectNumerical&" 0"," ")(1),":")>=1 then

		dim DateTimeHour,DateTimeMinute,DateTimeSecond

		DateTimeHour=split(split(ObjectNumerical&" 0"," ")(1),":")(0)
		if trim(DateTimeHour)="" or isNull(DateTimeHour)=true or isNumeric(DateTimeHour)=false or len(DateTimeHour)>=3 then
			DateTimeHour=hour(now())
		else
			if DateTimeHour<=0 or DateTimeHour>=24 then
				DateTimeHour=0
			else
				DateTimeHour=DateTimeHour
			end if
		end if

		DateTimeMinute=split(split(ObjectNumerical&" 0"," ")(1),":")(1)
		if trim(DateTimeMinute)="" or isNull(DateTimeMinute)=true or isNumeric(DateTimeMinute)=false or len(DateTimeMinute)>=3 then
			DateTimeMinute=minute(now())
		else
			if DateTimeMinute<=0 or DateTimeMinute>=60 then
				DateTimeMinute=0
			else
				DateTimeMinute=DateTimeMinute
			end if
		end if

		DateTimeSecond=second(now())

	end if

	if instr(split(ObjectNumerical&" 0"," ")(0),"-")>=1 and instr(split(ObjectNumerical&" 0"," ")(1),":")<=0 then
		GuDateTimeVerify=DateTimeYear&"-"&DateTimeMonth&"-"&DateTimeDay
	elseif instr(split(ObjectNumerical&" 0"," ")(0),"-")<=0 and instr(split(ObjectNumerical&" 0"," ")(1),":")>=1 then
		GuDateTimeVerify=DateTimeHour&":"&DateTimeMinute&":"&DateTimeSecond
	else
		GuDateTimeVerify=DateTimeYear&"-"&DateTimeMonth&"-"&DateTimeDay&" "&DateTimeHour&":"&DateTimeMinute&":"&DateTimeSecond
	end if

	GuDateTimeVerify=cdate(GuDateTimeVerify)

end function


function GuExplorerFolderCreate(FolderPath)

	if trim(FolderPath)="" or isNull(FolderPath)=true then
		GuExplorerFolderCreate=""
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FolderExists(Server.MapPath(FolderPath))=false then
		SFSO.CreateFolder(Server.MapPath(FolderPath))
	end if
	set SFSO=nothing

	GuExplorerFolderCreate=""

end function


function GuExplorerFolderDelete(FolderPath)

	if trim(FolderPath)="" or isNull(FolderPath)=true then
		GuExplorerFolderDelete=""
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FolderExists(Server.MapPath(FolderPath))=true then
		SFSO.DeleteFolder(Server.MapPath(FolderPath))
	end if
	set SFSO=nothing

	GuExplorerFolderDelete=""

end function


function GuExplorerFolderExists(FolderPath)

	if trim(FolderPath)="" or isNull(FolderPath)=true Then
		GuExplorerFolderExists=false
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FolderExists(Server.MapPath(FolderPath))=true then
		GuExplorerFolderExists=true
	else
		GuExplorerFolderExists=false
	end if
	set SFSO=nothing

end function


function GuExplorerFolderSubFolders(FolderName)

	if trim(FolderName)="" or isNull(FolderName)=true then
		GuExplorerFolderSubFolders=""
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	set SFFG=SFSO.GetFolder(Server.MapPath(FolderName))
	for each SFFL in SFFG.SubFolders
		GuExplorerFolderSubFolders=SFFL.name&"|"&GuExplorerFolderSubFolders
	next
	set SFFG=nothing
	set SFSO=nothing

	if trim(GuExplorerFolderSubFolders)="|" then
		GuExplorerFolderSubFolders=""
	elseif right(GuExplorerFolderSubFolders,1)="|" then
		GuExplorerFolderSubFolders=left(GuExplorerFolderSubFolders,len(GuExplorerFolderSubFolders)-1)
	else
		GuExplorerFolderSubFolders=trim(GuExplorerFolderSubFolders)
	end if

end function


function GuExplorerFileCreate(FilePath,FileContent,FileCharset)

	if trim(FilePath)="" or isNull(FilePath)=true then
		GuExplorerFileCreate=""
		exit function
	end if

	if trim(FileContent)="" or isNull(FileContent)=true then
		FileContent=""
	else
		FileContent=trim(FileContent)
	end if

	if trim(FileCharset)="" or isNull(FileCharset)=true then
		GuExplorerFileCreate=""
		exit function
	end if

	select case FileCharset
	case "ANSI"
		set SFSO=Server.CreateObject("Scripting.FileSystemObject")
		set SFFC=SFSO.CreateTextFile(Server.MapPath(FilePath),true)
		SFFC.Write FileContent
		SFFC.close
		set SFFC=nothing
		set SFSO=nothing
	case "ASCII","Big5","GB2312","GBK","UTF-8","Unicode"
		set ASFC=Server.CreateObject("ADODB.Stream")
		ASFC.type=2
		ASFC.mode=3
		ASFC.charset=FileCharset
		ASFC.open
		ASFC.WriteText FileContent
		ASFC.SaveToFile Server.MapPath(FilePath),2
		ASFC.flush
		ASFC.close
		set ASFC=nothing
	case else
		response.write ""
	end select

	GuExplorerFileCreate=""

end function


function GuExplorerFileDelete(FilePath)

	if trim(FilePath)="" or isNull(FilePath)=true then
		GuExplorerFileDelete=""
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FileExists(Server.MapPath(FilePath))=true then
		SFSO.DeleteFile(Server.MapPath(FilePath))
	end if
	set SFSO=nothing

	GuExplorerFileDelete=""

end function


function GuExplorerFileExists(FilePath)

	if trim(FilePath)="" or isNull(FilePath)=true then
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FileExists(Server.MapPath(FilePath))=true then
		GuExplorerFileExists=true
	else
		GuExplorerFileExists=false
	end if
	set SFSO=nothing

end function


function GuExplorerFileExtension(FileName)

	if trim(FileName)="" or isNull(FileName)=true then
		GuExplorerFileExtension=""
		exit function
	end if

	if instr(FileName,".")<=0 then
		GuExplorerFileExtension=""
		exit function
	end if

	dim ResourceNameSplit
	ResourceNameSplit=split(FileName,".")
	GuExplorerFileExtension=ResourceNameSplit(ubound(ResourceNameSplit))
	GuExplorerFileExtension=lcase(GuExplorerFileExtension)

end function


function GuExplorerFileSizeConversion(FileSize,ReturnType)

	dim FileSizeNumber,FileSizeUnit
	if trim(FileSize)="" or isNull(FileSize)=true or isNumeric(FileSize)=false or trim(ReturnType)="" then
		GuExplorerFileSizeConversion="0"
		exit function
	end if

	if FileSize<=1048575 then
		FileSizeNumber=FileSize/1024
		FileSizeUnit="KB"
	else
		if FileSize>=1048576 and FileSize<=1073741823 then
			FileSizeNumber=FileSize/1024/1024
			FileSizeUnit="MB"
		else
			if FileSize>=1073741824 and FileSize<=1099511627775 then
				FileSizeNumber=FileSize/1024/1024/1024
				FileSizeUnit="GB"
			else
				if FileSize>=1099511627776 then
					FileSizeNumber=FileSize/1024/1024/1024/1024
					FileSizeUnit="TB"
				else
					FileSizeNumber=FileSize/1024
					FileSizeUnit="KB"
				end if
			end if
		end if
	end if

	select case trim(ReturnType)
	case "Number"
		GuExplorerFileSizeConversion=formatnumber(FileSizeNumber,1,true)  '保留小数点后1位。
	case "Unit"
		GuExplorerFileSizeConversion=FileSizeUnit
	case else
		GuExplorerFileSizeConversion="0"
	end select

end function


function GuExplorerFileSizeGet(FilePath)

	if trim(FilePath)="" or isNull(FilePath)=true then
		GuExplorerFileSizeGet="0"
		exit function
	end if

	set SFSO=Server.CreateObject("Scripting.FileSystemObject")
	if SFSO.FileExists(Server.MapPath(FilePath))=true then
		set SFFR=SFSO.GetFile(Server.MapPath(FilePath))
		GuExplorerFileSizeGet=SFFR.size
	else
		GuExplorerFileSizeGet="0"
	end if
	set SFFR=nothing
	set SFSO=nothing

end function


function GuExplorerFileIcon(FileType)

	if trim(FileType)="" or isNull(FileType)=true then
		GuExplorerFileIcon=""
		exit function
	end if

	select case FileType
	case "mdb"
		GuExplorerFileIcon="Access.png"
	case "mid","mp3","wav"
		GuExplorerFileIcon="Audio.png"
	case "asa","asp","aspx","c","cgi","jsp","php","php3","php4"
		GuExplorerFileIcon="Code.png"
	case "bat","cmd"
		GuExplorerFileIcon="Commend.png"
	case "css"
		GuExplorerFileIcon="CSS.png"
	case "xls","xlsx"
		GuExplorerFileIcon="Excel.png"
	case "exe"
		GuExplorerFileIcon="EXE.png"
	case "fla","swf"
		GuExplorerFileIcon="Flash.png"
	case "chm"
		GuExplorerFileIcon="Help.png"
	case "htm","html","mht"
		GuExplorerFileIcon="HTML.png"
	case "js"
		GuExplorerFileIcon="JavaScript.png"
	case "avi","dat","mp4","rm","rmvb"
		GuExplorerFileIcon="Media.png"
	case "pdf"
		GuExplorerFileIcon="PDF.png"
	case "bmp","gif","jpg","jpeg","png"
		GuExplorerFileIcon="Picture.png"
	case "ppt"
		GuExplorerFileIcon="PowerPoint.png"
	case "key","reg"
		GuExplorerFileIcon="Registry.png"
	case "txt","inc"
		GuExplorerFileIcon="Text.png"
	case "cab","iso","rar","uue","z","zip"
		GuExplorerFileIcon="WinZIP.png"
	case "doc","docx","wps"
		GuExplorerFileIcon="Word.png"
	case "xml"
		GuExplorerFileIcon="XML.png"
	case else
		GuExplorerFileIcon="Undefinition.png"
	end select

end function


function GuExplorerPathPresentGet()

	GuExplorerPathPresentGet=Request.ServerVariables("SCRIPT_NAME")
	GuExplorerPathPresentGet=left(GuExplorerPathPresentGet,instrrev(GuExplorerPathPresentGet,"/"))

end function


function GuFilterFolderName(FolderName)

	if trim(FolderName)="" or isNull(FolderName)=true then
		GuFilterFolderName=""
		exit function
	end if

	GuFilterFolderName=trim(FolderName)
	GuFilterFolderName=replace(GuFilterFolderName,"~","_")
	GuFilterFolderName=replace(GuFilterFolderName,"`","_")
	GuFilterFolderName=replace(GuFilterFolderName,"!","_")
	GuFilterFolderName=replace(GuFilterFolderName,"@","_")
	GuFilterFolderName=replace(GuFilterFolderName,"#","_")
	GuFilterFolderName=replace(GuFilterFolderName,"$","_")
	GuFilterFolderName=replace(GuFilterFolderName,"%","_")
	GuFilterFolderName=replace(GuFilterFolderName,"^","_")
	GuFilterFolderName=replace(GuFilterFolderName,"&","_")
	GuFilterFolderName=replace(GuFilterFolderName,"*","_")
	GuFilterFolderName=replace(GuFilterFolderName,"-","_")
	GuFilterFolderName=replace(GuFilterFolderName,"+","_")
	GuFilterFolderName=replace(GuFilterFolderName,"=","_")
	GuFilterFolderName=replace(GuFilterFolderName,"{","_")
	GuFilterFolderName=replace(GuFilterFolderName,"}","_")
	GuFilterFolderName=replace(GuFilterFolderName,":","_")
	GuFilterFolderName=replace(GuFilterFolderName,";","_")
	GuFilterFolderName=replace(GuFilterFolderName,"""","_")
	GuFilterFolderName=replace(GuFilterFolderName,"'","_")
	GuFilterFolderName=replace(GuFilterFolderName,"|","_")
	GuFilterFolderName=replace(GuFilterFolderName,"\","_")
	GuFilterFolderName=replace(GuFilterFolderName,"<","_")
	GuFilterFolderName=replace(GuFilterFolderName,",","_")
	GuFilterFolderName=replace(GuFilterFolderName,">","_")
	GuFilterFolderName=replace(GuFilterFolderName,".","_")
	GuFilterFolderName=replace(GuFilterFolderName,"?","_")
	GuFilterFolderName=replace(GuFilterFolderName,"/","_")

end function


function GuFilterFileName(FileName)

	if trim(FileName)="" or isNull(FileName)=true then
		GuFilterFileName=""
		exit function
	end if

	GuFilterFileName=trim(FileName)
	GuFilterFileName=replace(GuFilterFileName,"~","_")
	GuFilterFileName=replace(GuFilterFileName,"`","_")
	GuFilterFileName=replace(GuFilterFileName,"!","_")
	GuFilterFileName=replace(GuFilterFileName,"@","_")
	GuFilterFileName=replace(GuFilterFileName,"$","_")
	GuFilterFileName=replace(GuFilterFileName,"%","_")
	GuFilterFileName=replace(GuFilterFileName,"^","_")
	GuFilterFileName=replace(GuFilterFileName,"&","_")
	GuFilterFileName=replace(GuFilterFileName,"*","_")
	GuFilterFileName=replace(GuFilterFileName,"+","_")
	GuFilterFileName=replace(GuFilterFileName,"=","_")
	GuFilterFileName=replace(GuFilterFileName,"{","_")
	GuFilterFileName=replace(GuFilterFileName,"}","_")
	GuFilterFileName=replace(GuFilterFileName,":","_")
	GuFilterFileName=replace(GuFilterFileName,";","_")
	GuFilterFileName=replace(GuFilterFileName,"""","_")
	GuFilterFileName=replace(GuFilterFileName,"'","_")
	GuFilterFileName=replace(GuFilterFileName,"|","_")
	GuFilterFileName=replace(GuFilterFileName,"\","_")
	GuFilterFileName=replace(GuFilterFileName,"<","_")
	GuFilterFileName=replace(GuFilterFileName,",","_")
	GuFilterFileName=replace(GuFilterFileName,">","_")
	GuFilterFileName=replace(GuFilterFileName,"?","_")
	GuFilterFileName=replace(GuFilterFileName,"/","_")

end function


function GuFilterLinefeed(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuFilterLinefeed=""
		exit function
	end if

	GuFilterLinefeed=trim(StringData)
	GuFilterLinefeed=replace(GuFilterLinefeed,vbcrlf,"")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<br>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<BR>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<br />","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<BR />","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<p>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"<P>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"</p>","")
	GuFilterLinefeed=replace(GuFilterLinefeed,"</P>","")

end function


function GuFilterHTML(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuFilterHTML=""
		exit function
	end if

	dim REFH
	set REFH=New RegExp
	REFH.Global=true
	REFH.Pattern="<[^>]*>"
	GuFilterHTML=REFH.replace(StringData,"")
	REFH.Pattern="&.\w+;"
	GuFilterHTML=REFH.replace(GuFilterHTML,"")
	set REFH=nothing

end function


function GuFilterID(IDData)

	if trim(IDData)="" or isNull(IDData)=true then
		GuFilterID=""
		exit function
	end if

	GuFilterID=trim(IDData)
	GuFilterID=replace(GuFilterID,"~","")
	GuFilterID=replace(GuFilterID,"`","")
	GuFilterID=replace(GuFilterID,"!","")
	GuFilterID=replace(GuFilterID,"@","")
	GuFilterID=replace(GuFilterID,"#","")
	GuFilterID=replace(GuFilterID,"$","")
	GuFilterID=replace(GuFilterID,"%","")
	GuFilterID=replace(GuFilterID,"^","")
	GuFilterID=replace(GuFilterID,"&","")
	GuFilterID=replace(GuFilterID,"*","")
	GuFilterID=replace(GuFilterID,"(","")
	GuFilterID=replace(GuFilterID,")","")
	GuFilterID=replace(GuFilterID,"_","")
	GuFilterID=replace(GuFilterID,"-","")
	GuFilterID=replace(GuFilterID,"+","")
	GuFilterID=replace(GuFilterID,"=","")
	GuFilterID=replace(GuFilterID,"{","")
	GuFilterID=replace(GuFilterID,"[","")
	GuFilterID=replace(GuFilterID,"}","")
	GuFilterID=replace(GuFilterID,"]","")
	GuFilterID=replace(GuFilterID,":","")
	GuFilterID=replace(GuFilterID,";","")
	GuFilterID=replace(GuFilterID,"""","")
	GuFilterID=replace(GuFilterID,"'","")
	GuFilterID=replace(GuFilterID,"|","")
	GuFilterID=replace(GuFilterID,"\","")
	GuFilterID=replace(GuFilterID,"<","")
	GuFilterID=replace(GuFilterID,",","")
	GuFilterID=replace(GuFilterID,">","")
	GuFilterID=replace(GuFilterID,".","")
	GuFilterID=replace(GuFilterID,"?","")
	GuFilterID=replace(GuFilterID,"/","")
	GuFilterID=replace(GuFilterID," ","")

end function


function GuImageDimensionProportion(TableWidth,TableHeight,ImageWidth,ImageHeight,DimensionType)

	if trim(TableWidth)="" or isNull(TableWidth)=true or trim(TableHeight)="" or isNull(TableHeight)=true then
		GuImageDimensionProportion="16"
		exit function
	end if

	if trim(ImageWidth)="" or isNull(ImageWidth)=true or trim(ImageHeight)="" or isNull(ImageHeight)=true then
		GuImageDimensionProportion="16"
		exit function
	end if

	TableWidth=fix(cint(TableWidth))
	TableHeight=fix(cint(TableHeight))
	ImageWidth=fix(cint(ImageWidth))
	ImageHeight=fix(cint(ImageHeight))
	dim ProportionWidth,ProportionHeight,ProportionValue
	if (TableWidth>=ImageWidth) and (TableHeight>=ImageHeight) then
		ProportionWidth=ImageWidth
		ProportionHeight=ImageHeight
	else
		if (TableWidth/ImageWidth)=(TableHeight/ImageHeight) then
			ProportionWidth=TableWidth
			ProportionHeight=TableHeight
		else
			ProportionValue=TableWidth/ImageWidth
			if (ImageHeight*ProportionValue)>TableHeight then
				ProportionValue=TableHeight/ImageHeight
			end if
			ProportionWidth=ImageWidth*ProportionValue
			ProportionHeight=ImageHeight*ProportionValue
		end if
	end if

	if DimensionType="Width" then
		GuImageDimensionProportion=fix(ProportionWidth)
	elseif DimensionType="Height" then
		GuImageDimensionProportion=fix(ProportionHeight)
	else
		GuImageDimensionProportion="16"
	end if

end function


function GuLeftString(StringData,StringLength)

	if StringData="" or isNull(StringData)=true then
		GuLeftString=""
		exit function
	end if

	if StringLength="" or isNull(StringLength)=true or isNumeric(StringLength)=false then
		GuLeftString=""
		exit function
	end if

	if fix(StringLength)<=0 then
		GuLeftString=StringData
		exit function
	else
		StringLength=fix(StringLength)
	end if

	YY=0
	for ZZ=1 to len(StringData)
		if abs(ascw(mid(StringData,ZZ,1)))>255 then
			YY=YY+2
		else
			YY=YY+1
		end if

		if YY>=StringLength then
			exit for
		end if
	next

	if YY>StringLength then
		YY=StringLength
		ZZ=ZZ-1
	end if

	if YY=StringLength then
		if ZZ<len(StringData) then
			GuLeftString=left(StringData,ZZ-1)&".."
		else
			GuLeftString=StringData
		end if
	else
		GuLeftString=StringData
	end if

	GuLeftString=replace(GuLeftString,chr(10),"")

end function


function GuRandomString(RandomDigit)

	dim RandomArray(80),RandomOutput,RandomNumber
	for II=0 to 9
		RandomArray(II)=cstr(II)
	next
	for II=10 to 35
		RandomArray(II)=chr(II+55)
	next
	for II=36 to 61
		RandomArray(II)=chr(II+61)
	next
	randomize
	do while len(RandomOutput)<RandomDigit
		RandomNumber=RandomArray(int((61-0+1)*rnd+0))
		RandomOutput=RandomOutput+RandomNumber
	loop

	GuRandomString=RandomOutput

end function


function GuReplaceFilterRight(StringData,ReplaceData,FilterData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceFilterRight=""
		exit function
	end if

	if (trim(ReplaceData)="" or isNull(ReplaceData)=true) and (trim(FilterData)="" or isNull(FilterData)=true) then
		GuReplaceFilterRight=StringData
		exit function
	end if

	GuReplaceFilterRight=trim(StringData)

	if len(ReplaceData)>=1 then
		GuReplaceFilterRight=replace(GuReplaceFilterRight,ReplaceData,"")
	end if

	if len(FilterData)>=1 and right(GuReplaceFilterRight,1)=FilterData then
		GuReplaceFilterRight=left(GuReplaceFilterRight,len(GuReplaceFilterRight)-1)
	end if

	GuReplaceFilterRight=GuReplaceFilterRight

end function


function GuReplaceAccount(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceAccount=""
		exit function
	end if

	GuReplaceAccount=trim(StringData)
	GuReplaceAccount=replace(GuReplaceAccount,"~","")
	GuReplaceAccount=replace(GuReplaceAccount,"`","")
	GuReplaceAccount=replace(GuReplaceAccount,"!","")
	GuReplaceAccount=replace(GuReplaceAccount,"@","")
	GuReplaceAccount=replace(GuReplaceAccount,"#","")
	GuReplaceAccount=replace(GuReplaceAccount,"$","")
	GuReplaceAccount=replace(GuReplaceAccount,"%","")
	GuReplaceAccount=replace(GuReplaceAccount,"^","")
	GuReplaceAccount=replace(GuReplaceAccount,"&","")
	GuReplaceAccount=replace(GuReplaceAccount,"*","")
	GuReplaceAccount=replace(GuReplaceAccount,"+","")
	GuReplaceAccount=replace(GuReplaceAccount,"=","")
	GuReplaceAccount=replace(GuReplaceAccount,"{","")
	GuReplaceAccount=replace(GuReplaceAccount,"[","")
	GuReplaceAccount=replace(GuReplaceAccount,"}","")
	GuReplaceAccount=replace(GuReplaceAccount,"]","")
	GuReplaceAccount=replace(GuReplaceAccount,":","")
	GuReplaceAccount=replace(GuReplaceAccount,";","")
	GuReplaceAccount=replace(GuReplaceAccount,"'","")
	GuReplaceAccount=replace(GuReplaceAccount,"""","")
	GuReplaceAccount=replace(GuReplaceAccount,"|","")
	GuReplaceAccount=replace(GuReplaceAccount,"\","")
	GuReplaceAccount=replace(GuReplaceAccount,"<","")
	GuReplaceAccount=replace(GuReplaceAccount,",","")
	GuReplaceAccount=replace(GuReplaceAccount,">","")
	GuReplaceAccount=replace(GuReplaceAccount,"?","")
	GuReplaceAccount=replace(GuReplaceAccount,"/","")

end function


function GuReplaceLinefeed(StringData,ReplaceData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceLinefeed=""
		exit function
	end if

	if trim(ReplaceData)="" or isNull(ReplaceData)=true then
		ReplaceData="|"
	else
		ReplaceData=trim(ReplaceData)
	end if

	GuReplaceLinefeed=trim(StringData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,vbcrlf,ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<br>",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<BR>",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<br />",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<BR />",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<p>",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"<P>",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"</p>",ReplaceData)
	GuReplaceLinefeed=replace(GuReplaceLinefeed,"</P>",ReplaceData)

end function


function GuReplaceResourceName(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceResourceName=""
		exit function
	end if

	GuReplaceResourceName=trim(StringData)
	GuReplaceResourceName=replace(GuReplaceResourceName,"'","‘")
	GuReplaceResourceName=replace(GuReplaceResourceName,"""","“")

end function


function GuReplaceResourceOther(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceResourceOther=""
		exit function
	end if

	GuReplaceResourceOther=trim(StringData)
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"~","～")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"`","｀")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"#","＃")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"$","§")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"^","∧")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"*","＊")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"{","｛")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"}","｝")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,";","；")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"'","‘")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"""","“")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"\","＼")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"<","＜")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,",","，")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,">","＞")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"and","Ａnd")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"delete","Ｄelete")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"update","Ｕpdate")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"insert","Ｉnsert")
	GuReplaceResourceOther=replace(GuReplaceResourceOther,"select","Ｓelect")

end function


function GuReplaceSearchKeyword(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceSearchKeyword=""
		exit function
	end if

	GuReplaceSearchKeyword=trim(StringData)
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"~","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"`","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"!","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"@","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"#","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"$","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"%","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"^","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"&","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"*","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"+","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"=","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"{","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"[","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"}","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"]","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,":","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,";","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"'","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"""","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"|","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"\","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"<","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,",","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,">","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"?","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"/","n")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"and","Ａnd")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"delete","Ｄelete")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"update","ＵPdate")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"insert","Ｉnsert")
	GuReplaceSearchKeyword=replace(GuReplaceSearchKeyword,"select","Ｓelect")

end function


function GuReplaceString(StringData,ReplaceData)

	if StringData="" or isNull(StringData)=true then
		GuReplaceString=""
		exit function
	end if

	if ReplaceData="" or isNull(ReplaceData)=true or instr(ReplaceData,vbcrlf)<=0 or instr(ReplaceData,"==")<=0 then
		GuReplaceString=StringData
		exit function
	end if

	dim ReplaceSplitA,ReplaceSplitB
	ReplaceSplitA=split(ReplaceData,vbcrlf)
	for RR=0 to ubound(ReplaceSplitA)
		if len(ReplaceSplitA(RR))>=1 and instr(ReplaceSplitA(RR),"==")>=1 then
			ReplaceSplitB=split(ReplaceSplitA(RR),"==")
			StringData=replace(StringData,ReplaceSplitB(0),ReplaceSplitB(1))
		else
			StringData=StringData
		end if
	next

	GuReplaceString=StringData

end function


function GuReplaceVerticalline(StringData,ReplaceData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceVerticalline=""
		exit function
	end if

	if trim(ReplaceData)="" or isNull(ReplaceData)=true then
		ReplaceData=vbcrlf
	else
		ReplaceData=trim(ReplaceData)
	end if

	GuReplaceVerticalline=trim(StringData)
	GuReplaceVerticalline=replace(GuReplaceVerticalline,"|",ReplaceData)

end function


function GuReplaceIndexhtml(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceIndexhtml=""
		exit function
	end if

	GuReplaceIndexhtml=trim(StringData)
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuHrefSort",".html""")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&ArticleFolderHTML&"/")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"GuHrefSoftware href="""&WebsitePath&"/Software.asp?ID=","href="""&WebsitePath&"/"&SoftwareFolderHTML&"/")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuHrefArticle",".html""")
	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuHrefSoftware",".html""")
'	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,"/JavaScript.asp?Command=Advertising&Position=","/Include/Advertising_")
'	GuReplaceIndexhtml=replace(GuReplaceIndexhtml,""" GuJavaScriptAdvertising >",".js"">")

end function


function GuReplaceListhtml(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceListhtml=""
		exit function
	end if

	GuReplaceListhtml=trim(StringData)
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Site=&Sort=","href="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefSort",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&ArticleFolderHTML&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefArticle",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSoftware href="""&WebsitePath&"/Software.asp?ID=","href="""&WebsitePath&"/"&SoftwareFolderHTML&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefSoftware",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuHrefSort value="""&WebsitePath&"/List.asp?Site=&Sort=","value="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceListhtml=replace(GuReplaceListhtml,"&Column=&Keyword=&Option=&Field=&Order=&Page=","_")
	GuReplaceListhtml=replace(GuReplaceListhtml,"&Type=&Licence=&Country=&Language=_","_")
	GuReplaceListhtml=replace(GuReplaceListhtml,""" GuHrefPage",".html""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"_1.html",".html")
	GuReplaceListhtml=replace(GuReplaceListhtml,"method=""post"" name=""List_Pagination""","method=""get"" name=""List_Pagination""")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuPageonsubmit=","onsubmit=")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuFormPage onsubmit=","GuPageonsubmit=")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuPageonblur=","onblur=")
	GuReplaceListhtml=replace(GuReplaceListhtml,"GuFormPage onblur=","GuPageonblur=")
	GuReplaceListhtml=replace(GuReplaceListhtml,"_'+this.","&Page='+this.")

end function


function GuReplaceArticlehtml(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceArticlehtml=""
		exit function
	end if

	GuReplaceArticlehtml=trim(StringData)
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,""" GuHrefSort",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&ArticleFolderHTML&"/")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"GuHrefSoftware href="""&WebsitePath&"/Software.asp?ID=","href="""&WebsitePath&"/"&SoftwareFolderHTML&"/")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"&Page=","_")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,""" GuHrefArticle",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,""" GuHrefSoftware",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"_1.html"" GuHrefPage",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,".html"" GuHrefPage",".html""")
	GuReplaceArticlehtml=replace(GuReplaceArticlehtml,"&Version=ASP","&Version=HTML")

end function


function GuReplaceSoftwarehtml(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceSoftwarehtml=""
		exit function
	end if

	GuReplaceSoftwarehtml=trim(StringData)
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"GuHrefIndex href="""&WebsitePath&"/Index.asp","href="""&WebsitePath&"/Index.html")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"GuHrefSort href="""&WebsitePath&"/List.asp?Sort=","href="""&WebsitePath&"/"&ListFolderHTML&"/")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,""" GuHrefSort",".html""")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"GuHrefArticle href="""&WebsitePath&"/Article.asp?ID=","href="""&WebsitePath&"/"&ArticleFolderHTML&"/")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"GuHrefSoftware href="""&WebsitePath&"/Software.asp?ID=","href="""&WebsitePath&"/"&SoftwareFolderHTML&"/")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"&Page=","_")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,""" GuHrefArticle",".html""")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,""" GuHrefSoftware",".html""")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,"_1.html"" GuHrefPage",".html""")
	GuReplaceSoftwarehtml=replace(GuReplaceSoftwarehtml,".html"" GuHrefPage",".html""")

end function


function GuReplaceSitemapData(StringData,ReplaceOption)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceSitemapData=""
		exit function
	end if

	if trim(ReplaceOption)="" or isNull(ReplaceOption)=true or trim(ReplaceOption)="ASP" then
		GuReplaceSitemapData=StringData
		exit function
	end if

	GuReplaceSitemapData=trim(StringData)
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"Index.asp","Index.html")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"Article.asp?ID=",""&ArticleFolderHTML&"/")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"Software.asp?ID=",""&SoftwareFolderHTML&"/")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,"</loc>",".html</loc>")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,".html.html",".html")
	GuReplaceSitemapData=replace(GuReplaceSitemapData,".asp.html",".asp")

end function


function GuReplaceSendasp(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplaceSendasp=""
		exit function
	end if

	GuReplaceSendasp=trim(StringData)
	GuReplaceSendasp=replace(GuReplaceSendasp,SoftwareContentPageCode,"")
	GuReplaceSendasp=replace(GuReplaceSendasp,"src="&WebsitePath&"/"&AdminUploadSoftwareFolderParent&"/","src="&WebsiteDomain&"/"&WebsitePath&"/"&AdminUploadSoftwareFolderParent&"/")
	GuReplaceSendasp=replace(GuReplaceSendasp,"src="""&WebsitePath&"/"&AdminUploadSoftwareFolderParent&"/","src="""&WebsiteDomain&"/"&WebsitePath&"/"&AdminUploadSoftwareFolderParent&"/")

end function


function GuReplacePageCode(StringData)

	if trim(StringData)="" or isNull(StringData)=true then
		GuReplacePageCode=""
		exit function
	end if

	GuReplacePageCode=trim(StringData)
	GuReplacePageCode=replace(GuReplacePageCode,"~","_")
	GuReplacePageCode=replace(GuReplacePageCode,"`","_")
	GuReplacePageCode=replace(GuReplacePageCode,"%","_")
	GuReplacePageCode=replace(GuReplacePageCode,"^","_")
	GuReplacePageCode=replace(GuReplacePageCode,"&","_")
	GuReplacePageCode=replace(GuReplacePageCode,"*","_")
	GuReplacePageCode=replace(GuReplacePageCode,"-","_")
	GuReplacePageCode=replace(GuReplacePageCode,"+","_")
	GuReplacePageCode=replace(GuReplacePageCode,"=","_")
	GuReplacePageCode=replace(GuReplacePageCode,":","_")
	GuReplacePageCode=replace(GuReplacePageCode,";","_")
	GuReplacePageCode=replace(GuReplacePageCode,"""","_")
	GuReplacePageCode=replace(GuReplacePageCode,"'","_")
	GuReplacePageCode=replace(GuReplacePageCode,"\","_")
	GuReplacePageCode=replace(GuReplacePageCode,"<","_")
	GuReplacePageCode=replace(GuReplacePageCode,",","_")
	GuReplacePageCode=replace(GuReplacePageCode,">","_")
	GuReplacePageCode=replace(GuReplacePageCode,".","_")
	GuReplacePageCode=replace(GuReplacePageCode,"?","_")
	GuReplacePageCode=replace(GuReplacePageCode,"/","_")
	GuReplacePageCode=replace(GuReplacePageCode," ","_")

end function


function GuHTML2JavaScript(StringData)

	if StringData="" or isNull(StringData)=true then
		GuHTML2JavaScript=""
		exit function
	end if

	StringData=trim(StringData)
	StringData=replace(StringData,chr(10),"")
	StringData=replace(StringData,chr(32)&chr(32),"")
	StringData=split(StringData,chr(13))
	GuHTML2JavaScript=""

	for HH=0 to ubound(StringData)
		if len(trim(StringData(HH)))>=1 then
			StringData(HH)=replace(StringData(HH),chr(34),chr(92)&chr(34))
			StringData(HH)=replace(StringData(HH),chr(39),chr(92)&chr(39))
'			StringData(HH)=replace(StringData(HH),chr(47),chr(92)&chr(47))
			GuHTML2JavaScript=GuHTML2JavaScript&"document.write("&chr(34)&StringData(HH)&chr(34)&");"&chr(10)
		end if
	next

	GuHTML2JavaScript=GuHTML2JavaScript

end function


function GuFlashPlayerLoad(FlashID,FlashPath,FlashVars,FlashWidth,FlashHeight,FlashAllowScriptAccess,FlashBGColor,FlashWMode)

	if trim(FlashID)="" or isNull(FlashID)=true then
		GuFlashPlayerLoad=""
		exit function
	end if

	if trim(FlashPath)="" or isNull(FlashPath)=true then
		GuFlashPlayerLoad=""
		exit function
	end if

	if trim(FlashWidth)="" or isNull(FlashWidth)=true then
		FlashWidth="100"
	else
		FlashWidth=fix(FlashWidth)
	end if

	if trim(FlashHeight)="" or isNull(FlashHeight)=true then
		FlashHeight="72"
	else
		FlashHeight=fix(FlashHeight)
	end if

	if trim(FlashWMode)="" or isNull(FlashWMode)=true then
		FlashWMode="opaque"
	else
		FlashWMode=FlashWMode
	end if

	GuFlashPlayerLoad="<object id='GuFlashPlayer_"&FlashID&"' classid='clsid:D27CDB6E-AE6D-11CF-96B8-444553540000' codebase='http://fpdownload.macromedia.com/get/shockwave/cabs/flash/swflash.cab#version=7,0,0,0' width='"&FlashWidth&"' height='"&FlashHeight&"' border='0' align=''>" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='movie' value='"&FlashPath&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='flashvars' value='"&FlashVars&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='quality' value='high' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='bgcolor' value='"&FlashBGColor&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<param name='wmode' value='"&FlashWMode&"' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"<embed type='application/x-shockwave-flash' name='GuFlashPlayer_"&FlashID&"' pluginspage='http://www.adobe.com/go/getflashplayer' src='"&FlashPath&"' flashVars='"&FlashVars&"' width='"&FlashWidth&"' height='"&FlashHeight&"' allowScriptAccess='"&FlashAllowScriptAccess&"' quality='high' bgcolor='"&FlashBGColor&"' wmode='"&FlashWMode&"' align='' />" &vbcrlf
	GuFlashPlayerLoad=GuFlashPlayerLoad&"</object>"

end function


function GuServerObjectCheck(ObjectString)

	on error resume next
	GuServerObjectCheck=false
	Err=0
	dim SCOS
	set SCOS=Server.CreateObject(ObjectString)
	if 0=Err then
		GuServerObjectCheck=true
	end if
	set SCOS=nothing
	Err=0

end function


function GuServerObjectVersionGet(ObjectString)

	on error resume next
	GuServerObjectVersionGet=""
	Err=0
	dim SCOS
	set SCOS=Server.CreateObject(ObjectString)
	if 0=Err then
		GuServerObjectVersionGet=SCOS.Version
	end if
	set SCOS=nothing
	Err=0

end function


function GuResourceStatusText(ResourceStatusCode)

	if trim(ResourceStatusCode)="" or isNull(ResourceStatusCode)=true then
		GuResourceStatusText="--"
		exit function
	end if

	select case ResourceStatusCode
	case "Approve"
		GuResourceStatusText="审核通过"
	case "Approving"
		GuResourceStatusText="审核中"
	case "Delete"
		GuResourceStatusText="删除[注销]"
	case "Disabled"
		GuResourceStatusText="禁用"
	case "Enabled"
		GuResourceStatusText="启用"
	case "Expire"
		GuResourceStatusText="过期"
	case "Hidden"
		GuResourceStatusText="隐藏"
	case "Normal"
		GuResourceStatusText="正常"
	case "Read"
		GuResourceStatusText="已读"
	case "Show"
		GuResourceStatusText="显示"
	case "Wait"
		GuResourceStatusText="等待"
	case "Unread"
		GuResourceStatusText="未读"
	case "Used"
		GuResourceStatusText="已用"
	case else
		GuResourceStatusText="--"
	end select

	GuResourceStatusText=GuResourceStatusText

end function


function GuSortTypeText(SortTypeCode)

	if trim(SortTypeCode)="" or isNull(SortTypeCode)=true then
		GuSortTypeText="--"
		exit function
	end if

	select case SortTypeCode
	case "SortAArticle"
		GuSortTypeText="文章类别"
	case "SortBArticle"
		GuSortTypeText="文章分类"
	case "SortABook"
		GuSortTypeText="书籍类别"
	case "SortBBook"
		GuSortTypeText="书籍分类"
	case "SortASoftware"
		GuSortTypeText="软件类别"
	case "SortBSoftware"
		GuSortTypeText="软件分类"
	case "SortALink"
		GuSortTypeText="菜单链接"
	case "SortBLink"
		GuSortTypeText="分类链接"
	case else
		GuSortTypeText="--"
	end select

	GuSortTypeText=GuSortTypeText

end function


function GuWebPageSourceGet(WebpageAddress)

	if trim(WebpageAddress)="" or isNull(WebpageAddress)=true then
		GuWebPageSourceGet=""
		exit function
	end if

	dim MXPS
'	set MXPS=Server.CreateObject("Microsoft.XMLHTTP")
'	set MXPS=Server.CreateObject("MSXML2.ServerXMLHTTP")
'	set MXPS=Server.CreateObject("MSXML2.ServerXMLHTTP.3.0")
	set MXPS=Server.CreateObject("MSXML2.ServerXMLHTTP.6.0")
	MXPS.SetTimeouts 10000,30000,30000,30000
	MXPS.open "get",WebpageAddress,false
	MXPS.send()
	set ASFR=Server.CreateObject("Adodb.Stream")
	ASFR.type=1
	ASFR.mode=3
	ASFR.open
	ASFR.write MXPS.ResponseBody
	ASFR.position=0
	ASFR.type=2
	ASFR.charset="UTF-8"
	FileContent=ASFR.ReadText
	ASFR.close
	set ASFR=nothing
	set MXPS=nothing
	GuWebPageSourceGet=FileContent

end function


function GuURLEncoding(URLEncoding0)

	dim URLEncoding1,StringSpecial,StringThischr,StringInnercode,StringHight8,StringLow8

	StringSpecial="!""#$%&'()*+,/:;<=>?@[\]^`{|}~%"
	URLEncoding1=""
	for UU=1 to len(URLEncoding0)
	StringThischr=mid(URLEncoding0,UU,1)
	if abs(asc(StringThischr)) < &hff then
		if StringThischr=" " then
			URLEncoding1=URLEncoding1 & "+"
		elseif instr(StringSpecial,StringThischr)>0 then
			URLEncoding1=URLEncoding1 & "%" & hex(asc(StringThischr))
		else
			URLEncoding1=URLEncoding1 & StringThischr
		end if
	else
		StringInnercode=asc(StringThischr)
		if StringInnercode<0 then
			StringInnercode=StringInnercode + &h10000
		end if
		StringHight8=(StringInnercode and &hff00)\ &hff
		StringLow8=StringInnercode and &hff
		URLEncoding1=URLEncoding1& "%" & hex(StringHight8) & "%" & hex(StringLow8)
	end if
	next

	GuURLEncoding=URLEncoding1

end function


class GuImageDimensionClass

	dim ASID
	private sub class_Initialize
		set ASID=Server.CreateObject("Adodb.Stream")
		ASID.Mode=3
		ASID.Type=1
		ASID.Open
	end sub

	private sub class_Terminate
		set ASID=nothing
	end sub

	private function Bin2Str(Bin)
		dim Str,clow
		for II=1 to LenB(Bin)
		clow=MidB(Bin,II,1)
		if ASCB(clow)<128 then
			Str = Str & Chr(ASCB(clow))
		else
			II=II+1
			if II <= LenB(Bin) then
				Str = Str & Chr(ASCW(MidB(Bin,II,1)&clow))
			end if
		end if
		next
		Bin2Str = Str
	end function

	private function Num2Str(num,base,lens)
		dim ret
		ret = ""
		while(num>=base)
		ret = (num mod base) & ret
		num = (num - num mod base)/base
		wend
		Num2Str = right(string(lens,"0") & num & ret,lens)
	end function

	private function Str2Num(str,base)
		dim ret
		ret = 0
		for II=1 to len(str)
			ret = ret *base + cint(mid(str,II,1))
		next
		Str2Num=ret
	end function

	private function BinVal(bin)
		dim ret
		ret = 0
		for II = lenb(bin) to 1 step -1
			ret = ret *256 + ascb(midb(bin,II,1))
		next
		BinVal=ret
	end function

	private function BinVal2(bin)
		dim ret
		ret = 0
		for II = 1 to lenb(bin)
			ret = ret *256 + ascb(midb(bin,II,1))
		next
		BinVal2=ret
	end function

	function GuImageDimensionGet(filespec)
		dim ret(3),bFlag,p1,binData,sConv,nBits
		ASID.LoadFromFile(filespec)
		bFlag=ASID.read(3)
		select case hex(binVal(bFlag))
		case "4E5089":
			ASID.read(15)
			ret(0)="PNG"
			ret(1)=BinVal2(ASID.read(2))
			ASID.read(2)
			ret(2)=BinVal2(ASID.read(2))
		case "464947":
			ASID.read(3)
			ret(0)="GIF"
			ret(1)=BinVal(ASID.read(2))
			ret(2)=BinVal(ASID.read(2))
		case "535746":
			ASID.read(5)
			binData=ASID.Read(1)
			sConv=Num2Str(ascb(binData),2 ,8)
			nBits=Str2Num(left(sConv,5),2)
			sConv=mid(sConv,6)
			while(len(sConv)<nBits*4)
			binData=ASID.Read(1)
			sConv=sConv&Num2Str(ascb(binData),2 ,8)
			wend
			ret(0)="SWF"
			ret(1)=int(abs(Str2Num(mid(sConv,1*nBits+1,nBits),2)-Str2Num(mid(sConv,0*nBits+1,nBits),2))/20)
			ret(2)=int(abs(Str2Num(mid(sConv,3*nBits+1,nBits),2)-Str2Num(mid(sConv,2*nBits+1,nBits),2))/20)
		case "FFD8FF":
			do
			do: p1=binVal(ASID.Read(1)): loop while p1=255 and not ASID.eos
			if p1>191 and p1<196 then exit do else ASID.read(binval2(ASID.Read(2))-2)
			do:p1=binVal(ASID.Read(1)):loop while p1<255 and not ASID.eos
			loop while true
			ASID.Read(3)
			ret(0)="JPG"
			ret(2)=binval2(ASID.Read(2))
			ret(1)=binval2(ASID.Read(2))
		case else:
			if left(Bin2Str(bFlag),2)="BM" then
			ASID.Read(15)
			ret(0)="BMP"
			ret(1)=binval(ASID.Read(4))
			ret(2)=binval(ASID.Read(4))
		else
			ret(0)=""
			end if
		end select
		ret(3)="width=""" & ret(1) &""" height=""" & ret(2) &""""
		GuImageDimensionGet=ret
	end function

'	Examples：
'	dim IDWH,AEID
'	set IDWH=new GuImageDimensionClass
'	AEID=IDWH.GuImageDimensionGet(Server.MapPath("/Style/Green/Logo.png"))
'	response.write "Image Type："&AEID(0)
'	response.write "Image Width："&AEID(1)
'	response.write "Image Height："&AEID(2)
'	response.write "Image Width and Height："&AEID(3)
'	set IDWH=nothing

end class

%>

