/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Process;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.IDaemonClient;
import com.marswin89.marsdaemon.IDaemonStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class DaemonClient
implements IDaemonClient {
    private DaemonConfigurations mConfigurations;
    private final String DAEMON_PERMITTING_SP_FILENAME = "d_permit";
    private final String DAEMON_PERMITTING_SP_KEY = "permitted";
    private BufferedReader mBufferedReader;

    public DaemonClient(DaemonConfigurations configurations) {
        this.mConfigurations = configurations;
    }

    @Override
    public void onAttachBaseContext(Context base) {
        this.initDaemon(base);
    }

    private void initDaemon(Context base) {
        if (!this.isDaemonPermitting(base) || this.mConfigurations == null) {
            return;
        }
        String processName = this.getProcessName();
        String packageName = base.getPackageName();
        if (processName.startsWith(this.mConfigurations.PERSISTENT_CONFIG.PROCESS_NAME)) {
            IDaemonStrategy.Fetcher.fetchStrategy().onPersistentCreate(base, this.mConfigurations);
        } else if (processName.startsWith(this.mConfigurations.DAEMON_ASSISTANT_CONFIG.PROCESS_NAME)) {
            IDaemonStrategy.Fetcher.fetchStrategy().onDaemonAssistantCreate(base, this.mConfigurations);
        } else if (processName.startsWith(packageName)) {
            IDaemonStrategy.Fetcher.fetchStrategy().onInitialization(base);
        }
        this.releaseIO();
    }

    private String getProcessName() {
        try {
            File file = new File("/proc/" + Process.myPid() + "/" + "cmdline");
            this.mBufferedReader = new BufferedReader(new FileReader(file));
            return this.mBufferedReader.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void releaseIO() {
        if (this.mBufferedReader != null) {
            try {
                this.mBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mBufferedReader = null;
        }
    }

    private boolean isDaemonPermitting(Context context) {
        SharedPreferences sp = context.getSharedPreferences("d_permit", 0);
        return sp.getBoolean("permitted", true);
    }

    protected boolean setDaemonPermiiting(Context context, boolean isPermitting) {
        SharedPreferences sp = context.getSharedPreferences("d_permit", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean("permitted", isPermitting);
        return editor.commit();
    }
}

