/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon;

import android.content.Context;
import android.os.Build;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.strategy.DaemonStrategy21;
import com.marswin89.marsdaemon.strategy.DaemonStrategy22;
import com.marswin89.marsdaemon.strategy.DaemonStrategy23;
import com.marswin89.marsdaemon.strategy.DaemonStrategyUnder21;
import com.marswin89.marsdaemon.strategy.DaemonStrategyXiaomi;

public interface IDaemonStrategy {
    public boolean onInitialization(Context var1);

    public void onPersistentCreate(Context var1, DaemonConfigurations var2);

    public void onDaemonAssistantCreate(Context var1, DaemonConfigurations var2);

    public void onDaemonDead();

    public static class Fetcher {
        private static IDaemonStrategy mDaemonStrategy;

        static IDaemonStrategy fetchStrategy() {
            if (mDaemonStrategy != null) {
                return mDaemonStrategy;
            }
            int sdk = Build.VERSION.SDK_INT;
            switch (sdk) {
                case 23: {
                    mDaemonStrategy = new DaemonStrategy23();
                    break;
                }
                case 22: {
                    mDaemonStrategy = new DaemonStrategy22();
                    break;
                }
                case 21: {
                    if ("MX4 Pro".equalsIgnoreCase(Build.MODEL)) {
                        mDaemonStrategy = new DaemonStrategyUnder21();
                        break;
                    }
                    mDaemonStrategy = new DaemonStrategy21();
                    break;
                }
                default: {
                    mDaemonStrategy = Build.MODEL != null && Build.MODEL.toLowerCase().startsWith("mi") ? new DaemonStrategyXiaomi() : (Build.MODEL != null && Build.MODEL.toLowerCase().startsWith("a31") ? new DaemonStrategy21() : new DaemonStrategyUnder21());
                }
            }
            return mDaemonStrategy;
        }
    }
}

