/*
 * Decompiled with CFR 0.152.
 */
package com.marswin89.marsdaemon.strategy;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.marswin89.marsdaemon.DaemonConfigurations;
import com.marswin89.marsdaemon.IDaemonStrategy;
import com.marswin89.marsdaemon.nativ.NativeDaemonAPI20;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DaemonStrategyUnder21
implements IDaemonStrategy {
    private final String BINARY_DEST_DIR_NAME = "bin";
    private final String BINARY_FILE_NAME = "daemon";
    private AlarmManager mAlarmManager;
    private PendingIntent mPendingIntent;

    @Override
    public boolean onInitialization(Context context) {
        return this.installBinary(context);
    }

    @Override
    public void onPersistentCreate(final Context context, final DaemonConfigurations configs) {
        this.initAlarm(context, configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME);
        Thread t = new Thread(){

            @Override
            public void run() {
                File binaryFile = new File(context.getDir("bin", 0), "daemon");
                new NativeDaemonAPI20(context).doDaemon(context.getPackageName(), configs.DAEMON_ASSISTANT_CONFIG.SERVICE_NAME, binaryFile.getAbsolutePath());
            }
        };
        t.setPriority(10);
        t.start();
        if (configs != null && configs.LISTENER != null) {
            configs.LISTENER.onPersistentStart(context);
        }
    }

    @Override
    public void onDaemonAssistantCreate(Context context, DaemonConfigurations configs) {
        Intent intent = new Intent();
        ComponentName component = new ComponentName(context.getPackageName(), configs.PERSISTENT_CONFIG.SERVICE_NAME);
        intent.setComponent(component);
        context.startService(intent);
        if (configs != null && configs.LISTENER != null) {
            configs.LISTENER.onWatchDaemonDaed();
        }
        Process.killProcess((int)Process.myPid());
    }

    @Override
    public void onDaemonDead() {
        this.mAlarmManager.setRepeating(3, SystemClock.elapsedRealtime(), 100L, this.mPendingIntent);
        Process.killProcess((int)Process.myPid());
    }

    private void initAlarm(Context context, String serviceName) {
        if (this.mAlarmManager == null) {
            this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        }
        if (this.mPendingIntent == null) {
            Intent intent = new Intent();
            ComponentName component = new ComponentName(context.getPackageName(), serviceName);
            intent.setComponent(component);
            intent.setFlags(16);
            this.mPendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0);
        }
        this.mAlarmManager.cancel(this.mPendingIntent);
    }

    private boolean installBinary(Context context) {
        String binaryDirName = null;
        String abi = Build.CPU_ABI;
        binaryDirName = abi.startsWith("armeabi-v7a") ? "armeabi-v7a" : (abi.startsWith("x86") ? "x86" : "armeabi");
        return this.install(context, "bin", binaryDirName, "daemon");
    }

    private boolean install(Context context, String destDirName, String assetsDirName, String filename) {
        File file = new File(context.getDir(destDirName, 0), filename);
        if (file.exists()) {
            return true;
        }
        try {
            this.copyAssets(context, (TextUtils.isEmpty((CharSequence)assetsDirName) ? "" : assetsDirName + File.separator) + filename, file, "700");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void copyAssets(Context context, String assetsFilename, File file, String mode) throws IOException, InterruptedException {
        AssetManager manager = context.getAssets();
        InputStream is = manager.open(assetsFilename);
        this.copyFile(file, is, mode);
    }

    private void copyFile(File file, InputStream is, String mode) throws IOException, InterruptedException {
        int len;
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        String abspath = file.getAbsolutePath();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        is.close();
        Runtime.getRuntime().exec("chmod " + mode + " " + abspath).waitFor();
    }
}

