/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.CipherSuite;
import cn.jmessage.support.okhttp3.TlsVersion;
import cn.jmessage.support.okhttp3.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    public static final ConnectionSpec RESTRICTED_TLS;
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec CLEARTEXT;
    final boolean tls;
    final boolean supportsTlsExtensions;
    @Nullable
    final String[] cipherSuites;
    @Nullable
    final String[] tlsVersions;
    private static final String[] z;

    ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    public final boolean isTls() {
        return this.tls;
    }

    @Nullable
    public final List<CipherSuite> cipherSuites() {
        if (this.cipherSuites != null) {
            return CipherSuite.forJavaNames(this.cipherSuites);
        }
        return null;
    }

    @Nullable
    public final List<TlsVersion> tlsVersions() {
        if (this.tlsVersions != null) {
            return TlsVersion.forJavaNames(this.tlsVersions);
        }
        return null;
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    final void apply(SSLSocket sSLSocket, boolean bl) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    private ConnectionSpec supportedSpec(SSLSocket stringArray, boolean bl) {
        String[] stringArray2 = this.cipherSuites != null ? Util.intersect(CipherSuite.ORDER_BY_NAME, stringArray.getEnabledCipherSuites(), this.cipherSuites) : stringArray.getEnabledCipherSuites();
        String[] stringArray3 = this.tlsVersions != null ? Util.intersect(Util.NATURAL_ORDER, stringArray.getEnabledProtocols(), this.tlsVersions) : stringArray.getEnabledProtocols();
        stringArray = stringArray.getSupportedCipherSuites();
        int n2 = Util.indexOf(CipherSuite.ORDER_BY_NAME, stringArray, z[5]);
        if (bl && n2 != -1) {
            stringArray2 = Util.concat(stringArray2, stringArray[n2]);
        }
        return new Builder(this).cipherSuites(stringArray2).tlsVersions(stringArray3).build();
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.ORDER_BY_NAME, this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        if (this.tls != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (this.tls) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n2 = 17;
        if (this.tls) {
            n2 = 527 + Arrays.hashCode(this.cipherSuites);
            n2 = 31 * n2 + Arrays.hashCode(this.tlsVersions);
            n2 = 31 * n2 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return n2;
    }

    public final String toString() {
        if (!this.tls) {
            return z[2];
        }
        String string = this.cipherSuites != null ? this.cipherSuites().toString() : z[1];
        String string2 = this.tlsVersions != null ? this.tlsVersions().toString() : z[1];
        return z[3] + string + z[0] + string2 + z[4] + this.supportsTlsExtensions + ")";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "!e);F[ /$\\b+.j";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 13;
                                break;
                            }
                            case 1: {
                                n9 = 69;
                                break;
                            }
                            case 2: {
                                n9 = 93;
                                break;
                            }
                            case 3: {
                                n9 = 87;
                                break;
                            }
                            default: {
                                n9 = 53;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "V$1;\u0015h+<5Yh!\u0000";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "N*39Pn148[^584\u001d$";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "N*39Pn148[^584\u001dn,-?P\u007f\u0016(>Ah6`";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "!e.\"E}*/#FY).\u0012My 3$\\b+.j";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "Y\t\u000e\bsL\t\u0011\u0015tN\u000e\u0002\u0004v^\u0013";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        RESTRICTED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256};
        APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
        RESTRICTED_TLS = new Builder(true).cipherSuites(RESTRICTED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        MODERN_TLS = new Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    public static final class Builder {
        boolean tls;
        @Nullable
        String[] cipherSuites;
        @Nullable
        String[] tlsVersions;
        boolean supportsTlsExtensions;
        private static final String[] z;

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        public final Builder allEnabledCipherSuites() {
            if (!this.tls) {
                throw new IllegalStateException(z[0]);
            }
            this.cipherSuites = null;
            return this;
        }

        public final Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (!this.tls) {
                throw new IllegalStateException(z[0]);
            }
            String[] stringArray = new String[cipherSuiteArray.length];
            for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
                stringArray[i2] = cipherSuiteArray[i2].javaName;
            }
            return this.cipherSuites(stringArray);
        }

        public final Builder cipherSuites(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException(z[0]);
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException(z[1]);
            }
            this.cipherSuites = (String[])stringArray.clone();
            return this;
        }

        public final Builder allEnabledTlsVersions() {
            if (!this.tls) {
                throw new IllegalStateException(z[2]);
            }
            this.tlsVersions = null;
            return this;
        }

        public final Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (!this.tls) {
                throw new IllegalStateException(z[2]);
            }
            String[] stringArray = new String[tlsVersionArray.length];
            for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
                stringArray[i2] = tlsVersionArray[i2].javaName;
            }
            return this.tlsVersions(stringArray);
        }

        public final Builder tlsVersions(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException(z[2]);
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException(z[3]);
            }
            this.tlsVersions = (String[])stringArray.clone();
            return this;
        }

        public final Builder supportsTlsExtensions(boolean bl) {
            if (!this.tls) {
                throw new IllegalStateException(z[4]);
            }
            this.supportsTlsExtensions = bl;
            return this;
        }

        public final ConnectionSpec build() {
            return new ConnectionSpec(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u001cSNVF\u0002T\u000bG\u000f\u0001I\u0007AJ\u0001\u001c\bZ]R_\u0002PN\u0000H\u000bM[R_\u0001[A\u0017_\u001a\\@\u001cO";
            int n3 = -1;
            block12: while (true) {
                char[] cArray;
                block17: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block16: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block16;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block17;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 114;
                                    break;
                                }
                                case 1: {
                                    n9 = 60;
                                    break;
                                }
                                case 2: {
                                    n9 = 110;
                                    break;
                                }
                                case 3: {
                                    n9 = 53;
                                    break;
                                }
                                default: {
                                    n9 = 47;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "3HNYJ\u0013O\u001a\u0015@\u001cYNVF\u0002T\u000bG\u000f\u0001I\u0007AJRU\u001d\u0015]\u0017M\u001b\\]\u0017X";
                        n3 = 0;
                        continue block12;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u001cSNac!\u001c\u0018P]\u0001U\u0001[\\RZ\u0001G\u000f\u0011P\u000bT]\u0006Y\u0016A\u000f\u0011S\u0000[J\u0011H\u0007ZA\u0001";
                        n3 = 1;
                        continue block12;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "3HNYJ\u0013O\u001a\u0015@\u001cYNac!\u001c\u0018P]\u0001U\u0001[\u000f\u001bONGJ\u0003I\u0007GJ\u0016";
                        n3 = 2;
                        continue block12;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "\u001cSNac!\u001c\u000bM[\u0017R\u001d\\@\u001cONS@\u0000\u001c\rYJ\u0013N\u001aPW\u0006\u001c\rZA\u001cY\rAF\u001dR\u001d";
                        n3 = 3;
                        continue block12;
                    }
                    case 3: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

