/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.ResponseBody;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final RequestBody EMPTY_REQUEST;
    private static final ByteString UTF_8_BOM;
    private static final ByteString UTF_16_BE_BOM;
    private static final ByteString UTF_16_LE_BOM;
    private static final ByteString UTF_32_BE_BOM;
    private static final ByteString UTF_32_LE_BOM;
    public static final Charset UTF_8;
    public static final Charset ISO_8859_1;
    private static final Charset UTF_16_BE;
    private static final Charset UTF_16_LE;
    private static final Charset UTF_32_BE;
    private static final Charset UTF_32_LE;
    public static final TimeZone UTC;
    public static final Comparator<String> NATURAL_ORDER;
    private static final Method addSuppressedExceptionMethod;
    private static final Pattern VERIFY_AS_IP_ADDRESS;
    private static final String[] z;

    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        if (addSuppressedExceptionMethod != null) {
            try {
                addSuppressedExceptionMethod.invoke((Object)throwable, throwable2);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(Socket object) {
        if (object != null) {
            try {
                ((Socket)object).close();
                return;
            }
            catch (AssertionError assertionError) {
                object = assertionError;
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw object;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l2 + Math.min(l3, timeUnit.toNanos(n2)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
        finally {
            if (l3 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l2 + l3);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(final String string, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public final Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, string);
                ((Thread)runnable).setDaemon(bl);
                return runnable;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : stringArray) {
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray3[i2];
                if (comparator.compare(string, string2) != 0) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray3[i2];
                if (comparator.compare(string, string2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string;
        String string2 = string = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        if (bl || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme())) {
            return string + ":" + httpUrl.port();
        }
        return string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains(z[2]);
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(stringArray[i2], string) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string, int n2, int n3) {
        while (n2 < n3) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n2;
                }
            }
            ++n2;
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            switch (string.charAt(n3)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n3 + 1;
                }
            }
            --n3;
        }
        return n2;
    }

    public static String trimSubstring(String string, int n2, int n3) {
        n2 = Util.skipLeadingAsciiWhitespace(string, n2, n3);
        n3 = Util.skipTrailingAsciiWhitespace(string, n2, n3);
        return string.substring(n2, n3);
    }

    public static int delimiterOffset(String string, int n2, int n3, String string2) {
        while (n2 < n3) {
            if (string2.indexOf(string.charAt(n2)) != -1) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int delimiterOffset(String string, int n2, int n3, char c2) {
        while (n2 < n3) {
            if (string.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static String canonicalizeHost(String string) {
        if (string.contains(":")) {
            Object object = string.startsWith("[") && string.endsWith("]") ? Util.decodeIpv6(string, 1, string.length() - 1) : Util.decodeIpv6(string, 0, string.length());
            if (object == null) {
                return null;
            }
            byte[] byArray = ((InetAddress)object).getAddress();
            object = byArray;
            if (byArray.length == 16) {
                return Util.inet6AddressToAscii((byte[])object);
            }
            throw new AssertionError((Object)(z[4] + string + "'"));
        }
        try {
            String string2 = IDN.toASCII(string).toLowerCase(Locale.US);
            if (string2.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(string2)) {
                return null;
            }
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                return true;
            }
            if (z[9].indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string) {
        return VERIFY_AS_IP_ADDRESS.matcher(string).matches();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        if (bufferedSource.rangeEquals(0L, UTF_8_BOM)) {
            bufferedSource.skip(UTF_8_BOM.size());
            return UTF_8;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_BE_BOM)) {
            bufferedSource.skip(UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_LE_BOM)) {
            bufferedSource.skip(UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_BE_BOM)) {
            bufferedSource.skip(UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_LE_BOM)) {
            bufferedSource.skip(UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String string, long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + z[7]);
        }
        if (timeUnit == null) {
            throw new NullPointerException(z[8]);
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + z[5]);
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException(string + z[6]);
        }
        return (int)l3;
    }

    public static AssertionError assertionError(String object, Exception exception) {
        object = new AssertionError(object);
        try {
            ((Throwable)object).initCause(exception);
        }
        catch (IllegalStateException illegalStateException) {}
        return object;
    }

    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    @Nullable
    private static InetAddress decodeIpv6(String string, int n2, int n3) {
        byte[] byArray = new byte[16];
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (n2 < n3) {
            int n7;
            if (n4 == 16) {
                return null;
            }
            if (n2 + 2 <= n3 && string.regionMatches(n2, z[3], 0, 2)) {
                if (n5 != -1) {
                    return null;
                }
                n5 = n4 += 2;
                if ((n2 += 2) == n3) {
                    break;
                }
            } else if (n4 != 0 && !string.regionMatches(n2, ":", 0, 1)) {
                if (string.regionMatches(n2, ".", 0, 1)) {
                    if (!Util.decodeIpv4Suffix(string, n6, n3, byArray, n4 - 2)) {
                        return null;
                    }
                    n4 += 2;
                    break;
                }
                return null;
            }
            int n8 = 0;
            n6 = ++n2;
            while (n2 < n3 && (n7 = Util.decodeHexDigit(string.charAt(n2))) != -1) {
                n8 = (n8 << 4) + n7;
                ++n2;
            }
            n7 = n2 - n6;
            if (n7 == 0 || n7 > 4) {
                return null;
            }
            byArray[n4++] = (byte)(n8 >>> 8 & 0xFF);
            byArray[n4++] = (byte)(n8 & 0xFF);
        }
        if (n4 != 16) {
            if (n5 == -1) {
                return null;
            }
            System.arraycopy(byArray, n5, byArray, 16 - (n4 - n5), n4 - n5);
            Arrays.fill(byArray, n5, n5 + (16 - n4), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String string, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4;
        while (n2 < n3) {
            char c2;
            if (n5 == byArray.length) {
                return false;
            }
            if (n5 != n4 && string.charAt(n2) != '.') {
                return false;
            }
            int n6 = 0;
            int n7 = ++n2;
            while (n2 < n3 && (c2 = string.charAt(n2)) >= '0' && c2 <= '9') {
                if (n6 == 0 && n7 != n2) {
                    return false;
                }
                if ((n6 = n6 * 10 + c2 - 48) > 255) {
                    return false;
                }
                ++n2;
            }
            if (n2 - n7 == 0) {
                return false;
            }
            byArray[n5++] = (byte)n6;
        }
        return n5 == n4 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            n3 = i2;
            while (i2 < 16 && byArray[i2] == 0 && byArray[i2 + 1] == 0) {
                i2 += 2;
            }
            n2 = i2 - n3;
            if (n2 <= n5 || n2 < 4) continue;
            n4 = n3;
            n5 = n2;
        }
        Buffer buffer = new Buffer();
        n3 = 0;
        while (n3 < byArray.length) {
            if (n3 == n4) {
                buffer.writeByte(58);
                if ((n3 += n5) != 16) continue;
                buffer.writeByte(58);
                continue;
            }
            if (n3 > 0) {
                buffer.writeByte(58);
            }
            n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
            buffer.writeHexadecimalUnsignedLong(n2);
            n3 += 2;
        }
        return buffer.readUtf8();
    }

    public static X509TrustManager platformTrustManager() {
        try {
            Object[] objectArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            objectArray.init((KeyStore)null);
            objectArray = objectArray.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException(z[0] + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError(z[1], generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Method method;
        block28: {
            String string;
            String[] stringArray = new String[10];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "xA\\.\tHLM3\u001d\rK\\0\u0018XCMv\r_ZJ\"Y@NW7\u001eH]Jl";
            int n3 = -1;
            block26: while (true) {
                switch (n3) {
                    default: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "c@\u0019\u0005\u0000^[\\;Yycj";
                        n3 = 0;
                        continue block26;
                    }
                    case 0: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "JJM%\u0016NDW7\u0014H\u000f_7\u0010AJ]";
                        n3 = 1;
                        continue block26;
                    }
                    case 1: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u0017\u0015";
                        n3 = 2;
                        continue block26;
                    }
                    case 2: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "dAO7\u0015DK\u0019\u001f)[\u0019\u00197\u001dI]\\%\n\u0017\u000f\u001e";
                        n3 = 3;
                        continue block26;
                    }
                    case 3: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "\r[V9YANK1\u001c\u0003";
                        n3 = 4;
                        continue block26;
                    }
                    case 4: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "\r[V9Y^BX:\u0015\u0003";
                        n3 = 5;
                        continue block26;
                    }
                    case 5: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "\r\u0013\u0019f";
                        n3 = 6;
                        continue block26;
                    }
                    case 6: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "XAP\"Y\u0010\u0012\u00198\fAC";
                        n3 = 7;
                        continue block26;
                    }
                    case 7: {
                        stringArray2[n2] = Util.z(Util.z(string2));
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "\r\f\u001cyC\u0012ob\n$";
                        n3 = 8;
                        continue block26;
                    }
                    case 8: 
                }
                break;
            }
            stringArray2[n2] = Util.z(Util.z(string2));
            z = stringArray3;
            EMPTY_BYTE_ARRAY = new byte[0];
            EMPTY_STRING_ARRAY = new String[0];
            EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
            EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
            String string3 = "HI[4\u001bK";
            int n4 = -1;
            block27: while (true) {
                string = Util.z(Util.z(string3));
                switch (n4) {
                    default: {
                        UTF_8_BOM = ByteString.decodeHex(string);
                        string3 = "KJ_0";
                        n4 = 0;
                        continue block27;
                    }
                    case 0: {
                        UTF_16_BE_BOM = ByteString.decodeHex(string);
                        string3 = "KI_3";
                        n4 = 1;
                        continue block27;
                    }
                    case 1: {
                        UTF_16_LE_BOM = ByteString.decodeHex(string);
                        string3 = "\u001d\u001f\tf\u001fKI_";
                        n4 = 2;
                        continue block27;
                    }
                    case 2: {
                        UTF_32_BE_BOM = ByteString.decodeHex(string);
                        string3 = "KI_0I\u001d\u001f\t";
                        n4 = 3;
                        continue block27;
                    }
                    case 3: {
                        UTF_32_LE_BOM = ByteString.decodeHex(string);
                        string3 = "x{\u007f{A";
                        n4 = 4;
                        continue block27;
                    }
                    case 4: {
                        UTF_8 = Charset.forName(string);
                        string3 = "d|v{A\u0015\u001a\u0000{H";
                        n4 = 5;
                        continue block27;
                    }
                    case 5: {
                        ISO_8859_1 = Charset.forName(string);
                        string3 = "x{\u007f{H\u001bm|";
                        n4 = 6;
                        continue block27;
                    }
                    case 6: {
                        UTF_16_BE = Charset.forName(string);
                        string3 = "x{\u007f{H\u001bc|";
                        n4 = 7;
                        continue block27;
                    }
                    case 7: {
                        UTF_16_LE = Charset.forName(string);
                        string3 = "x{\u007f{J\u001fm|";
                        n4 = 8;
                        continue block27;
                    }
                    case 8: {
                        UTF_32_BE = Charset.forName(string);
                        string3 = "x{\u007f{J\u001fc|";
                        n4 = 9;
                        continue block27;
                    }
                    case 9: {
                        UTF_32_LE = Charset.forName(string);
                        string3 = "jbm";
                        n4 = 10;
                        continue block27;
                    }
                    case 10: 
                }
                break;
            }
            UTC = TimeZone.getTimeZone(string);
            NATURAL_ORDER = new Comparator<String>(){

                @Override
                public final int compare(String string, String string2) {
                    return string.compareTo(string2);
                }
            };
            try {
                int n5 = -1;
            }
            catch (Exception exception) {
                method = null;
                break block28;
            }
            method = Throwable.class.getDeclaredMethod(Util.z(Util.z("LK]\u0005\f]_K3\n^J]")), Throwable.class);
        }
        addSuppressedExceptionMethod = method;
        VERIFY_AS_IP_ADDRESS = Pattern.compile(Util.z(Util.z("\u0005t\t{@L\u0002_\u0017Tkr\u0013l\"\u001d\u0002\u00007TKn\u0014\u0010C\u0003r\u0013\u007f\u0005\u0005te2Wp\u0004\u0010")));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x79);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 45;
                            break;
                        }
                        case 1: {
                            n7 = 47;
                            break;
                        }
                        case 2: {
                            n7 = 57;
                            break;
                        }
                        case 3: {
                            n7 = 86;
                            break;
                        }
                        default: {
                            n7 = 121;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

