/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.ws;

import cn.jmessage.support.okhttp3.internal.ws.WebSocketProtocol;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Timeout;
import java.io.IOException;
import java.util.Random;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;
    private static final String[] z;

    WebSocketWriter(boolean bl, BufferedSink bufferedSink, Random random) {
        if (bufferedSink == null) {
            throw new NullPointerException(z[3]);
        }
        if (random == null) {
            throw new NullPointerException(z[2]);
        }
        this.isClient = bl;
        this.sink = bufferedSink;
        this.sinkBuffer = bufferedSink.buffer();
        this.random = random;
        this.maskKey = bl ? new byte[4] : null;
        this.maskCursor = bl ? new Buffer.UnsafeCursor() : null;
    }

    final void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    final void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    final void writeClose(int n2, ByteString byteString) throws IOException {
        Object object = ByteString.EMPTY;
        if (n2 != 0 || byteString != null) {
            if (n2 != 0) {
                WebSocketProtocol.validateCloseCode(n2);
            }
            object = new Buffer();
            ((Buffer)object).writeShort(n2);
            if (byteString != null) {
                ((Buffer)object).write(byteString);
            }
            object = ((Buffer)object).readByteString();
        }
        try {
            this.writeControlFrame(8, (ByteString)object);
            return;
        }
        finally {
            this.writerClosed = true;
        }
    }

    private void writeControlFrame(int n2, ByteString byteString) throws IOException {
        if (this.writerClosed) {
            throw new IOException(z[1]);
        }
        int n3 = byteString.size();
        if ((long)n3 > 125L) {
            throw new IllegalArgumentException(z[4]);
        }
        n2 = 0x80 | n2;
        this.sinkBuffer.writeByte(n2);
        if (this.isClient) {
            n2 = n3 | 0x80;
            this.sinkBuffer.writeByte(n2);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (n3 > 0) {
                long l2 = this.sinkBuffer.size();
                this.sinkBuffer.write(byteString);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l2);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(n3);
            this.sinkBuffer.write(byteString);
        }
        this.sink.flush();
    }

    final Sink newMessageSink(int n2, long l2) {
        if (this.activeWriter) {
            throw new IllegalStateException(z[0]);
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = n2;
        this.frameSink.contentLength = l2;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    final void writeMessageFrame(int n2, long l2, boolean bl, boolean bl2) throws IOException {
        if (this.writerClosed) {
            throw new IOException(z[1]);
        }
        int n3 = n2 = bl ? n2 : 0;
        if (bl2) {
            n2 |= 0x80;
        }
        this.sinkBuffer.writeByte(n2);
        n2 = 0;
        if (this.isClient) {
            n2 = 128;
        }
        if (l2 <= 125L) {
            this.sinkBuffer.writeByte(n2 |= (int)l2);
        } else if (l2 <= 65535L) {
            this.sinkBuffer.writeByte(n2 |= 0x7E);
            this.sinkBuffer.writeShort((int)l2);
        } else {
            this.sinkBuffer.writeByte(n2 |= 0x7F);
            this.sinkBuffer.writeLong(l2);
        }
        if (this.isClient) {
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (l2 > 0L) {
                long l3 = this.sinkBuffer.size();
                this.sinkBuffer.write(this.buffer, l2);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l3);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.write(this.buffer, l2);
        }
        this.sink.emit();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "VbF|%r~\te(d\u007fHo(7{[a9r~\ta>7mJ|$ai\u0007(\t~h\tq\"b,Ji!{,Jd\"di\u0001!r";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 23;
                                break;
                            }
                            case 1: {
                                n9 = 12;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 8;
                                break;
                            }
                            default: {
                                n9 = 77;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "t`F{(s";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "emGl\"z,\u00145myyEd";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "deGcm*1\tf8{`";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "GmPd\"vh\t{$mi\te8dx\tj(7`L{>7xAi#7c[((fyHdmcc\t9\u007f\"";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;
        private static final String z;

        FrameSink() {
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (this.closed) {
                throw new IOException(z);
            }
            WebSocketWriter.this.buffer.write(buffer, l2);
            boolean bl = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long l3 = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (l3 > 0L && !bl) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, l3, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        @Override
        public final void flush() throws IOException {
            if (this.closed) {
                throw new IOException(z);
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @Override
        public final Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public final void close() throws IOException {
            if (this.closed) {
                throw new IOException(z);
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "k:q&\u000bl".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 8;
                                break;
                            }
                            case 1: {
                                n7 = 86;
                                break;
                            }
                            case 2: {
                                n7 = 30;
                                break;
                            }
                            case 3: {
                                n7 = 85;
                                break;
                            }
                            default: {
                                n7 = 110;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

