/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.storage;

import cn.jmessage.support.qiniu.android.collect.Config;
import cn.jmessage.support.qiniu.android.collect.UploadInfoCollector;
import cn.jmessage.support.qiniu.android.common.Zone;
import cn.jmessage.support.qiniu.android.http.Client;
import cn.jmessage.support.qiniu.android.http.ResponseInfo;
import cn.jmessage.support.qiniu.android.storage.Configuration;
import cn.jmessage.support.qiniu.android.storage.FormUploader;
import cn.jmessage.support.qiniu.android.storage.KeyGenerator;
import cn.jmessage.support.qiniu.android.storage.Recorder;
import cn.jmessage.support.qiniu.android.storage.ResumeUploader;
import cn.jmessage.support.qiniu.android.storage.UpCompletionHandler;
import cn.jmessage.support.qiniu.android.storage.UpToken;
import cn.jmessage.support.qiniu.android.storage.UploadOptions;
import cn.jmessage.support.qiniu.android.utils.AsyncRun;
import cn.jmessage.support.qiniu.android.utils.StringUtils;
import java.io.File;
import org.json.JSONObject;

public final class UploadManager {
    private final Configuration config;
    private final Client client;
    private static final String[] z;

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration configuration) {
        this.config = configuration;
        this.client = new Client(configuration.proxy, configuration.connectTimeout, configuration.responseTimeout, configuration.urlConverter, configuration.dns);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGenerator) {
        this(new Configuration.Builder().recorder(recorder, keyGenerator).build());
    }

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    private static boolean areInvalidArg(String string, byte[] byArray, File file, String object, UpToken upToken, UpCompletionHandler upCompletionHandler) {
        if (upCompletionHandler == null) {
            throw new IllegalArgumentException(z[2]);
        }
        String string2 = null;
        if (file == null && byArray == null) {
            string2 = z[1];
        } else if (object == null || ((String)object).equals("")) {
            string2 = z[3];
        }
        object = null;
        if (string2 != null) {
            object = ResponseInfo.invalidArgument(string2, upToken);
        } else if (upToken == UpToken.NULL || upToken == null) {
            object = ResponseInfo.invalidToken(z[0]);
        } else if (file != null && file.length() == 0L || byArray != null && byArray.length == 0) {
            object = ResponseInfo.zeroSize(upToken);
        }
        if (object != null) {
            upCompletionHandler.complete(string, (ResponseInfo)object, null);
            return true;
        }
        return false;
    }

    private static ResponseInfo areInvalidArg(String string, byte[] byArray, File file, String string2, UpToken upToken) {
        string = null;
        if (file == null && byArray == null) {
            string = z[1];
        } else if (string2 == null || string2.equals("")) {
            string = z[3];
        }
        if (string != null) {
            return ResponseInfo.invalidArgument(string, upToken);
        }
        if (upToken == UpToken.NULL || upToken == null) {
            return ResponseInfo.invalidToken(z[0]);
        }
        if (file != null && file.length() == 0L || byArray != null && byArray.length == 0) {
            return ResponseInfo.zeroSize(upToken);
        }
        return null;
    }

    private static WarpHandler warpHandler(UpCompletionHandler upCompletionHandler, long l2) {
        return new WarpHandler(upCompletionHandler, l2);
    }

    public final void put(final byte[] byArray, final String string, String string2, final UpCompletionHandler upCompletionHandler, final UploadOptions uploadOptions) {
        final UpToken upToken = UpToken.parse(string2);
        if (UploadManager.areInvalidArg(string, byArray, null, string2, upToken, upCompletionHandler)) {
            return;
        }
        this.config.zone.preQuery(string2, new Zone.QueryHandler(){
            private static final String z;

            @Override
            public void onSuccess() {
                FormUploader.upload(UploadManager.this.client, UploadManager.this.config, byArray, string, upToken, upCompletionHandler, uploadOptions);
            }

            @Override
            public void onFailure(int n2) {
                ResponseInfo responseInfo = ResponseInfo.isStatusCodeForBrokenNetwork(n2) ? ResponseInfo.networkError(n2, upToken) : ResponseInfo.invalidToken(z);
                upCompletionHandler.complete(string, responseInfo, null);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "!agFA!k1SB#j\u007f".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 72;
                                    break;
                                }
                                case 1: {
                                    n7 = 15;
                                    break;
                                }
                                case 2: {
                                    n7 = 17;
                                    break;
                                }
                                case 3: {
                                    n7 = 39;
                                    break;
                                }
                                default: {
                                    n7 = 45;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        });
    }

    public final void put(String string, String string2, String string3, UpCompletionHandler upCompletionHandler, UploadOptions uploadOptions) {
        this.put(new File(string), string2, string3, upCompletionHandler, uploadOptions);
    }

    public final void put(final File file, final String string, String string2, final UpCompletionHandler upCompletionHandler, final UploadOptions uploadOptions) {
        final UpToken upToken = UpToken.parse(string2);
        if (UploadManager.areInvalidArg(string, null, file, string2, upToken, upCompletionHandler)) {
            return;
        }
        this.config.zone.preQuery(string2, new Zone.QueryHandler(){
            private static final String z;

            @Override
            public void onSuccess() {
                if (file.length() <= (long)((UploadManager)UploadManager.this).config.putThreshold) {
                    FormUploader.upload(UploadManager.this.client, UploadManager.this.config, file, string, upToken, upCompletionHandler, uploadOptions);
                    return;
                }
                String string2 = ((UploadManager)UploadManager.this).config.keyGen.gen(string, file);
                WarpHandler warpHandler = UploadManager.warpHandler(upCompletionHandler, file != null ? file.length() : 0L);
                AsyncRun.runInMain(new ResumeUploader(UploadManager.this.client, UploadManager.this.config, file, string, upToken, warpHandler, uploadOptions, string2));
            }

            @Override
            public void onFailure(int n2) {
                ResponseInfo responseInfo = ResponseInfo.isStatusCodeForBrokenNetwork(n2) ? ResponseInfo.networkError(n2, upToken) : ResponseInfo.invalidToken(z);
                upCompletionHandler.complete(string, responseInfo, null);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "-\t#dC-\u0003uq@/\u0002;".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 68;
                                    break;
                                }
                                case 1: {
                                    n7 = 103;
                                    break;
                                }
                                case 2: {
                                    n7 = 85;
                                    break;
                                }
                                case 3: {
                                    n7 = 5;
                                    break;
                                }
                                default: {
                                    n7 = 47;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        });
    }

    public final ResponseInfo syncPut(byte[] byArray, String string, String object, UploadOptions uploadOptions) {
        UpToken upToken = UpToken.parse((String)object);
        if ((object = UploadManager.areInvalidArg(string, byArray, null, (String)object, upToken)) != null) {
            return object;
        }
        return FormUploader.syncUpload(this.client, this.config, byArray, string, upToken, uploadOptions);
    }

    public final ResponseInfo syncPut(File file, String string, String object, UploadOptions uploadOptions) {
        UpToken upToken = UpToken.parse((String)object);
        if ((object = UploadManager.areInvalidArg(string, null, file, (String)object, upToken)) != null) {
            return object;
        }
        return FormUploader.syncUpload(this.client, this.config, file, string, upToken, uploadOptions);
    }

    public final ResponseInfo syncPut(String string, String string2, String string3, UploadOptions uploadOptions) {
        return this.syncPut(new File(string), string2, string3, uploadOptions);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0015l\b1q\u0015f^$r\u0017g\u0010";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 124;
                                break;
                            }
                            case 1: {
                                n9 = 2;
                                break;
                            }
                            case 2: {
                                n9 = 126;
                                break;
                            }
                            case 3: {
                                n9 = 80;
                                break;
                            }
                            default: {
                                n9 = 29;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0012m^9s\fw\npy\u001dv\u001f";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0012m^\u0005m?m\u0013 q\u0019v\u0017?s4c\u00104q\u0019p";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0012m^$r\u0017g\u0010";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private static class WarpHandler
    implements UpCompletionHandler {
        final UpCompletionHandler complete;
        final long before = System.currentTimeMillis();
        final long size;

        WarpHandler(UpCompletionHandler upCompletionHandler, long l2) {
            this.complete = upCompletionHandler;
            this.size = l2;
        }

        @Override
        public void complete(final String string, final ResponseInfo responseInfo, final JSONObject jSONObject) {
            if (Config.isRecord) {
                final long l2 = System.currentTimeMillis();
                UploadInfoCollector.handleUpload(responseInfo.upToken, new UploadInfoCollector.RecordMsg(){
                    private static final String z;

                    @Override
                    public String toRecordMsg() {
                        return StringUtils.join(new String[]{"" + responseInfo.statusCode, responseInfo.reqId, responseInfo.host, responseInfo.ip, "" + responseInfo.port, "" + (l2 - WarpHandler.this.before), "" + responseInfo.timeStamp, "" + WarpHandler.this.size, z, "" + WarpHandler.this.size}, ",");
                    }

                    /*
                     * Handled impossible loop by duplicating code
                     * Enabled aggressive block sorting
                     */
                    static {
                        char[] cArray;
                        block10: {
                            int n2;
                            int n3;
                            char[] cArray2;
                            int n4;
                            block9: {
                                char[] cArray3 = "\u0012Ev).".toCharArray();
                                n4 = 0;
                                int n5 = cArray3.length;
                                cArray2 = cArray3;
                                n3 = n5;
                                if (n5 <= 1) break block9;
                                cArray = cArray2;
                                n2 = n3;
                                if (n3 <= n4) break block10;
                            }
                            do {
                                char[] cArray4 = cArray2;
                                char[] cArray5 = cArray2;
                                int n6 = n4;
                                while (true) {
                                    int n7;
                                    char c2 = cArray4[n6];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n7 = 112;
                                            break;
                                        }
                                        case 1: {
                                            n7 = 41;
                                            break;
                                        }
                                        case 2: {
                                            n7 = 25;
                                            break;
                                        }
                                        case 3: {
                                            n7 = 74;
                                            break;
                                        }
                                        default: {
                                            n7 = 69;
                                        }
                                    }
                                    cArray4[n6] = (char)(c2 ^ n7);
                                    ++n4;
                                    cArray2 = cArray5;
                                    n3 = n3;
                                    if (n3 != 0) break;
                                    cArray5 = cArray2;
                                    n2 = n3;
                                    n6 = n3;
                                    cArray4 = cArray2;
                                }
                                cArray = cArray2;
                                n2 = n3;
                            } while (n3 > n4);
                        }
                        z = new String(cArray).intern();
                    }
                });
            }
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    try {
                        WarpHandler.this.complete.complete(string, responseInfo, jSONObject);
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
        }
    }
}

