/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.im.android.api.model;

import cn.jiguang.api.JCoreInterface;
import cn.jpush.im.android.api.content.MessageContent;
import cn.jpush.im.android.api.content.TextContent;
import cn.jpush.im.android.api.enums.ContentType;
import cn.jpush.im.android.api.enums.ConversationType;
import cn.jpush.im.android.api.exceptions.JMFileSizeExceedException;
import cn.jpush.im.android.api.model.ChatRoomInfo;
import cn.jpush.im.android.api.model.GroupInfo;
import cn.jpush.im.android.api.model.Message;
import cn.jpush.im.android.api.model.UserInfo;
import cn.jpush.im.android.b.a;
import cn.jpush.im.android.b.c;
import cn.jpush.im.android.d.b;
import cn.jpush.im.android.e.i;
import cn.jpush.im.android.e.j;
import cn.jpush.im.api.BasicCallback;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonObject;
import com.google.gson.jpush.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class Conversation
implements Serializable {
    private static final String TAG;
    protected String id;
    protected ConversationType type = ConversationType.single;
    protected String targetId = "";
    protected Object targetInfo;
    protected String title = "";
    protected int unReadMsgCnt;
    protected File avatar = null;
    protected Message latestMessage;
    protected String latestText = "";
    protected ContentType latestType = ContentType.text;
    protected long lastMsgDate;
    protected String extra = "";
    private static final String[] z;

    public String getId() {
        return this.id;
    }

    public ConversationType getType() {
        return this.type;
    }

    public String getExtra() {
        return this.extra;
    }

    @Deprecated
    public String getTargetId() {
        return this.targetId;
    }

    public abstract String getTargetAppKey();

    @Deprecated
    public String getLatestText() {
        if (this.latestMessage != null) {
            switch (this.latestMessage.getContentType()) {
                case text: {
                    TextContent textContent = (TextContent)this.latestMessage.getContent();
                    this.latestText = textContent.getText();
                    break;
                }
                default: {
                    this.latestText = "";
                }
            }
        }
        return this.latestText;
    }

    @Deprecated
    public long getLastMsgDate() {
        if (this.latestMessage != null) {
            this.lastMsgDate = this.latestMessage.getCreateTime();
        }
        return this.lastMsgDate;
    }

    @Deprecated
    public ContentType getLatestType() {
        if (this.latestMessage != null) {
            this.latestType = this.latestMessage.getContentType();
        }
        return this.latestType;
    }

    public int getUnReadMsgCnt() {
        if (this.unReadMsgCnt < 0) {
            return 0;
        }
        return this.unReadMsgCnt;
    }

    public abstract boolean setUnReadMessageCnt(int var1);

    public abstract String getTitle();

    public File getAvatarFile() {
        return this.avatar;
    }

    public abstract Message getLatestMessage();

    public abstract Object getTargetInfo();

    public static Conversation createGroupConversation(long l2) {
        return b.a().a(l2);
    }

    public static Conversation createSingleConversation(String string) {
        return b.a().a(string, JCoreInterface.getAppKey());
    }

    public static Conversation createSingleConversation(String string, String string2) {
        return b.a().a(string, string2);
    }

    public static Conversation createChatRoomConversation(long l2) {
        return b.a().a(ConversationType.chatroom, String.valueOf(l2), "");
    }

    @Deprecated
    public static Conversation createConversation(ConversationType conversationType, long l2) {
        return Conversation.createConversation(conversationType, String.valueOf(l2));
    }

    @Deprecated
    public static Conversation createConversation(ConversationType conversationType, String string) {
        return b.a().a(conversationType, string, JCoreInterface.getAppKey());
    }

    public abstract boolean resetUnreadCount();

    public abstract Message getMessage(int var1);

    public abstract Message getMessage(long var1);

    public abstract List<Message> getAllMessage();

    public abstract List<Message> getMessagesFromOldest(int var1, int var2);

    public abstract List<Message> getMessagesFromNewest(int var1, int var2);

    public abstract boolean deleteMessage(int var1);

    public abstract boolean deleteAllMessage();

    public abstract boolean updateConversationExtra(String var1);

    public abstract boolean updateMessageExtra(Message var1, String var2, String var3);

    public abstract boolean updateMessageExtra(Message var1, String var2, Number var3);

    public abstract boolean updateMessageExtra(Message var1, String var2, Boolean var3);

    public abstract boolean updateMessageExtras(Message var1, Map<String, String> var2);

    public abstract Message createSendMessage(MessageContent var1);

    public abstract Message createSendMessage(MessageContent var1, String var2);

    public abstract Message createSendMessage(MessageContent var1, List<UserInfo> var2, String var3);

    public abstract Message createSendMessageAtAllMember(MessageContent var1, String var2);

    public abstract Message createSendTextMessage(String var1);

    public abstract Message createSendTextMessage(String var1, String var2);

    public abstract Message createSendImageMessage(File var1) throws FileNotFoundException;

    public abstract Message createSendImageMessage(File var1, String var2) throws FileNotFoundException;

    public abstract Message createSendVoiceMessage(File var1, int var2) throws FileNotFoundException;

    public abstract Message createSendVoiceMessage(File var1, int var2, String var3) throws FileNotFoundException;

    public abstract Message createSendCustomMessage(Map<? extends String, ? extends String> var1);

    public abstract Message createSendCustomMessage(Map<? extends String, ? extends String> var1, String var2);

    public abstract Message createSendFileMessage(File var1, String var2, String var3) throws FileNotFoundException, JMFileSizeExceedException;

    public abstract Message createSendFileMessage(File var1, String var2) throws FileNotFoundException, JMFileSizeExceedException;

    public abstract Message createLocationMessage(double var1, double var3, int var5, String var6);

    public abstract void retractMessage(Message var1, BasicCallback var2);

    public String toJson() {
        return i.c(this);
    }

    public static String collectionToJson(Collection<Conversation> collection) {
        return i.c(collection);
    }

    public String toJsonString() {
        return i.c(this);
    }

    public static Conversation fromJson(String object) {
        try {
            JsonObject jsonObject = i.a((String)object, JsonObject.class);
            JsonObject jsonObject2 = jsonObject.getAsJsonObject(z[1]);
            JsonObject jsonObject3 = jsonObject.getAsJsonObject(z[2]);
            jsonObject.remove(z[1]);
            jsonObject.remove(z[2]);
            object = jsonObject.getAsJsonPrimitive(z[0]);
            object = object != null && ((JsonPrimitive)object).getAsString().equals(ConversationType.chatroom.toString()) ? (c)i.a((JsonElement)jsonObject, a.class) : i.a((JsonElement)jsonObject, c.class);
            if (jsonObject2 != null) {
                switch (((c)object).type) {
                    case single: {
                        ((c)object).targetInfo = UserInfo.fromJson(jsonObject2.toString());
                        break;
                    }
                    case group: {
                        ((c)object).targetInfo = GroupInfo.fromJson(jsonObject2.toString());
                        break;
                    }
                    case chatroom: {
                        ((c)object).targetInfo = ChatRoomInfo.fromJson(jsonObject2.toString());
                    }
                }
            }
            if (jsonObject3 != null) {
                ((c)object).latestMessage = Message.fromJson(jsonObject3.toString());
            }
        }
        catch (Exception exception) {
            object = null;
            j.j(TAG, z[3] + exception.getMessage());
            exception.printStackTrace();
        }
        return object;
    }

    public static Collection<Conversation> fromJsonToCollection(String string) {
        return i.a(string, new i.a<Conversation>(){

            @Override
            public final Conversation fromJson(String string) {
                return Conversation.fromJson(string);
            }
        });
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "fBbMcW^mOoJC";
        int n3 = 3;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 37;
                                break;
                            }
                            case 1: {
                                n9 = 45;
                                break;
                            }
                            case 2: {
                                n9 = 12;
                                break;
                            }
                            case 3: {
                                n9 = 59;
                                break;
                            }
                            default: {
                                n9 = 6;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 3: {
                    TAG = string.intern();
                    string2 = "QT|^";
                    n3 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "QL~\\cQdb]i";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ILx^uQ`iHuDJi";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "@_~Tt\u0005BoXsW_i_&LC,]tJ@FHiK\u0001,VuB\r1\u001b";
                    n3 = 2;
                    continue block12;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

