/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedHashTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER;
    Comparator<? super K> comparator;
    Node<K, V>[] table;
    final Node<K, V> header;
    int size = 0;
    int modCount = 0;
    int threshold;
    private EntrySet entrySet;
    private KeySet keySet;
    private static final String[] z;

    public LinkedHashTreeMap() {
        this(NATURAL_ORDER);
    }

    public LinkedHashTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.header = new Node();
        this.table = new Node[16];
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final V get(Object node) {
        if ((node = this.findByObject(node)) != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public final V put(K object, V v2) {
        if (object == null) {
            throw new NullPointerException(z[1]);
        }
        object = this.find(object, true);
        Object v3 = ((Node)object).value;
        ((Node)object).value = v2;
        return v3;
    }

    @Override
    public final void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
        Node<K, V> node = this.header;
        Node node2 = node.next;
        while (node2 != node) {
            Node node3 = node2.next;
            node2.prev = null;
            node2.next = null;
            node2 = node3;
        }
        node.prev = node;
        node.next = node.prev;
    }

    @Override
    public final V remove(Object node) {
        if ((node = this.removeInternalByKey(node)) != null) {
            return node.value;
        }
        return null;
    }

    final Node<K, V> find(K k2, boolean bl) {
        Node<K, V> node;
        Object object;
        Comparator<K> comparator = this.comparator;
        Node<K, V>[] nodeArray = this.table;
        int n2 = LinkedHashTreeMap.secondaryHash(k2.hashCode());
        int n3 = n2 & nodeArray.length - 1;
        Node<K, V> node2 = nodeArray[n3];
        int n4 = 0;
        if (node2 != null) {
            object = comparator == NATURAL_ORDER ? (Comparable)k2 : null;
            while (true) {
                if ((n4 = object != null ? object.compareTo(node2.key) : comparator.compare(k2, node2.key)) == 0) {
                    return node2;
                }
                node = n4 < 0 ? node2.left : node2.right;
                if (node == null) break;
                node2 = node;
            }
        }
        if (!bl) {
            return null;
        }
        object = this.header;
        if (node2 == null) {
            if (comparator == NATURAL_ORDER && !(k2 instanceof Comparable)) {
                throw new ClassCastException(k2.getClass().getName() + z[0]);
            }
            node = new Node<K, V>(node2, k2, n2, object, ((Node)object).prev);
            nodeArray[n3] = node;
        } else {
            node = new Node<K, V>(node2, k2, n2, object, ((Node)object).prev);
            if (n4 < 0) {
                node2.left = node;
            } else {
                node2.right = node;
            }
            this.rebalance(node2, true);
        }
        if (this.size++ > this.threshold) {
            this.doubleCapacity();
        }
        ++this.modCount;
        return node;
    }

    final Node<K, V> findByObject(Object object) {
        try {
            if (object != null) {
                return this.find(object, false);
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    final Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<K, V> node = this.findByObject(entry.getKey());
        if (node != null && this.equal(node.value, entry.getValue())) {
            return node;
        }
        return null;
    }

    private boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private static int secondaryHash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    final void removeInternal(Node<K, V> node, boolean bl) {
        if (bl) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = null;
            node.next = null;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        if (node2 != null && node3 != null) {
            node4 = node2.height > node3.height ? node2.last() : node3.first();
            this.removeInternal(node4, false);
            int n2 = 0;
            node2 = node.left;
            if (node2 != null) {
                n2 = node2.height;
                node4.left = node2;
                node2.parent = node4;
                node.left = null;
            }
            int n3 = 0;
            node3 = node.right;
            if (node3 != null) {
                n3 = node3.height;
                node4.right = node3;
                node3.parent = node4;
                node.right = null;
            }
            node4.height = Math.max(n2, n3) + 1;
            this.replaceInParent(node, node4);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        --this.size;
        ++this.modCount;
    }

    final Node<K, V> removeInternalByKey(Object node) {
        if ((node = this.findByObject(node)) != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> node2) {
        Node node3 = node.parent;
        node.parent = null;
        if (node2 != null) {
            node2.parent = node3;
        }
        if (node3 != null) {
            if (node3.left == node) {
                node3.left = node2;
                return;
            }
            assert (node3.right == node);
            node3.right = node2;
            return;
        }
        int n2 = node.hash & this.table.length - 1;
        this.table[n2] = node2;
    }

    private void rebalance(Node<K, V> node, boolean bl) {
        while (node != null) {
            Node node2;
            int n2;
            Node node3 = node.left;
            int n3 = node3 != null ? node3.height : 0;
            int n4 = n3 - (n2 = (node2 = node.right) != null ? node2.height : 0);
            if (n4 == -2) {
                Node node4;
                Node node5 = node2.left;
                n3 = (node5 != null ? node5.height : 0) - (n2 = (node4 = node2.right) != null ? node4.height : 0);
                if (n3 == -1 || n3 == 0 && !bl) {
                    this.rotateLeft(node);
                } else {
                    assert (n3 == 1);
                    this.rotateRight(node2);
                    this.rotateLeft(node);
                }
                if (bl) break;
            } else if (n4 == 2) {
                Node node6;
                Node node7 = node3.left;
                n3 = (node7 != null ? node7.height : 0) - (n2 = (node6 = node3.right) != null ? node6.height : 0);
                if (n3 == 1 || n3 == 0 && !bl) {
                    this.rotateRight(node);
                } else {
                    assert (n3 == -1);
                    this.rotateLeft(node3);
                    this.rotateRight(node);
                }
                if (bl) break;
            } else if (n4 == 0) {
                node.height = n3 + 1;
                if (bl) {
                    return;
                }
            } else {
                assert (n4 == -1 || n4 == 1);
                node.height = Math.max(n3, n2) + 1;
                if (!bl) break;
            }
            node = node.parent;
        }
    }

    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        node.height = Math.max(node2 != null ? node2.height : 0, node4 != null ? node4.height : 0) + 1;
        node3.height = Math.max(node.height, node5 != null ? node5.height : 0) + 1;
    }

    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node2.left;
        Node node5 = node2.right;
        node.left = node5;
        if (node5 != null) {
            node5.parent = node;
        }
        this.replaceInParent(node, node2);
        node2.right = node;
        node.parent = node2;
        node.height = Math.max(node3 != null ? node3.height : 0, node5 != null ? node5.height : 0) + 1;
        node2.height = Math.max(node.height, node4 != null ? node4.height : 0) + 1;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet != null) {
            return entrySet;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    @Override
    public final Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet != null) {
            return keySet;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    private void doubleCapacity() {
        this.table = LinkedHashTreeMap.doubleCapacity(this.table);
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    static <K, V> Node<K, V>[] doubleCapacity(Node<K, V>[] nodeArray) {
        int n2 = nodeArray.length;
        Node[] nodeArray2 = new Node[n2 * 2];
        AvlIterator<K, V> avlIterator = new AvlIterator<K, V>();
        AvlBuilder avlBuilder = new AvlBuilder();
        AvlBuilder avlBuilder2 = new AvlBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node;
            Node<K, V> node2 = nodeArray[i2];
            if (node2 == null) continue;
            avlIterator.reset(node2);
            int n3 = 0;
            int n4 = 0;
            while ((node = avlIterator.next()) != null) {
                if ((node.hash & n2) == 0) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            avlBuilder.reset(n3);
            avlBuilder2.reset(n4);
            avlIterator.reset(node2);
            while ((node = avlIterator.next()) != null) {
                if ((node.hash & n2) == 0) {
                    avlBuilder.add(node);
                    continue;
                }
                avlBuilder2.add(node);
            }
            nodeArray2[i2] = n3 > 0 ? avlBuilder.root() : null;
            nodeArray2[i2 + n2] = n4 > 0 ? avlBuilder2.root() : null;
        }
        return nodeArray2;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "wA8V\u00048\\k5\u0005:X*\u0004\u000b5D.";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 87;
                                break;
                            }
                            case 1: {
                                n9 = 40;
                                break;
                            }
                            case 2: {
                                n9 = 75;
                                break;
                            }
                            case 3: {
                                n9 = 118;
                                break;
                            }
                            default: {
                                n9 = 106;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "<M2VWj\b%\u0003\u0006;";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        NATURAL_ORDER = new Comparator<Comparable>(){

            @Override
            public final int compare(Comparable comparable, Comparable comparable2) {
                return comparable.compareTo(comparable2);
            }
        };
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return LinkedHashTreeMap.this.size;
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(){

                @Override
                public K next() {
                    return this.nextNode().key;
                }
            };
        }

        @Override
        public final boolean contains(Object object) {
            return LinkedHashTreeMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return LinkedHashTreeMap.this.removeInternalByKey(object) != null;
        }

        @Override
        public final void clear() {
            LinkedHashTreeMap.this.clear();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return LinkedHashTreeMap.this.size;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextNode();
                }
            };
        }

        @Override
        public final boolean contains(Object object) {
            return object instanceof Map.Entry && LinkedHashTreeMap.this.findByEntry((Map.Entry)object) != null;
        }

        @Override
        public final boolean remove(Object node) {
            if (!(node instanceof Map.Entry)) {
                return false;
            }
            if ((node = LinkedHashTreeMap.this.findByEntry(node)) == null) {
                return false;
            }
            LinkedHashTreeMap.this.removeInternal(node, true);
            return true;
        }

        @Override
        public final void clear() {
            LinkedHashTreeMap.this.clear();
        }
    }

    private abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        Node<K, V> next;
        Node<K, V> lastReturned;
        int expectedModCount;

        private LinkedTreeMapIterator() {
            this.next = LinkedHashTreeMap.this.header.next;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != LinkedHashTreeMap.this.header;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (node == LinkedHashTreeMap.this.header) {
                throw new NoSuchElementException();
            }
            if (LinkedHashTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = node.next;
            this.lastReturned = node;
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedHashTreeMap.this.removeInternal(this.lastReturned, true);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashTreeMap.this.modCount;
        }
    }

    static final class AvlBuilder<K, V> {
        private Node<K, V> stack;
        private int leavesToSkip;
        private int leavesSkipped;
        private int size;

        AvlBuilder() {
        }

        final void reset(int n2) {
            int n3 = Integer.highestOneBit(n2) * 2 - 1;
            this.leavesToSkip = n3 - n2;
            this.size = 0;
            this.leavesSkipped = 0;
            this.stack = null;
        }

        final void add(Node<K, V> node) {
            node.right = null;
            node.parent = null;
            node.left = null;
            node.height = 1;
            if (this.leavesToSkip > 0 && (this.size & 1) == 0) {
                ++this.size;
                --this.leavesToSkip;
                ++this.leavesSkipped;
            }
            node.parent = this.stack;
            this.stack = node;
            ++this.size;
            if (this.leavesToSkip > 0 && (this.size & 1) == 0) {
                ++this.size;
                --this.leavesToSkip;
                ++this.leavesSkipped;
            }
            int n2 = 4;
            while ((this.size & n2 - 1) == n2 - 1) {
                Node node2;
                Node<K, V> node3;
                if (this.leavesSkipped == 0) {
                    node3 = this.stack;
                    node2 = node3.parent;
                    Node node4 = node2.parent;
                    node2.parent = node4.parent;
                    this.stack = node2;
                    node2.left = node4;
                    node2.right = node3;
                    node2.height = node3.height + 1;
                    node4.parent = node2;
                    node3.parent = node2;
                } else if (this.leavesSkipped == 1) {
                    node3 = this.stack;
                    node2 = node3.parent;
                    this.stack = node2;
                    node2.right = node3;
                    node2.height = node3.height + 1;
                    node3.parent = node2;
                    this.leavesSkipped = 0;
                } else if (this.leavesSkipped == 2) {
                    this.leavesSkipped = 0;
                }
                n2 *= 2;
            }
        }

        final Node<K, V> root() {
            Node<K, V> node = this.stack;
            if (node.parent != null) {
                throw new IllegalStateException();
            }
            return node;
        }
    }

    static class AvlIterator<K, V> {
        private Node<K, V> stackTop;

        AvlIterator() {
        }

        void reset(Node<K, V> node) {
            Node<K, V> node2 = null;
            while (node != null) {
                node.parent = node2;
                node2 = node;
                node = node.left;
            }
            this.stackTop = node2;
        }

        public Node<K, V> next() {
            Node<K, V> node = this.stackTop;
            if (node == null) {
                return null;
            }
            Node<K, V> node2 = node;
            node = node2.parent;
            node2.parent = null;
            Node node3 = node2.right;
            while (node3 != null) {
                node3.parent = node;
                node = node3;
                node3 = node3.left;
            }
            this.stackTop = node;
            return node2;
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        Node<K, V> next;
        Node<K, V> prev;
        final K key;
        final int hash;
        V value;
        int height;

        Node() {
            this.key = null;
            this.hash = -1;
            this.next = this.prev = this;
        }

        Node(Node<K, V> node, K k2, int n2, Node<K, V> node2, Node<K, V> node3) {
            this.parent = node;
            this.key = k2;
            this.hash = n2;
            this.height = 1;
            this.next = node2;
            this.prev = node3;
            node3.next = this;
            node2.prev = this;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public final boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                object = (Map.Entry)object;
                return (this.key == null ? object.getKey() == null : this.key.equals(object.getKey())) && (this.value == null ? object.getValue() == null : this.value.equals(object.getValue()));
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        public final Node<K, V> first() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.left;
            while (node2 != null) {
                node = node2;
                node2 = node.left;
            }
            return node;
        }

        public final Node<K, V> last() {
            Node<K, V> node = this;
            Node<K, V> node2 = node.right;
            while (node2 != null) {
                node = node2;
                node2 = node.right;
            }
            return node;
        }
    }
}

