/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.FieldSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int n2) {
        return new SmallSortedMap<FieldDescriptorType, Object>(n2){

            @Override
            public final void makeImmutable() {
                if (!this.isImmutable()) {
                    List list;
                    for (int i2 = 0; i2 < this.getNumArrayEntries(); ++i2) {
                        Map.Entry entry = this.getArrayEntryAt(i2);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    static <K extends Comparable<K>, V> SmallSortedMap<K, V> newInstanceForTest(int n2) {
        return new SmallSortedMap<K, V>(n2);
    }

    private SmallSortedMap(int n2) {
        this.maxArraySize = n2;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry<K, V> getArrayEntryAt(int n2) {
        return this.entryList.get(n2);
    }

    public int getNumOverflowEntries() {
        return this.overflowEntries.size();
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.binarySearchInArray(object = (Comparable)object) >= 0 || this.overflowEntries.containsKey(object);
    }

    @Override
    public V get(Object object) {
        int n2 = this.binarySearchInArray(object = (Comparable)object);
        if (n2 >= 0) {
            return this.entryList.get(n2).getValue();
        }
        return this.overflowEntries.get(object);
    }

    @Override
    public V put(K k2, V v2) {
        this.checkMutable();
        int n2 = this.binarySearchInArray(k2);
        if (n2 >= 0) {
            return this.entryList.get(n2).setValue(v2);
        }
        this.ensureEntryArrayMutable();
        n2 = -(n2 + 1);
        if (n2 >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(k2, v2);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry entry = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(entry.getKey(), entry.getValue());
        }
        this.entryList.add(n2, new Entry(this, k2, v2));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public V remove(Object object) {
        this.checkMutable();
        object = (Comparable)object;
        int n2 = this.binarySearchInArray(object);
        if (n2 >= 0) {
            return this.removeArrayEntryAt(n2);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(object);
    }

    private V removeArrayEntryAt(int n2) {
        this.checkMutable();
        Object v2 = this.entryList.remove(n2).getValue();
        if (!this.overflowEntries.isEmpty()) {
            Iterator<Map.Entry<K, V>> iterator = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator.next()));
            iterator.remove();
        }
        return v2;
    }

    private int binarySearchInArray(K k2) {
        int n2;
        int n3 = 0;
        int n4 = this.entryList.size() - 1;
        if (n4 >= 0) {
            n2 = k2.compareTo((Object)this.entryList.get(n4).getKey());
            if (n2 > 0) {
                return -(n4 + 2);
            }
            if (n2 == 0) {
                return n4;
            }
        }
        while (n3 <= n4) {
            n2 = (n3 + n4) / 2;
            int n5 = k2.compareTo((Object)this.entryList.get(n2).getKey());
            if (n5 < 0) {
                n4 = n2 - 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n2 + 1;
                continue;
            }
            return n2;
        }
        return -(n3 + 1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet();
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<Entry>(this.maxArraySize);
        }
    }

    private static class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public final Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        private EmptySet() {
        }

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;
        private static final String z;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < SmallSortedMap.this.entryList.size() || this.getOverflowIterator().hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextCalledBeforeRemove = true;
            if (++this.pos < SmallSortedMap.this.entryList.size()) {
                return (Map.Entry)SmallSortedMap.this.entryList.get(this.pos);
            }
            return this.getOverflowIterator().next();
        }

        @Override
        public void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException(z);
            }
            this.nextCalledBeforeRemove = false;
            SmallSortedMap.this.checkMutable();
            if (this.pos < SmallSortedMap.this.entryList.size()) {
                SmallSortedMap.this.removeArrayEntryAt(this.pos--);
                return;
            }
            this.getOverflowIterator().remove();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = SmallSortedMap.this.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "jyCw1}4\u000780yo\u000e{&tpK|gzyHw5}<@}?l4\u0007".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 24;
                                break;
                            }
                            case 1: {
                                n7 = 28;
                                break;
                            }
                            case 2: {
                                n7 = 46;
                                break;
                            }
                            case 3: {
                                n7 = 24;
                                break;
                            }
                            default: {
                                n7 = 71;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallSortedMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            object = (Map.Entry)object;
            Object v2 = SmallSortedMap.this.get(object.getKey());
            return v2 == (object = object.getValue()) || v2 != null && v2.equals(object);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (!this.contains(entry)) {
                SmallSortedMap.this.put((Comparable)entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object = (Map.Entry)object)) {
                SmallSortedMap.this.remove(object.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SmallSortedMap.this.clear();
        }
    }

    private static class Entry
    implements Comparable<Entry>,
    Map.Entry<K, V> {
        private final K key;
        private V value;
        final /* synthetic */ SmallSortedMap this$0;

        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> entry) {
            this(smallSortedMap, (Comparable)entry.getKey(), entry.getValue());
        }

        Entry(K k2, V v2) {
            this.this$0 = var1_1;
            this.key = k2;
            this.value = v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getKey().compareTo(entry.getKey());
        }

        @Override
        public V setValue(V v2) {
            this.this$0.checkMutable();
            Object v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return this.equals(this.key, (object = (Map.Entry)object).getKey()) && this.equals(this.value, object.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean equals(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }
    }
}

