/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jpush.http.entity.mime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jpush.http.entity.mime.MinimalField;

public class Header
implements Iterable<MinimalField> {
    private final List<MinimalField> fields = new LinkedList<MinimalField>();
    private final Map<String, List<MinimalField>> fieldMap = new HashMap<String, List<MinimalField>>();

    public void addField(MinimalField minimalField) {
        if (minimalField == null) {
            return;
        }
        String string = minimalField.getName().toLowerCase(Locale.US);
        List<MinimalField> list = this.fieldMap.get(string);
        if (list == null) {
            list = new LinkedList<MinimalField>();
            this.fieldMap.put(string, list);
        }
        list.add(minimalField);
        this.fields.add(minimalField);
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public MinimalField getField(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.get(object)) != null && !object.isEmpty()) {
            return (MinimalField)object.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.get(object)) == null || object.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MinimalField>((Collection<MinimalField>)object);
    }

    public int removeFields(String object) {
        if (object == null) {
            return 0;
        }
        object = ((String)object).toLowerCase(Locale.US);
        if ((object = this.fieldMap.remove(object)) == null || object.isEmpty()) {
            return 0;
        }
        this.fields.removeAll((Collection<?>)object);
        return object.size();
    }

    public void setField(MinimalField minimalField) {
        if (minimalField == null) {
            return;
        }
        Object object = minimalField.getName().toLowerCase(Locale.US);
        if ((object = this.fieldMap.get(object)) == null || object.isEmpty()) {
            this.addField(minimalField);
            return;
        }
        object.clear();
        object.add(minimalField);
        int n2 = -1;
        int n3 = 0;
        Iterator<MinimalField> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getName().equalsIgnoreCase(minimalField.getName())) {
                iterator.remove();
                if (n2 == -1) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        this.fields.add(n2, minimalField);
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

