/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.rastercore.f.a;

public final class CameraPosition
implements Parcelable {
    private static final int EMPTY_ZOOMLEVEL = -1;
    private final LatLng target;
    private float zoom = -1.0f;
    public static final Parcelable.Creator<CameraPosition> CREATOR = new Parcelable.Creator<CameraPosition>(){

        public final CameraPosition createFromParcel(Parcel parcel) {
            float f2 = parcel.readFloat();
            float f3 = parcel.readFloat();
            float f4 = parcel.readFloat();
            return new CameraPosition(new LatLng(f2, f3), f4);
        }

        public final CameraPosition[] newArray(int n) {
            return new CameraPosition[n];
        }
    };

    public CameraPosition(LatLng latLng, float f2) {
        this.target = latLng;
        this.zoom = f2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat((float)this.getTarget().getLatitude());
        parcel.writeFloat((float)this.getTarget().getLongitude());
        parcel.writeFloat(this.getZoom());
    }

    public final int describeContents() {
        return 0;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f2) {
        return new CameraPosition(latLng, f2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        object = (CameraPosition)object;
        return this.getTarget().equals(((CameraPosition)object).getTarget()) && Float.floatToIntBits(this.getZoom()) == Float.floatToIntBits(((CameraPosition)object).getZoom());
    }

    public final String toString() {
        return a.a(a.a("target", this.getTarget()), a.a("zoom", Float.valueOf(this.getZoom())));
    }

    public final LatLng getTarget() {
        return this.target;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public static final class Builder {
        private LatLng target;
        private float zoom = -1.0f;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            this.target(cameraPosition.getTarget()).zoom(cameraPosition.getZoom());
        }

        public final Builder target(LatLng latLng) {
            this.target = latLng;
            return this;
        }

        public final Builder zoom(float f2) {
            this.zoom = f2;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.target, this.zoom);
        }
    }
}

