/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class LatLng
implements Cloneable {
    private static DecimalFormat df = new DecimalFormat("0.000000", new DecimalFormatSymbols(Locale.US));
    private final double longitude;
    private final double latitude;

    public LatLng(double d2, double d3) {
        this.longitude = -180.0 <= d3 && d3 < 180.0 ? LatLng.parseDouble(d3) : LatLng.parseDouble(((d3 - 180.0) % 360.0 + 360.0) % 360.0 - 180.0);
        this.latitude = LatLng.parseDouble(Math.max(-85.0, Math.min(85.0, d2)));
    }

    private static double parseDouble(double d2) {
        return Double.parseDouble(df.format(d2));
    }

    public final LatLng clone() {
        return new LatLng(this.latitude, this.longitude);
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.latitude);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLng)) {
            return false;
        }
        object = (LatLng)object;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(((LatLng)object).latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(((LatLng)object).longitude);
    }

    public final String toString() {
        return "lat/lng: (" + this.latitude + "," + this.longitude + ")";
    }
}

