/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import com.tencent.mapsdk.raster.model.BitmapDescriptor;
import com.tencent.mapsdk.raster.model.Circle;
import com.tencent.mapsdk.raster.model.CircleOptions;
import com.tencent.mapsdk.raster.model.GroundOverlay;
import com.tencent.mapsdk.raster.model.GroundOverlayOptions;
import com.tencent.mapsdk.raster.model.IOverlay;
import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.raster.model.Marker;
import com.tencent.mapsdk.raster.model.MarkerOptions;
import com.tencent.mapsdk.raster.model.Polygon;
import com.tencent.mapsdk.raster.model.PolygonOptions;
import com.tencent.mapsdk.raster.model.Polyline;
import com.tencent.mapsdk.raster.model.PolylineOptions;
import com.tencent.tencentmap.mapsdk.map.CameraUpdate;
import com.tencent.tencentmap.mapsdk.map.MapController;
import com.tencent.tencentmap.mapsdk.map.MapView;
import com.tencent.tencentmap.mapsdk.map.QSupportMapFragment;
import com.tencent.tencentmap.mapsdk.map.TencentMap;
import com.tencent.tencentmap.mapsdk.map.UiSettings;

public class MapFragmentUtil {
    MapView mapView;
    UiSettings mUi;
    TencentMap tencentMap;

    public MapFragmentUtil(QSupportMapFragment qSupportMapFragment) {
        this.mapView = qSupportMapFragment.getMapView();
        this.mUi = this.mapView.getUiSettings();
        this.tencentMap = this.mapView.getMap();
        this.mUi.setLogoPosition(1);
        this.setScaleControlsEnable(true);
        this.mUi.setScaleViewPosition(0);
    }

    public MapController getMapController() {
        return this.mapView.getController();
    }

    public LatLng getMapCenter() {
        return this.mapView.getMapCenter();
    }

    public int getLatitudeSpan() {
        return this.mapView.getLatitudeSpan();
    }

    public int getLongitudeSpan() {
        return this.mapView.getLongitudeSpan();
    }

    public int getZoomLevel() {
        return this.tencentMap.getZoomLevel();
    }

    public boolean isSatellite() {
        return this.tencentMap.isSatelliteEnabled();
    }

    public void setSatellite(boolean bl) {
        this.tencentMap.setSatelliteEnabled(bl);
    }

    public void invalidate() {
        this.mapView.getMapContext().a(false, false);
    }

    public float getScalePerPixel() {
        return this.mapView.getScalePerPixel();
    }

    public void setScaleControlsEnable(boolean bl) {
        this.mUi.setScaleControlsEnabled(bl);
    }

    public void setPinchEnabeled(boolean bl) {
        this.mUi.setZoomGesturesEnabled(bl);
    }

    public void setScrollGesturesEnabled(boolean bl) {
        this.mUi.setScrollGesturesEnabled(bl);
    }

    public GroundOverlay addOverlay(BitmapDescriptor bitmapDescriptor, LatLng latLng, LatLng latLng2) {
        return this.mapView.addOverlay(bitmapDescriptor.getBitmap(), latLng, latLng2);
    }

    public void clearAllOverlays() {
        this.mapView.clearAllOverlays();
    }

    public void removeOverlay(IOverlay iOverlay) {
        this.mapView.removeOverlay(iOverlay);
    }

    public void refreshMap() {
        this.mapView.getMapContext().a(false, false);
    }

    public void postInvalidate() {
        this.refreshMap();
    }

    public void moveCamera(CameraUpdate cameraUpdate) {
        this.mapView.moveCamera(cameraUpdate);
    }

    public GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return this.mapView.getMap().addGroundOverlay(groundOverlayOptions);
    }

    public Circle addCircle(CircleOptions circleOptions) {
        return this.mapView.addCircle(circleOptions);
    }

    public Polygon addPolygon(PolygonOptions polygonOptions) {
        return this.mapView.addPolygon(polygonOptions);
    }

    public Marker addMarker(MarkerOptions object) {
        object = this.mapView.addMarker((MarkerOptions)object);
        this.invalidate();
        return object;
    }

    public Polyline addPolyline(PolylineOptions polylineOptions) {
        return this.mapView.addPolyline(polylineOptions);
    }

    public void setLogoPosition(int n) {
        this.mUi.setLogoPosition(n);
    }

    public void setScaleViewPosition(int n) {
        this.mUi.setScaleViewPosition(n);
    }
}

