/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import com.tencent.mapsdk.raster.model.CameraPosition;
import com.tencent.mapsdk.raster.model.Circle;
import com.tencent.mapsdk.raster.model.CircleOptions;
import com.tencent.mapsdk.raster.model.GroundOverlay;
import com.tencent.mapsdk.raster.model.GroundOverlayOptions;
import com.tencent.mapsdk.raster.model.IOverlay;
import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.raster.model.LatLngBounds;
import com.tencent.mapsdk.raster.model.Marker;
import com.tencent.mapsdk.raster.model.MarkerOptions;
import com.tencent.mapsdk.raster.model.Polygon;
import com.tencent.mapsdk.raster.model.PolygonOptions;
import com.tencent.mapsdk.raster.model.Polyline;
import com.tencent.mapsdk.raster.model.PolylineOptions;
import com.tencent.mapsdk.raster.model.QMapLanguage;
import com.tencent.mapsdk.raster.model.TileOverlay;
import com.tencent.mapsdk.raster.model.TileOverlayOptions;
import com.tencent.mapsdk.rastercore.d.c;
import com.tencent.mapsdk.rastercore.d.e;
import com.tencent.mapsdk.rastercore.tile.MapTile;
import com.tencent.mapsdk.rastercore.tile.a.a;
import com.tencent.tencentmap.mapsdk.map.CameraUpdate;
import com.tencent.tencentmap.mapsdk.map.CameraUpdateFactory;
import com.tencent.tencentmap.mapsdk.map.CancelableCallback;

public class TencentMap {
    private e mapContext;
    private com.tencent.mapsdk.rastercore.d.a contentLayer;
    private c projection;
    private static OnErrorListener onErrorListener;

    public TencentMap(e e2) {
        this.mapContext = e2;
        this.contentLayer = e2.e();
        this.projection = e2.b();
    }

    public Circle addCircle(CircleOptions circleOptions) {
        return new Circle(this.contentLayer.a(circleOptions));
    }

    public TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        return new TileOverlay(this.mapContext.g().a(tileOverlayOptions));
    }

    public GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return new GroundOverlay(this.contentLayer.a(groundOverlayOptions));
    }

    public Marker addMarker(MarkerOptions markerOptions) {
        return new Marker(this.contentLayer.a(markerOptions));
    }

    public Polygon addPolygon(PolygonOptions polygonOptions) {
        return new Polygon(this.contentLayer.a(polygonOptions));
    }

    public Polyline addPolyline(PolylineOptions polylineOptions) {
        return new Polyline(this.contentLayer.a(polylineOptions));
    }

    public void animateTo(LatLng latLng) {
        this.changeCamera(CameraUpdateFactory.newLatLng(latLng), 1000L, null);
    }

    public void animateTo(LatLng latLng, final Runnable runnable) {
        this.changeCamera(CameraUpdateFactory.newLatLng(latLng), 1000L, new CancelableCallback(){

            @Override
            public void onFinish() {
                runnable.run();
            }

            @Override
            public void onCancel() {
                runnable.run();
            }
        });
    }

    public void animateTo(LatLng latLng, long l, CancelableCallback cancelableCallback) {
        this.changeCamera(CameraUpdateFactory.newLatLng(latLng), l, cancelableCallback);
    }

    public final void clearAllOverlays() {
        this.contentLayer.a();
        this.mapContext.a(false, false);
    }

    public boolean clearCache() {
        return a.a().a(MapTile.MapSource.BING) && a.a().a(MapTile.MapSource.TENCENT) && a.a().a(MapTile.MapSource.SATELLITE);
    }

    public LatLng getMapCenter() {
        return this.projection.d().getTarget();
    }

    public int getZoomLevel() {
        return (int)this.projection.d().getZoom();
    }

    private void setMaxZoomLevel(int n) {
        this.projection.c(n);
    }

    public int getMaxZoomLevel() {
        return this.projection.i().a();
    }

    private void setMinZoomLevel(int n) {
        this.projection.d(n);
    }

    public int getMinZoomLevel() {
        return this.projection.j().a();
    }

    public final String getVersion() {
        return "1.2.8.1.c02ec64";
    }

    public final boolean isAppKeyAvailable() {
        return e.q();
    }

    private boolean setBounds(LatLngBounds latLngBounds) {
        return this.projection.a(latLngBounds);
    }

    public final boolean isSatelliteEnabled() {
        return this.mapContext.l() == 2;
    }

    public void setSatelliteEnabled(boolean bl) {
        if (bl) {
            this.mapContext.a(2);
            return;
        }
        this.mapContext.a(1);
    }

    public void moveCamera(CameraUpdate object) {
        if (object != null && (object = ((CameraUpdate)object).getCameraUpdateFactoryDelegate()) != null) {
            ((com.tencent.mapsdk.rastercore.c.a)object).a(false);
            this.mapContext.c().a((com.tencent.mapsdk.rastercore.c.a)object);
        }
    }

    public void animateCamera(CameraUpdate cameraUpdate) {
        this.changeCamera(cameraUpdate, 1000L, null);
    }

    public void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        this.changeCamera(cameraUpdate, 1000L, cancelableCallback);
    }

    public void animateCamera(CameraUpdate cameraUpdate, long l, CancelableCallback cancelableCallback) {
        if (l < 0L) {
            l = 0L;
        }
        this.changeCamera(cameraUpdate, l, cancelableCallback);
    }

    public void scrollBy(float f2, float f3) {
        this.changeCamera(CameraUpdateFactory.scrollBy(f2, f3), 1000L, null);
    }

    public void scrollBy(float f2, float f3, long l, CancelableCallback cancelableCallback) {
        this.changeCamera(CameraUpdateFactory.scrollBy(f2, f3), l, cancelableCallback);
    }

    public void setCenter(LatLng latLng) {
        this.changeCamera(CameraUpdateFactory.newLatLngZoom(latLng, this.getZoomLevel()), 0L, null);
    }

    public void setZoom(int n) {
        this.changeCamera(CameraUpdateFactory.zoomTo(n), 0L, null);
    }

    public void zoomIn() {
        this.changeCamera(CameraUpdateFactory.zoomIn(), 1000L, null);
    }

    public void zoomInFixing(int n, int n2) {
        this.changeCamera(CameraUpdateFactory.zoomBy(1.0f, new Point(n, n2)), 1000L, null);
    }

    public void zoomOut() {
        this.changeCamera(CameraUpdateFactory.zoomOut(), 1000L, null);
    }

    public void zoomOutFixing(int n, int n2) {
        this.changeCamera(CameraUpdateFactory.zoomBy(-1.0f, new Point(n, n2)), 1000L, null);
    }

    public void zoomToSpan(LatLng object, LatLng latLng) {
        object = new LatLngBounds.Builder().include((LatLng)object).include(latLng).build();
        this.mapContext.c().a(CameraUpdateFactory.newLatLngBounds((LatLngBounds)object, 10).getCameraUpdateFactoryDelegate());
    }

    public void zoomToSpan(double d2, double d3) {
        this.zoomToSpan(new LatLng(this.getMapCenter().getLatitude() - d2 / 2.0, this.getMapCenter().getLongitude() + d3 / 2.0), new LatLng(this.getMapCenter().getLatitude() + d2 / 2.0, this.getMapCenter().getLongitude() - d3 / 2.0));
    }

    public void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        this.mapContext.h().a(infoWindowAdapter);
    }

    public void setOnMarkerDraggedListener(OnMarkerDraggedListener onMarkerDraggedListener) {
        this.mapContext.h().a(onMarkerDraggedListener);
    }

    public void setOnMapLoadedListener(OnMapLoadedListener onMapLoadedListener) {
        this.mapContext.c().a(onMapLoadedListener);
    }

    public void setOnInfoWindowClickListener(OnInfoWindowClickListener onInfoWindowClickListener) {
        this.mapContext.h().a(onInfoWindowClickListener);
    }

    public void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        this.mapContext.h().a(onMarkerClickListener);
    }

    public void setOnMapCameraChangeListener(OnMapCameraChangeListener onMapCameraChangeListener) {
        this.mapContext.h().a(onMapCameraChangeListener);
    }

    public void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.mapContext.h().a(onMapClickListener);
    }

    public void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.mapContext.h().a(onMapLongClickListener);
    }

    public void stopAnimation() {
        this.mapContext.d().stopAnimation();
    }

    public void getScreenShot(OnScreenShotListener onScreenShotListener) {
        this.mapContext.a(onScreenShotListener);
    }

    public void getScreenShot(OnScreenShotListener onScreenShotListener, Rect rect) {
        this.mapContext.a(onScreenShotListener, rect);
    }

    public void removeOverlay(IOverlay iOverlay) {
        if (iOverlay == null) {
            return;
        }
        iOverlay.remove();
    }

    private void changeCamera(CameraUpdate cameraUpdate, long l, CancelableCallback cancelableCallback) {
        if (!this.mapContext.f().k() || l < 0L) {
            cameraUpdate.getCameraUpdateFactoryDelegate().a(false);
        }
        cameraUpdate.getCameraUpdateFactoryDelegate().a(cancelableCallback);
        cameraUpdate.getCameraUpdateFactoryDelegate().a(l);
        this.mapContext.c().a(cameraUpdate.getCameraUpdateFactoryDelegate());
    }

    public void setTrafficEnabled(boolean bl) {
        this.mapContext.i().a(bl);
    }

    public boolean isTrafficEnabled() {
        return this.mapContext.i().a();
    }

    public void setLanguage(QMapLanguage qMapLanguage) {
        e.a(QMapLanguage.getLanguageCode(qMapLanguage));
        this.mapContext.a(true, true);
    }

    public static void setErrorListener(OnErrorListener onErrorListener) {
        TencentMap.onErrorListener = onErrorListener;
    }

    public static OnErrorListener getErrorListener() {
        return onErrorListener;
    }

    public static interface OnErrorListener {
        public void collectErrorInfo(String var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public void onInfoWindowDettached(Marker var1, View var2);
    }

    public static interface OnScreenShotListener {
        public void onMapScreenShot(Bitmap var1);
    }

    public static interface OnMarkerDraggedListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMapLoadedListener {
        public void onMapLoaded();
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapCameraChangeListener {
        public void onCameraChange(CameraPosition var1);

        public void onCameraChangeFinish(CameraPosition var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }
}

