/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech;

import android.media.AudioRecord;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import com.baidu.speech.audio.MicrophoneServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class MicrophoneInputStream
extends InputStream {
    private static final String TAG = "MicrophoneInputStream";
    private final LocalSocket socket;
    private final InputStream source;
    private String SOCKET_ADDRESS = "com.baidu.speech";

    public MicrophoneInputStream() throws IOException {
        this(1, 16000);
    }

    public MicrophoneInputStream(int n) throws IOException {
        this(1, n);
    }

    public MicrophoneInputStream(AudioRecord audioRecord) throws IOException {
        this(1, 16000, null, audioRecord);
    }

    public MicrophoneInputStream(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public MicrophoneInputStream(int n, InputStream inputStream) throws IOException {
        this(1, n, inputStream);
    }

    public MicrophoneInputStream(int n, int n2, InputStream inputStream) throws IOException {
        this(n, n2, inputStream, null);
    }

    public MicrophoneInputStream(int n, int n2, InputStream inputStream, AudioRecord audioRecord) throws IOException {
        final LocalSocket[] localSocketArray = new LocalSocket[1];
        int n3 = MicrophoneServer.create("", n);
        Future<LocalSocket> future = Executors.newSingleThreadExecutor().submit(new Callable<LocalSocket>(){

            @Override
            public LocalSocket call() throws Exception {
                localSocketArray[0] = new LocalSocket();
                localSocketArray[0].connect(new LocalSocketAddress(MicrophoneInputStream.this.SOCKET_ADDRESS));
                localSocketArray[0].getOutputStream().write(0);
                int n = localSocketArray[0].getInputStream().read(new byte[640]);
                if (n == 6) {
                    localSocketArray[0].close();
                    throw new IOException("Recorder open failed");
                }
                return localSocketArray[0];
            }
        });
        try {
            this.socket = future.get(23000L, TimeUnit.MILLISECONDS);
            this.source = localSocketArray[0].getInputStream();
        }
        catch (Exception exception) {
            if (localSocketArray[0] != null) {
                localSocketArray[0].close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw new IOException(exception);
        }
        new Thread(){

            public void run() {
                byte[] byArray = new byte[640];
                try {
                    while (true) {
                        MicrophoneInputStream.this.socket.getInputStream().read(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    public int read() throws IOException {
        return 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.source.read(byArray, n, n2);
    }

    public void close() throws IOException {
        super.close();
        if (this.source != null) {
            this.source.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public long mills() {
        return 0L;
    }

    public void mills(long l) {
    }
}

