package cn.gdou.edu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.ListView;
import android.widget.SimpleAdapter;

import cn.gdou.edu.data.*;
import cn.gdou.edu.net.LibAPI;

public class BorrowedInfoActivity extends Activity {
	private ListView list;
	private ProgressDialog mypDialog;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.book_borrowed);
		
		mypDialog = new ProgressDialog(BorrowedInfoActivity.this);
		mypDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		mypDialog.setTitle("");
		mypDialog.setMessage("ڼ...");
		mypDialog.setIndeterminate(false);
		
		
		list = (ListView) findViewById(R.id.book_borrowed_list);
		downBorrowedInfo dbi=new downBorrowedInfo();
		dbi.execute();
	}

	class downBorrowedInfo extends AsyncTask<Void, String, List<BookInfo>> {

		@Override
		protected void onPreExecute() {
			mypDialog.show();
			super.onPreExecute();
		}

		@Override
		protected List<BookInfo> doInBackground(Void... params) {
			// TODO Auto-generated method stub
			LibAPI lib = new LibAPI();
			SharedPreferences sp = getSharedPreferences("lib", MODE_APPEND);
			String cookie = sp.getString("cookie", "");
			if (!cookie.isEmpty()) {
				lib.setCookie(cookie);
				return lib.getBorrowedContent();
			}
			return null;
		}

		@Override
		protected void onPostExecute(List<BookInfo> result) {
			mypDialog.cancel();
			List<Map<String, String>> list_content = new ArrayList<Map<String, String>>();
			Iterator<BookInfo> it = result.iterator();
			while (it.hasNext()) {
				Map<String, String> map = new HashMap<String, String>();
				BookInfo book=it.next();
				map.put("bookname", book.getBook_writer());
				map.put("lentdate", book.getBack_time());
				map.put("borrowedtime", book.getBorrowed_time());
				list_content.add(map);
			}

			SimpleAdapter adapter = new SimpleAdapter(getApplicationContext(),
					list_content, R.layout.book_borrowed_list_view, new String[] { "bookname",
							"lentdate", "borrowedtime" },
							new int[] { R.id.borrowed_title,R.id.lent_date,R.id.borrowed_date});
			list.setAdapter(adapter);
			
			super.onPostExecute(result);
		}

	}
}
