package cn.gdou.edu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.gdou.edu.data.SearchBook;
import cn.gdou.edu.net.JsoupUtils;
import cn.gdou.edu.net.LibAPI;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;

public class SearchActivity extends BaseActivity {

	private ListView list;
	private EditText search_edit;
	private LibAPI lib;
	private ProgressDialog mypDialog;
	private List<Map<String, String>> datelist;
	private Button top_back;
	private Button next;
	private Button pre;
	private TextView sum_number;
	private TextView page_number;
	private double sum = 0;
	private int n = 1;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.search);

		sum_number = (TextView) findViewById(R.id.sum_number);
		page_number = (TextView) findViewById(R.id.page_number);

		next = (Button) findViewById(R.id.next);
		pre = (Button) findViewById(R.id.pre);

		mypDialog = new ProgressDialog(SearchActivity.this);
		mypDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		mypDialog.setTitle("");
		mypDialog.setMessage("ڲ...");
		mypDialog.setIndeterminate(false);

		top_back = (Button) findViewById(R.id.top_back);
		// һҳ
		next.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				if (n >= Math.ceil(sum / 20)) {
					return;
				}
				loadBookInfo load = new loadBookInfo();
				load.execute(search_edit.getText().toString().trim(),
						new String("next"));
			}
		});
		// ǰһҳ
		pre.setOnClickListener(new OnClickListener() {

			public void onClick(View v) {
				if (n <= 1) {
					return;
				}
				loadBookInfo load = new loadBookInfo();
				load.execute(search_edit.getText().toString().trim(),
						new String("next"), new String("pre"));
			}
		});
		list = (ListView) findViewById(R.id.search_section_list);
		search = (ImageButton) findViewById(R.id.search);
		search_edit = (EditText) findViewById(R.id.search_edit);
		search.setOnClickListener(new OnClickListener() {

			public void onClick(View v) {
				loadBookInfo load = new loadBookInfo();
				load.execute(search_edit.getText().toString().trim());
				// lib=new LibAPI();
				// lib.searchBook("ANYWORDS",
				// search_edit.getText().toString().trim());
			}
		});
	}

	class loadBookInfo extends AsyncTask<String, ListView, List<SearchBook>> {

		@Override
		protected void onPreExecute() {
			InputMethodManager im = (InputMethodManager) getSystemService(getApplicationContext().INPUT_METHOD_SERVICE);
			im.hideSoftInputFromWindow(getCurrentFocus()
					.getApplicationWindowToken(),
					InputMethodManager.HIDE_NOT_ALWAYS);
			// getWindow().addFlags(WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM);
			mypDialog.show();
			super.onPreExecute();
		}

		@Override
		protected List<SearchBook> doInBackground(String... params) {
			lib = new LibAPI();
			System.out.println("length:" + params.length);
			if (params.length == 3) {
				n--;
				return lib.searchBook("ANYWORDS", params[0], n);
			}
			if (params.length == 2) {
				n++;
				return lib.searchBook("ANYWORDS", params[0], n);
			} else {
				return lib.searchBook("ANYWORDS", params[0]);
			}
		}

		@Override
		protected void onPostExecute(List<SearchBook> result) {

			sum = JsoupUtils.getSearchNumber();
			sum_number.setText((int) sum + "");
			page_number.setText(n + "/" + (int) Math.ceil(sum / 20));

			mypDialog.cancel();
			datelist = new ArrayList<Map<String, String>>();
			Iterator<SearchBook> it = result.iterator();
			while (it.hasNext()) {
				Map<String, String> map = new HashMap<String, String>();
				SearchBook book = it.next();
				map.put("title", book.getName());
				map.put("writer", book.getWriter());
				map.put("date", book.getDate());
				map.put("min", book.getMin());
				map.put("max", book.getMax());
				map.put("publish", book.getPublish());
				map.put("system_number", book.getSystemnumber());
				datelist.add(map);
			}

			SimpleAdapter adapter = new SimpleAdapter(getApplicationContext(),
					datelist, R.layout.search_view, new String[] { "title",
							"writer", "date", "publish", "max", "min",
							"system_number" }, new int[] { R.id.Title,
							R.id.writer, R.id.date, R.id.publish, R.id.max,
							R.id.min, R.id.system_number });
			list.setAdapter(adapter);
			list.setOnItemClickListener(new OnItemClickListener() {

				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					Intent intent = new Intent();
					intent.putExtra("number", ((TextView) view
							.findViewById(R.id.system_number)).getText());
					intent.putExtra("bookname", ((TextView) view
							.findViewById(R.id.Title)).getText());
					intent.putExtra("date",
							((TextView) view.findViewById(R.id.date)).getText());
					intent.putExtra("publish", ((TextView) view
							.findViewById(R.id.publish)).getText());
					intent.setClass(getApplicationContext(),
							Search_book_info.class);
					startActivityForResult(intent, RESULT_OK);
				}
			});
			super.onPostExecute(result);
		}

	}

}
