package cn.gdou.edu.net;

import java.util.ArrayList;
import java.util.List;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import cn.gdou.edu.data.BookInfo;
import cn.gdou.edu.data.SearchBook;
import cn.gdou.edu.data.SearchBookAddress;
import cn.gdou.edu.data.StudentInfo;

public class JsoupUtils {
	public static String get__VIEWSTATE() {
		return __VIEWSTATE;
	}

	public static String get__EVENTVALIDATION() {
		return __EVENTVALIDATION;
	}
	private static String __VIEWSTATE;
	private static String __EVENTVALIDATION;
	private static int borrowedmax;//ʷҳ
//	private static StudentInfo student;
//	private static BookInfo book;
	private static int searchNumber;
	
	public static int getSearchNumber() {
		return searchNumber;
	}
	public static int getBorrowedmax() {
		return borrowedmax;
	}

	public static void setBorrowedmax(int borrowedmax) {
		JsoupUtils.borrowedmax = borrowedmax;
	}

	// ûϢ
	public static StudentInfo getUserInfo(String html) {
		Document doc = Jsoup.parse(html);
		Elements es = doc.getElementById("userInfoContent").getElementsByClass(
				"infoline");
		StudentInfo student = new StudentInfo();
		int count = 0;
		for (Element e : es) {
			// System.out.println(e.getElementsByClass("inforight").text());
			System.out.println("---------");
			
			switch (count) {
			case 0:
				student.setNumber(e.getElementsByClass("inforight").text());
				break;
			case 1:
				student.setName(e.getElementsByClass("inforight").text());
				break;
			case 2:
				student.setType(e.getElementsByClass("inforight").text());
				break;
			case 3:
				student.setUnits(e.getElementsByClass("inforight").text());
				break;
			case 4:
				student.setState(e.getElementsByClass("inforight").text());
				break;
			case 5:
				student.setTele(e.getElementsByClass("inforight").text());
				break;
			case 6:
				student.setMobile(e.getElementsByClass("inforight").text());
				break;
			case 7:
				student.setOther(e.getElementsByClass("inforight").text());
				break;
			case 8:
				student.setEmail(e.getElementsByClass("inforight").text());
				break;
			case 9:
				student.setAddress(e.getElementsByClass("inforight").text());
				break;
			case 10:
				student.setMoney(e.getElementsByClass("inforight").text());
				break;
			default:
				break;
			}
			count++;
		}
//		System.out.println(student);
		return student;
	}

	public static void get__Viewstate(String html){
		Document doc = Jsoup.parse(html);		
		System.out.println("-------view--------");
		__VIEWSTATE=doc.getElementById("__VIEWSTATE").attr("value").toString();
		__EVENTVALIDATION=doc.getElementById("__EVENTVALIDATION").attr("value").toString();
	}
	// ͽ
	public static List<BookInfo> getBorrowedContent(String html) {
		List<BookInfo> list=new ArrayList<BookInfo>();
		Document doc = Jsoup.parse(html);
		Elements es = doc.getElementById("borrowedcontent").getElementsByTag(
				"tr");
		System.out.println("-------view--------");
		__VIEWSTATE=doc.getElementById("__VIEWSTATE").attr("value").toString();
		__EVENTVALIDATION=doc.getElementById("__EVENTVALIDATION").attr("value").toString();
		int n = 1;
		for (Element e : es) {
			if (n > 1) {
				System.out.println("--------borrowed-----");
				Elements tdes = e.getElementsByTag("td");
//				int count = 0;
				BookInfo book=new BookInfo();
				for (int i=1;i<tdes.size();i++) {	
					switch (i) {
					case 0:
//						System.out.println(tmp.text());
						break;
					case 1:
						book.setBack_time(tdes.get(i).text());
//						System.out.println("Ӧ  " + tmp.text());
						break;
					case 2:
//						System.out.println("   " + tmp.text());
						book.setBook_writer(tdes.get(i).text());
						break;
					case 3:
//						System.out.println("  " + tmp.text());
						break;
					case 4:
//						System.out.println("ͼ  " + tmp.text());
						break;
					case 5:
//						System.out.println("¼  " + tmp.text());
						break;
					case 6:
//						System.out.println("  " + tmp.text());
						book.setBorrowed_time(tdes.get(i).text());
						break;
					default:
						break;
					}
				}
				list.add(book);
			}
			n++;
		}
		return list;
	}
	//ͽʷ¼
	public static void getBorrowedHistory(String html){
		Document doc=Jsoup.parse(html);
		borrowedmax=doc.getElementById("ctl00_cpRight_Pagination2_gotoddl2").getElementsByTag("option").size();
//		System.out.println(doc.getElementsByClass("tb"));
		Elements ees=doc.getElementsByClass("tb");
		for(Element e:ees){
			Elements es=e.getElementsByTag("tr");
			for(int j=1;j<es.size();j++){
				
				System.out.println("------------------");
//				System.out.println(tmp.text());
				Elements des=es.get(j).getElementsByTag("td");
//				System.out.println(es.get(j).getElementsByTag("td").text());
				BookInfo book=new BookInfo();
				for(int i=0;i<des.size();i++){
					System.out.println(des.get(i).text());
					switch (i) {
					case 0:
						book.setBorrowed_time(des.get(i).text());
						break;
					case 1:
						book.setBack_time(des.get(i).text());
						break;
					case 2:
						book.setBook_writer(des.get(i).text());
						break;
					case 3:
						book.setBook_type(des.get(i).text());
						break;
					case 4:
						book.setLogin_number(des.get(i).text());
						break;
					
					}
				}
			}
		}
		
	}
	
	//
		public static List<SearchBook> getSearchBook(String html){
			List<SearchBook> list=new ArrayList<SearchBook>();
			Document doc=Jsoup.parse(html);
			searchNumber=Integer.parseInt(doc.getElementById("ctl00_ContentPlaceHolder1_countlbl").text());
			if(searchNumber==0){
				return null;
			}
			Elements es=doc.getElementsByClass("tb").get(0).getElementsByTag("tr");
			for(int i=1;i<es.size();i++){
				SearchBook book=new SearchBook();
				Elements tdes= es.get(i).getElementsByTag("td");
				for(int j=0;j<tdes.size();j++){
					switch (j) {
					case 0:
						book.setSystemnumber(tdes.get(j).getElementsByTag("input").attr("value"));
						break;
					case 1:
						book.setName(tdes.get(j).text().trim());
						break;
					case 2:
						book.setWriter(tdes.get(j).text().trim());
						break;
					case 3:
						book.setPublish(tdes.get(j).text().trim());
						break;
					case 4:
						book.setDate(tdes.get(j).text().trim());
						break;
					case 5:
						book.setSearchnumber(tdes.get(j).text().trim());
						break;
					case 6:
						book.setMax(tdes.get(j).text().trim());
						break;
					case 7:
						book.setMin(tdes.get(j).text().trim());
						break;
					default:
						break;
					}
				}
				list.add(book);
				System.out.println(book);
			}
			return list;
		}
		//ͼڵλ
		public static List<SearchBookAddress> getSearch_book_info(String html){
			List<SearchBookAddress> list=new ArrayList<SearchBookAddress>();
			Document doc=Jsoup.parse(html);
			Elements es=doc.getElementById("bardiv").getElementsByTag("tr");
			int len=es.size()-1;
			for(int i=1;i<es.size();i++){
				Elements tdes=es.get(i).getElementsByTag("td");
				System.out.println("----------");
				SearchBookAddress sba=new SearchBookAddress();
				for(int j=0;j<tdes.size();j++){
					if(j==0){
						sba.setAddress(tdes.get(j).text().trim());
						System.out.println(tdes.get(j).text().trim());
					}
					if(j==5){
						sba.setIslent(tdes.get(j).text().trim());
						System.out.println(tdes.get(j).text().trim());
					}
				}
				list.add(sba);
			}
			return list;
		}

}
