/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.PropertyValuesHolder;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    private static final long DEFAULT_FRAME_DELAY = 10L;
    static final int ANIMATION_START = 0;
    static final int ANIMATION_FRAME = 1;
    static final int STOPPED = 0;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    long mStartTime;
    long mSeekTime = -1L;
    private static ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final Interpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mPlayingBackwards = false;
    private int mCurrentIteration = 0;
    private float mCurrentFraction = 0.0f;
    private boolean mStartedDelay = false;
    private long mDelayStartTime;
    int mPlayingState = 0;
    private boolean mRunning = false;
    private boolean mStarted = false;
    boolean mInitialized = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private static long sFrameDelay = 10L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private Interpolator mInterpolator = sDefaultInterpolator;
    private ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setIntValues(values);
        return anim;
    }

    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setFloatValues(values);
        return anim;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setValues(values);
        return anim;
    }

    public static ValueAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim = new ValueAnimator();
        anim.setObjectValues(values);
        anim.setEvaluator(evaluator);
        return anim;
    }

    public void setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        int i = 0;
        while (i < numValues) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
            ++i;
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            int i = 0;
            while (i < numValues) {
                this.mValues[i].init();
                ++i;
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDuration = duration;
        return this;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public void setCurrentPlayTime(long playTime) {
        this.initAnimation();
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = playTime;
            this.mPlayingState = 2;
        }
        this.mStartTime = currentTime - playTime;
        this.animationFrame(currentTime);
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long frameDelay) {
        sFrameDelay = frameDelay;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(Interpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private void start(boolean playBackwards) {
        AnimationHandler animationHandler;
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = playBackwards;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        sPendingAnimations.get().add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(this.getCurrentPlayTime());
            this.mPlayingState = 0;
            this.mRunning = true;
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                int i = 0;
                while (i < numListeners) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
                    ++i;
                }
            }
        }
        if ((animationHandler = sAnimationHandler.get()) == null) {
            animationHandler = new AnimationHandler();
            sAnimationHandler.set(animationHandler);
        }
        animationHandler.sendEmptyMessage(0);
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (this.mPlayingState != 0 || sPendingAnimations.get().contains(this) || sDelayedAnims.get().contains(this)) {
            if (this.mRunning && this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            this.endAnimation();
        }
    }

    @Override
    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        if (this.mRepeatCount > 0 && (this.mRepeatCount & 1) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    @Override
    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    public void reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.mDuration - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
        } else {
            this.start(true);
        }
    }

    private void endAnimation() {
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mRunning && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            int i = 0;
            while (i < numListeners) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                ++i;
            }
        }
        this.mRunning = false;
        this.mStarted = false;
    }

    private void startAnimation() {
        this.initAnimation();
        sAnimations.get().add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            int i = 0;
            while (i < numListeners) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
                ++i;
            }
        }
    }

    private boolean delayedAnimationFrame(long currentTime) {
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = currentTime;
        } else {
            long deltaTime = currentTime - this.mDelayStartTime;
            if (deltaTime > this.mStartDelay) {
                this.mStartTime = currentTime - (deltaTime - this.mStartDelay);
                this.mPlayingState = 1;
                return true;
            }
        }
        return false;
    }

    boolean animationFrame(long currentTime) {
        boolean done = false;
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = currentTime;
            } else {
                this.mStartTime = currentTime - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float fraction;
                float f = fraction = this.mDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (fraction >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int numListeners = this.mListeners.size();
                            int i = 0;
                            while (i < numListeners) {
                                ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                                ++i;
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)fraction;
                        fraction %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        done = true;
                        fraction = Math.min(fraction, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    fraction = 1.0f - fraction;
                }
                this.animateValue(fraction);
            }
        }
        return done;
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float fraction) {
        this.mCurrentFraction = fraction = this.mInterpolator.getInterpolation(fraction);
        int numValues = this.mValues.length;
        int i = 0;
        while (i < numValues) {
            this.mValues[i].calculateValue(fraction);
            ++i;
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            int i2 = 0;
            while (i2 < numListeners) {
                this.mUpdateListeners.get(i2).onAnimationUpdate(this);
                ++i2;
            }
        }
    }

    @Override
    public ValueAnimator clone() {
        int i;
        ValueAnimator anim = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            ArrayList<AnimatorUpdateListener> oldListeners = this.mUpdateListeners;
            anim.mUpdateListeners = new ArrayList();
            int numListeners = oldListeners.size();
            i = 0;
            while (i < numListeners) {
                anim.mUpdateListeners.add(oldListeners.get(i));
                ++i;
            }
        }
        anim.mSeekTime = -1L;
        anim.mPlayingBackwards = false;
        anim.mCurrentIteration = 0;
        anim.mInitialized = false;
        anim.mPlayingState = 0;
        anim.mStartedDelay = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim.mValues = new PropertyValuesHolder[numValues];
            anim.mValuesMap = new HashMap(numValues);
            i = 0;
            while (i < numValues) {
                PropertyValuesHolder newValuesHolder;
                anim.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim.mValuesMap.put(newValuesHolder.getPropertyName(), newValuesHolder);
                ++i;
            }
        }
        return anim;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    public String toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            int i = 0;
            while (i < this.mValues.length) {
                returnVal = String.valueOf(returnVal) + "\n    " + this.mValues[i].toString();
                ++i;
            }
        }
        return returnVal;
    }

    private static class AnimationHandler
    extends Handler {
        private AnimationHandler() {
        }

        public void handleMessage(Message msg) {
            boolean callAgain = true;
            ArrayList animations = (ArrayList)sAnimations.get();
            ArrayList delayedAnims = (ArrayList)sDelayedAnims.get();
            switch (msg.what) {
                case 0: {
                    ArrayList pendingAnimations = (ArrayList)sPendingAnimations.get();
                    if (animations.size() > 0 || delayedAnims.size() > 0) {
                        callAgain = false;
                    }
                    while (pendingAnimations.size() > 0) {
                        ArrayList pendingCopy = (ArrayList)pendingAnimations.clone();
                        pendingAnimations.clear();
                        int count = pendingCopy.size();
                        int i = 0;
                        while (i < count) {
                            ValueAnimator anim = (ValueAnimator)pendingCopy.get(i);
                            if (anim.mStartDelay == 0L) {
                                anim.startAnimation();
                            } else {
                                delayedAnims.add(anim);
                            }
                            ++i;
                        }
                    }
                }
                case 1: {
                    long currentTime = AnimationUtils.currentAnimationTimeMillis();
                    ArrayList readyAnims = (ArrayList)sReadyAnims.get();
                    ArrayList endingAnims = (ArrayList)sEndingAnims.get();
                    int numDelayedAnims = delayedAnims.size();
                    int i = 0;
                    while (i < numDelayedAnims) {
                        ValueAnimator anim = (ValueAnimator)delayedAnims.get(i);
                        if (anim.delayedAnimationFrame(currentTime)) {
                            readyAnims.add(anim);
                        }
                        ++i;
                    }
                    int numReadyAnims = readyAnims.size();
                    if (numReadyAnims > 0) {
                        int i2 = 0;
                        while (i2 < numReadyAnims) {
                            ValueAnimator anim = (ValueAnimator)readyAnims.get(i2);
                            anim.startAnimation();
                            anim.mRunning = true;
                            delayedAnims.remove(anim);
                            ++i2;
                        }
                        readyAnims.clear();
                    }
                    int numAnims = animations.size();
                    int i3 = 0;
                    while (i3 < numAnims) {
                        ValueAnimator anim = (ValueAnimator)animations.get(i3);
                        if (anim.animationFrame(currentTime)) {
                            endingAnims.add(anim);
                        }
                        if (animations.size() == numAnims) {
                            ++i3;
                            continue;
                        }
                        --numAnims;
                        endingAnims.remove(anim);
                    }
                    if (endingAnims.size() > 0) {
                        i3 = 0;
                        while (i3 < endingAnims.size()) {
                            ((ValueAnimator)endingAnims.get(i3)).endAnimation();
                            ++i3;
                        }
                        endingAnims.clear();
                    }
                    if (!callAgain || animations.isEmpty() && delayedAnims.isEmpty()) break;
                    this.sendEmptyMessageDelayed(1, Math.max(0L, sFrameDelay - (AnimationUtils.currentAnimationTimeMillis() - currentTime)));
                }
            }
        }
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }
}

