/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.ComponentName;
import android.content.Intent;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.SubMenu;
import com.actionbarsherlock.internal.view.menu.MenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.SubMenuWrapper;
import com.actionbarsherlock.view.Menu;
import java.util.WeakHashMap;

public class MenuWrapper
implements Menu {
    private final android.view.Menu mNativeMenu;
    private final WeakHashMap<MenuItem, com.actionbarsherlock.view.MenuItem> mNativeMap = new WeakHashMap();

    public MenuWrapper(android.view.Menu nativeMenu) {
        this.mNativeMenu = nativeMenu;
    }

    public android.view.Menu unwrap() {
        return this.mNativeMenu;
    }

    private com.actionbarsherlock.view.MenuItem addInternal(MenuItem nativeItem) {
        MenuItemWrapper item = new MenuItemWrapper(nativeItem);
        this.mNativeMap.put(nativeItem, item);
        return item;
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(CharSequence title) {
        return this.addInternal(this.mNativeMenu.add(title));
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int titleRes) {
        return this.addInternal(this.mNativeMenu.add(titleRes));
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int groupId, int itemId, int order, CharSequence title) {
        return this.addInternal(this.mNativeMenu.add(groupId, itemId, order, title));
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int groupId, int itemId, int order, int titleRes) {
        return this.addInternal(this.mNativeMenu.add(groupId, itemId, order, titleRes));
    }

    private com.actionbarsherlock.view.SubMenu addInternal(SubMenu nativeSubMenu) {
        SubMenuWrapper subMenu = new SubMenuWrapper(nativeSubMenu);
        MenuItem nativeItem = nativeSubMenu.getItem();
        com.actionbarsherlock.view.MenuItem item = subMenu.getItem();
        this.mNativeMap.put(nativeItem, item);
        return subMenu;
    }

    @Override
    public com.actionbarsherlock.view.SubMenu addSubMenu(CharSequence title) {
        return this.addInternal(this.mNativeMenu.addSubMenu(title));
    }

    @Override
    public com.actionbarsherlock.view.SubMenu addSubMenu(int titleRes) {
        return this.addInternal(this.mNativeMenu.addSubMenu(titleRes));
    }

    @Override
    public com.actionbarsherlock.view.SubMenu addSubMenu(int groupId, int itemId, int order, CharSequence title) {
        return this.addInternal(this.mNativeMenu.addSubMenu(groupId, itemId, order, title));
    }

    @Override
    public com.actionbarsherlock.view.SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        return this.addInternal(this.mNativeMenu.addSubMenu(groupId, itemId, order, titleRes));
    }

    @Override
    public int addIntentOptions(int groupId, int itemId, int order, ComponentName caller, Intent[] specifics, Intent intent, int flags, com.actionbarsherlock.view.MenuItem[] outSpecificItems) {
        int result;
        if (outSpecificItems != null) {
            MenuItem[] nativeOutItems = new MenuItem[outSpecificItems.length];
            result = this.mNativeMenu.addIntentOptions(groupId, itemId, order, caller, specifics, intent, flags, nativeOutItems);
            int i = 0;
            int length = outSpecificItems.length;
            while (i < length) {
                outSpecificItems[i] = new MenuItemWrapper(nativeOutItems[i]);
                ++i;
            }
        } else {
            result = this.mNativeMenu.addIntentOptions(groupId, itemId, order, caller, specifics, intent, flags, null);
        }
        return result;
    }

    @Override
    public void removeItem(int id2) {
        this.mNativeMap.remove(this.mNativeMenu.findItem(id2));
        this.mNativeMenu.removeItem(id2);
    }

    @Override
    public void removeGroup(int groupId) {
        int i = 0;
        while (i < this.mNativeMenu.size()) {
            MenuItem item = this.mNativeMenu.getItem(i);
            if (item.getGroupId() == groupId) {
                this.mNativeMap.remove(item);
            }
            ++i;
        }
        this.mNativeMenu.removeGroup(groupId);
    }

    @Override
    public void clear() {
        this.mNativeMap.clear();
        this.mNativeMenu.clear();
    }

    public void invalidate() {
        if (this.mNativeMap.isEmpty()) {
            return;
        }
        WeakHashMap<MenuItem, com.actionbarsherlock.view.MenuItem> menuMapCopy = new WeakHashMap<MenuItem, com.actionbarsherlock.view.MenuItem>(this.mNativeMap.size());
        int i = 0;
        while (i < this.mNativeMenu.size()) {
            MenuItem item = this.mNativeMenu.getItem(i);
            menuMapCopy.put(item, this.mNativeMap.get(item));
            ++i;
        }
        this.mNativeMap.clear();
        this.mNativeMap.putAll(menuMapCopy);
    }

    @Override
    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        this.mNativeMenu.setGroupCheckable(group, checkable, exclusive);
    }

    @Override
    public void setGroupVisible(int group, boolean visible) {
        this.mNativeMenu.setGroupVisible(group, visible);
    }

    @Override
    public void setGroupEnabled(int group, boolean enabled) {
        this.mNativeMenu.setGroupEnabled(group, enabled);
    }

    @Override
    public boolean hasVisibleItems() {
        return this.mNativeMenu.hasVisibleItems();
    }

    @Override
    public com.actionbarsherlock.view.MenuItem findItem(int id2) {
        MenuItem nativeItem = this.mNativeMenu.findItem(id2);
        return this.findItem(nativeItem);
    }

    public com.actionbarsherlock.view.MenuItem findItem(MenuItem nativeItem) {
        if (nativeItem == null) {
            return null;
        }
        com.actionbarsherlock.view.MenuItem wrapped = this.mNativeMap.get(nativeItem);
        if (wrapped != null) {
            return wrapped;
        }
        return this.addInternal(nativeItem);
    }

    @Override
    public int size() {
        return this.mNativeMenu.size();
    }

    @Override
    public com.actionbarsherlock.view.MenuItem getItem(int index) {
        MenuItem nativeItem = this.mNativeMenu.getItem(index);
        return this.findItem(nativeItem);
    }

    @Override
    public void close() {
        this.mNativeMenu.close();
    }

    @Override
    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        return this.mNativeMenu.performShortcut(keyCode, event, flags);
    }

    @Override
    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.mNativeMenu.isShortcutKey(keyCode, event);
    }

    @Override
    public boolean performIdentifierAction(int id2, int flags) {
        return this.mNativeMenu.performIdentifierAction(id2, flags);
    }

    @Override
    public void setQwertyMode(boolean isQwerty) {
        this.mNativeMenu.setQwertyMode(isQwerty);
    }
}

