/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import java.lang.reflect.Field;

public class PopupWindowCompat
extends PopupWindow {
    private static final Field superListenerField;
    private static final ViewTreeObserver.OnScrollChangedListener NOP;
    private ViewTreeObserver.OnScrollChangedListener mSuperScrollListener;
    private ViewTreeObserver mViewTreeObserver;

    static {
        Field f = null;
        try {
            f = PopupWindow.class.getDeclaredField("mOnScrollChangedListener");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        superListenerField = f;
        NOP = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
            }
        };
    }

    public PopupWindowCompat() {
        this.init();
    }

    public PopupWindowCompat(Context context) {
        super(context);
        this.init();
    }

    public PopupWindowCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PopupWindowCompat(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public PopupWindowCompat(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public PopupWindowCompat(int width, int height) {
        super(width, height);
        this.init();
    }

    public PopupWindowCompat(View contentView) {
        super(contentView);
        this.init();
    }

    public PopupWindowCompat(View contentView, int width, int height, boolean focusable) {
        super(contentView, width, height, focusable);
        this.init();
    }

    public PopupWindowCompat(View contentView, int width, int height) {
        super(contentView, width, height);
        this.init();
    }

    private void init() {
        if (superListenerField != null) {
            try {
                this.mSuperScrollListener = (ViewTreeObserver.OnScrollChangedListener)superListenerField.get((Object)this);
                superListenerField.set((Object)this, NOP);
            }
            catch (Exception e) {
                this.mSuperScrollListener = null;
            }
        }
    }

    private void unregisterListener() {
        if (this.mSuperScrollListener != null && this.mViewTreeObserver != null) {
            if (this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeOnScrollChangedListener(this.mSuperScrollListener);
            }
            this.mViewTreeObserver = null;
        }
    }

    private void registerListener(View anchor) {
        if (this.mSuperScrollListener != null) {
            ViewTreeObserver vto;
            ViewTreeObserver viewTreeObserver = vto = anchor.getWindowToken() != null ? anchor.getViewTreeObserver() : null;
            if (vto != this.mViewTreeObserver) {
                if (this.mViewTreeObserver != null && this.mViewTreeObserver.isAlive()) {
                    this.mViewTreeObserver.removeOnScrollChangedListener(this.mSuperScrollListener);
                }
                if ((this.mViewTreeObserver = vto) != null) {
                    vto.addOnScrollChangedListener(this.mSuperScrollListener);
                }
            }
        }
    }

    public void showAsDropDown(View anchor, int xoff, int yoff) {
        super.showAsDropDown(anchor, xoff, yoff);
        this.registerListener(anchor);
    }

    public void update(View anchor, int xoff, int yoff, int width, int height) {
        super.update(anchor, xoff, yoff, width, height);
        this.registerListener(anchor);
    }

    public void update(View anchor, int width, int height) {
        super.update(anchor, width, height);
        this.registerListener(anchor);
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
        this.unregisterListener();
    }

    public void dismiss() {
        super.dismiss();
        this.unregisterListener();
    }
}

