package com.etime.green;

import java.util.Timer;
import java.util.TimerTask;

import com.etime.adapter.ContentPagerAdapter;
import com.jeremyfeinstein.slidingmenu.lib.SlidingMenu;
import com.jeremyfeinstein.slidingmenu.lib.app.SlidingFragmentActivity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;

public class MainActivity extends SlidingFragmentActivity implements OnClickListener  {
	protected SlidingMenu mSlidingMenu;
	private ImageButton ivTitleBtnRight;
//	private Fragment mContent;
	private ImageButton ivTitleBtnLeft;
	LinearLayout  relayout = null;
	private FrameLayout mFrameLayout = null;
	private ViewPager vpager;
	private Button leftbtn;
	private Button midbtn;
	private Button rightbtn;
	@Override
	public void onCreate(Bundle savedInstanceState) {
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_page);
		relayout = (LinearLayout) findViewById(R.id.mainviewpager);
		mFrameLayout = (FrameLayout) findViewById(R.id.content_frame);
		vpager = (ViewPager) findViewById(R.id.vPager);
		initSlidingMenu();
		initView();
	}
	
	private void initSlidingMenu() {

		// TODO Auto-generated method stub
//		mContent = new Fragment_Check();
//		getSupportFragmentManager().beginTransaction().replace(R.id.content_frame, mContent).commit();
		//vpʾ
		mFrameLayout.setVisibility(View.GONE);
		relayout.setVisibility(View.VISIBLE);
		vpager.setAdapter(new ContentPagerAdapter(getSupportFragmentManager()));
        vpager.setOnPageChangeListener(new OnPageChangeListener() {

			@Override
			public void onPageSelected(int position) {
				setCurrentPage(position);
			}

			@Override
			public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
				// ignore
			}

			@Override
			public void onPageScrollStateChanged(int state) {
				// ignore
			}
		});
		
		
		setBehindContentView(R.layout.main_left_layout);//̨Ϊյframelayout
		FragmentTransaction mFragementTransaction = getSupportFragmentManager()
				.beginTransaction();
		Fragment mFrag = new LeftSlidingMenuFragment();
		mFragementTransaction.replace(R.id.main_left_fragment, mFrag);//̨framelayout滻Ϊslidingmenu
		mFragementTransaction.commit();
		mSlidingMenu = getSlidingMenu();
		mSlidingMenu.setMode(SlidingMenu.LEFT);
		mSlidingMenu.setBehindOffsetRes(R.dimen.slidingmenu_offset);
		mSlidingMenu.setFadeDegree(0.35f);
		mSlidingMenu.setTouchModeAbove(SlidingMenu.TOUCHMODE_FULLSCREEN);
		mSlidingMenu.setShadowDrawable(R.drawable.shadow);
		mSlidingMenu.setFadeEnabled(true);
		mSlidingMenu.setBehindScrollScale(0.333f);
	}

	protected void setCurrentPage(int position) {
		// TODO Auto-generated method stub
		if(position==0){
			leftbtn.setSelected(true);
			midbtn.setSelected(false);
			rightbtn.setSelected(false);
			getSlidingMenu().setTouchModeAbove(SlidingMenu.TOUCHMODE_FULLSCREEN);
		}else if(position==1){
			leftbtn.setSelected(false);
			midbtn.setSelected(true);
			rightbtn.setSelected(false);
			getSlidingMenu().setTouchModeAbove(SlidingMenu.TOUCHMODE_NONE);
		}else if(position==2){
			leftbtn.setSelected(false);
			midbtn.setSelected(false);
			rightbtn.setSelected(true);
			getSlidingMenu().setTouchModeAbove(SlidingMenu.TOUCHMODE_NONE);
		}
	}

	private void initView() {
		ivTitleBtnLeft = (ImageButton)this.findViewById(R.id.ivTitleBtnLeft);
		ivTitleBtnLeft.setOnClickListener(this);
		leftbtn = (Button) findViewById(R.id.lfet_button);
		midbtn = (Button) findViewById(R.id.mid_button);
		rightbtn = (Button) findViewById(R.id.right_button);
		ivTitleBtnRight = (ImageButton) findViewById(R.id.ivTitleBtnRigh);
		ivTitleBtnRight.setOnClickListener(this);
	}
	
	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) {
		case R.id.ivTitleBtnLeft:
			mSlidingMenu.showMenu(true);
			break;
		case R.id.ivTitleBtnRigh:
			//ҳת
			break;
		default:
				break;
		}
	}

	public void switchContent(Fragment fragment) {
//		mContent = fragment;
		getSupportFragmentManager().beginTransaction()
				.replace(R.id.content_frame, fragment).commit();
		getSlidingMenu().showContent();
	}

	// ˫˳
	/**
	 * ˵ؼӦ
	 */
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// TODO Auto-generated method stub
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			exitBy2Click(); // ˫˳
		}
		return false;
	}

	/**
	 * ˫˳
	 */
	private static Boolean isExit = false;

	private void exitBy2Click() {
		Timer tExit = null;
		if (isExit == false) {
			isExit = true; // ׼˳
			Toast.makeText(this, "ٰһ˳", Toast.LENGTH_SHORT).show();
			tExit = new Timer();
			tExit.schedule(new TimerTask() {
				@Override
				public void run() {
					isExit = false; // ȡ˳
				}
			}, 2000); // 2ûа·ؼʱȡղִе

		} else {
			finish();
			System.exit(0);
		}
	}

}
