package cn.ccy.test_weather;

import java.util.ArrayList;

import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTabHost;
import android.support.v4.view.ViewPager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TabHost;
import android.widget.TabHost.TabSpec;
import android.widget.TabWidget;
import android.widget.Toast;
import cn.ccy.test_weather.ui.ForthDayFragment;
import cn.ccy.test_weather.ui.ThirdDayFragment;
import cn.ccy.test_weather.ui.TodayFragment;
import cn.ccy.test_weather.ui.TomorrowFragment;
import cn.ccy.test_weather_model.WeatherDetail;

public class ShowWeatherView extends FragmentActivity {

	private FragmentTabHost mTabHost;
	private RadioGroup mTabRg;
	private ViewPager mViewPage;
	TabsAdapter mTabsAdapter;
	private ActionBar actionBar;
	public static WeatherDetail wd;
	private static AlertDialog.Builder builder;
	private long lastClickTime = 0;

	private final Class[] fragments = { TodayFragment.class,
			TomorrowFragment.class, ThirdDayFragment.class,
			ForthDayFragment.class };

	@Override
	protected void onDestroy() {
		System.out.println("---ShowWeatherView.onDestroy---");
		super.onDestroy();
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_pager);
		Intent i = getIntent();
		if (i.hasExtra("detailContent")) {
			wd = i.getParcelableExtra("detailContent");
		}

		actionBar = getActionBar();
		if (wd!= null)
			actionBar.setTitle(wd.getCity());
		// ǷʾӦóͼ
		actionBar.setDisplayShowHomeEnabled(false);
		// ӦóͼΪɵİť
		actionBar.setHomeButtonEnabled(false);
		// ӦóͼΪɵİťͼͷ
		// actionBar.setDisplayHomeAsUpEnabled(true);

		initView();
		if (savedInstanceState != null) {
			mTabHost.setCurrentTabByTag(savedInstanceState.getString("tab"));
		}
	}

	private void initView() {

		mTabHost = (FragmentTabHost) findViewById(android.R.id.tabhost);
		mTabHost.setup(this, getSupportFragmentManager());
		mViewPage = (ViewPager) findViewById(R.id.pager);
		mTabRg = (RadioGroup) findViewById(R.id.tab_rg_menu);
		mTabsAdapter = new TabsAdapter(this, mTabHost, mViewPage, mTabRg);
		// õfragmentĸ
		int count = fragments.length;
		for (int i = 0; i < count; i++) {
			// ΪÿһTabťͼꡢֺ
			TabSpec tabSpec = mTabHost.newTabSpec(i + "").setIndicator(i + "");
			// TabťӽTabѡ
			mTabHost.addTab(tabSpec, fragments[i], null);

			mTabsAdapter.addTab(mTabHost.newTabSpec(i + "")
					.setIndicator(i + ""), fragments[i], null);
		}

		mTabRg.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				switch (checkedId) {
				case R.id.tab_rb_1:
					mTabHost.setCurrentTab(0);
					break;
				case R.id.tab_rb_2:
					mTabHost.setCurrentTab(1);

					break;
				case R.id.tab_rb_3:

					mTabHost.setCurrentTab(2);
					break;
				case R.id.tab_rb_4:

					mTabHost.setCurrentTab(3);
					break;

				default:
					break;
				}
			}
		});
		// mTabHost.setCurrentTab(0);
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		outState.putString("tab", mTabHost.getCurrentTabTag());
	}

	public static class TabsAdapter extends FragmentPagerAdapter implements
			TabHost.OnTabChangeListener, ViewPager.OnPageChangeListener {
		private final Context mContext;
		private final TabHost mTabHost;
		private final ViewPager mViewPager;
		private final RadioGroup mTabRg;
		private final ArrayList<TabInfo> mTabs = new ArrayList<TabInfo>();

		static final class TabInfo {
			private final String tag;
			private final Class<?> clss;
			private final Bundle args;

			TabInfo(String _tag, Class<?> _class, Bundle _args) {
				tag = _tag;
				clss = _class;
				args = _args;
			}
		}

		static class DummyTabFactory implements TabHost.TabContentFactory {
			private final Context mContext;

			public DummyTabFactory(Context context) {
				mContext = context;
			}

			@Override
			public View createTabContent(String tag) {
				View v = new View(mContext);
				v.setMinimumWidth(0);
				v.setMinimumHeight(0);
				return v;
			}
		}

		public TabsAdapter(FragmentActivity activity, TabHost tabHost,
				ViewPager pager, RadioGroup tabRg) {
			super(activity.getSupportFragmentManager());
			mContext = activity;
			mTabHost = tabHost;
			mViewPager = pager;
			mTabRg = tabRg;
			mTabHost.setOnTabChangedListener(this);
			mViewPager.setAdapter(this);
			mViewPager.setOnPageChangeListener(this);
		}

		public void addTab(TabHost.TabSpec tabSpec, Class<?> clss, Bundle args) {
			tabSpec.setContent(new DummyTabFactory(mContext));
			String tag = tabSpec.getTag();

			TabInfo info = new TabInfo(tag, clss, args);
			mTabs.add(info);
			mTabHost.addTab(tabSpec);
			notifyDataSetChanged();
		}

		@Override
		public int getCount() {
			return mTabs.size();
		}

		@Override
		public Fragment getItem(int position) {
			TabInfo info = mTabs.get(position);
			return Fragment.instantiate(mContext, info.clss.getName(),
					info.args);
		}

		@Override
		public void onTabChanged(String tabId) {
			int position = mTabHost.getCurrentTab();
			mViewPager.setCurrentItem(position);
			((RadioButton) mTabRg.getChildAt(position)).setChecked(true);
		}

		@Override
		public void onPageScrolled(int position, float positionOffset,
				int positionOffsetPixels) {
		}

		@Override
		public void onPageSelected(int position) {
			TabWidget widget = mTabHost.getTabWidget();
			int oldFocusability = widget.getDescendantFocusability();
			widget.setDescendantFocusability(ViewGroup.FOCUS_BLOCK_DESCENDANTS);
			mTabHost.setCurrentTab(position);
			widget.setDescendantFocusability(oldFocusability);
		}

		@Override
		public void onPageScrollStateChanged(int state) {
		}
	}

	// Զ˵ť
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		MenuInflater inflator = new MenuInflater(this);
		// ״̬R.menu.contextӦĲ˵ӵmenu
		inflator.inflate(R.menu.my_menu, menu);

		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		// жϵĸ˵ԵӦ
		if (item.getItemId() == R.id.location) {
			builder = new AlertDialog.Builder(ShowWeatherView.this)
			// öԻ
					.setTitle("¶λ")
					// ͼ
					.setMessage("ǷҪ¶λ").setIcon(R.drawable.ic_launcher);

			// ΪAlertDialog.Builderӡȷť
			setPositiveButton(ShowWeatherView.this);
			// ΪAlertDialog.Builderӡȡť
			setNegativeButton(ShowWeatherView.this).create().show();
		}
		return super.onOptionsItemSelected(item);
	}

	public static AlertDialog.Builder setPositiveButton(final Context context) {
		// setPositiveButtonȷť
		return builder.setPositiveButton("ȷ",
				new android.content.DialogInterface.OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						Intent i = new Intent(context, MainActivity.class);
						context.startActivity(i);
						((Activity) context).finish();
					}

				});
	}

	public static AlertDialog.Builder setNegativeButton(final Context context) {
		// setNegativeButtonȡť
		return builder.setNegativeButton("ȡ",
				new android.content.DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {

					}
				});
	}

	public void onBackPressed() {

		if (lastClickTime <= 0) {
			Toast.makeText(this, "ٰһκ˼˳Ӧ", Toast.LENGTH_SHORT).show();
			lastClickTime = System.currentTimeMillis();
		} else {
			long currentClickTime = System.currentTimeMillis();
			if (currentClickTime - lastClickTime < 1500) {
				finish();
			} else {
				Toast.makeText(this, "ٰһκ˼˳Ӧ", Toast.LENGTH_SHORT).show();
				lastClickTime = currentClickTime;
			}
		}
	}

}
