package cn.ccy.test_weather.ui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.serialization.SoapObject;
import org.xmlpull.v1.XmlPullParserException;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import cn.ccy.test_weather.R;
import cn.ccy.test_weather.ShowWeatherView;
import cn.ccy.test_weather.utils.ParseDetail;
import cn.ccy.test_weather_model.WeatherDetail;
import cn.ccy.text_weather.services.GetWeatherService;

public class Welcome extends Activity {

	Button bt;
	TextView tv;
	int count = 0;
	public static Handler handler;
	public static Runnable runnable;
	private static ProgressDialog progressBar;
	public static FileOutputStream fos;
	public static FileInputStream fis;
	private static WeatherDetail detailContent = null;
	private Intent intent;
	private static ParseDetail p;
	private String city;
	private final int SPLASH_DISPLAY_LENGHT = 3000;
	SharedPreferences preferences;
	public static SharedPreferences.Editor editor;

	@Override
	protected void onDestroy() {
		System.out.println("Welcome  onDestroy");
		super.onDestroy();
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.welcome);
		preferences = getSharedPreferences("Test_Weather", 0);
		editor = preferences.edit();
		count = preferences.getInt("Count", 0);

		new Handler().postDelayed(new Runnable() {
			@Override
			public void run() {

				/*
				 * Count > 1
				 */
				if (count > 1) {
					note_Intent(Welcome.this);
					System.out.println("Count > 1 ");
					progressBar = new ProgressDialog(Welcome.this);

					FutureTask<SoapObject> task = new FutureTask<SoapObject>(
							new Callable<SoapObject>() {
								@Override
								public SoapObject call() throws Exception {
									try {
										city = preferences.getString("City",
												"");
										p = new ParseDetail(
												GetWeatherService
														.getWeatherByCity(city,
																handler));
										detailContent = new WeatherDetail();
										detailContent.setContent(p.getList());
										System.out.println("###########" + p);
									} catch (IOException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									} catch (XmlPullParserException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}

									return null;
								}
							});
					new Thread(task).start();
				} else {
					/*
					 * Count < 1 
					 */
					editor.putInt("Count", 2);
					editor.commit();
					intent = new Intent(Welcome.this, WelcomeFirst.class);
					intent.putExtra("Count", count);
					startActivity(intent);
					overridePendingTransition(android.R.anim.fade_in,
							android.R.anim.fade_out);
					finish();

					// setContentView(R.layout.welcome);
					//
				}

			}

		}, SPLASH_DISPLAY_LENGHT);

		handler = new Handler() {
			public void handleMessage(Message msg) {
				if (msg.what == 0x1233) {
					intent = new Intent(Welcome.this, ShowWeatherView.class);

					intent.putExtra("detailContent", detailContent);
					startActivity(intent);
					overridePendingTransition(android.R.anim.fade_in,
							android.R.anim.fade_out);
					finish();
				}
			}
		};

		runnable = new Runnable() {
			@Override
			public void run() {
				progressBar.setCancelable(false);
				progressBar.setMessage("...");
				progressBar.setIndeterminate(false);
				progressBar.setCanceledOnTouchOutside(false);
				progressBar.show();
			}
		};
	}

	public boolean note_Intent(Context context) {
		ConnectivityManager con = (ConnectivityManager) context
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo networkinfo = con.getActiveNetworkInfo();
		if (networkinfo == null || !networkinfo.isAvailable()) {
			// ǰ粻
			Toast.makeText(context.getApplicationContext(),
					"粻,Internet", Toast.LENGTH_SHORT).show();
			((Activity) context).finish();
			return false;
		}

		return true;

	}
}
