package cn.ccy.test_weather.utils;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;

public class GetProvinceSercice {

	// Web Serviceռ
	static final String SERVICE_NS = "http://WebXml.com.cn/";
	// Web ServiceṩURL
	static final String SERVICE_URL = "http://webservice.webxml.com.cn/WebServices/WeatherWS.asmx";

	// ԶWeb Serviceȡʡб
	public static List<String> getProvinceList() {
		// õķ
		final String methodName = "getRegionProvince";
		// HttpTransportSE
		final HttpTransportSE ht = new HttpTransportSE(SERVICE_URL);
		ht.debug = true;
		// ʹSOAP1.1Э鴴Envelop
		final SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(
				SoapEnvelope.VER11);
		// ʵSoapObject
		SoapObject soapObject = new SoapObject(SERVICE_NS, methodName);
		envelope.bodyOut = soapObject;
		// .NetṩWeb ServiceֽϺõļ
		envelope.dotNet = true;
		//һ߳ʡϢ
		FutureTask<List<String>> task = new FutureTask<List<String>>(
				new Callable<List<String>>() {
					public List<String> call() throws Exception {
						// Web Service
						ht.call(SERVICE_NS + methodName, envelope);
						if (envelope.getResponse() != null) {
							// ȡӦصSOAPϢ
							SoapObject result = (SoapObject) envelope.bodyIn;
							SoapObject detail = (SoapObject) result.getProperty(methodName + "Result");
							// ӦSOAPϢ
							return ParseProvinceOrCity.parseProvinceOrCity(detail);
						}
						return null;
					}
				});
		new Thread(task).start();
		try {
			return task.get();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

}
