/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.Bean;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.NonConfigurationInstance;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class BeanHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final TargetAnnotationHelper annotationHelper;

    public BeanHandler(ProcessingEnvironment processingEnvironment) {
        super(Bean.class, processingEnvironment);
        this.annotationHelper = new TargetAnnotationHelper(this.processingEnv, this.getTarget());
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.typeOrTargetValueHasAnnotation(EBean.class, element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        boolean hasNonConfigurationInstanceAnnotation;
        TypeMirror elementType = this.annotationHelper.extractAnnotationClassParameter(element);
        if (elementType == null) {
            elementType = element.asType();
            elementType = holder.processingEnvironment().getTypeUtils().erasure(elementType);
        }
        String fieldName = element.getSimpleName().toString();
        String typeQualifiedName = ((Object)elementType).toString();
        JClass injectedClass = this.refClass(typeQualifiedName + "_");
        JFieldRef beanField = JExpr.ref(fieldName);
        JBlock block = holder.getInitBody();
        boolean bl = hasNonConfigurationInstanceAnnotation = element.getAnnotation(NonConfigurationInstance.class) != null;
        if (hasNonConfigurationInstanceAnnotation) {
            block = block._if(beanField.eq(JExpr._null()))._then();
        }
        JInvocation getInstance = injectedClass.staticInvoke("getInstance_").arg(holder.getContextRef());
        block.assign(beanField, getInstance);
    }
}

