/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.FragmentById;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class FragmentByIdHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper annotationHelper;

    public FragmentByIdHandler(ProcessingEnvironment processingEnvironment) {
        super(FragmentById.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.extendsFragment(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        TypeMirror elementType = element.asType();
        String typeQualifiedName = ((Object)elementType).toString();
        TypeElement nativeFragmentElement = this.annotationHelper.typeElementFromQualifiedName("android.app.Fragment");
        boolean isNativeFragment = nativeFragmentElement != null && this.annotationHelper.isSubtype(elementType, nativeFragmentElement.asType());
        JMethod findFragmentById = isNativeFragment ? holder.getFindNativeFragmentById() : holder.getFindSupportFragmentById();
        String fieldName = element.getSimpleName().toString();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, element, IRClass.Res.ID, true);
        JBlock methodBody = holder.getOnViewChangedBody();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(this.refClass(typeQualifiedName), JExpr.invoke(findFragmentById).arg(idRef)));
    }
}

