/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.ItemSelect;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ItemSelectHandler
extends AbstractListenerHandler {
    private JMethod onNothingSelectedMethod;

    public ItemSelectHandler(ProcessingEnvironment processingEnvironment) {
        super(ItemSelect.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.validatorHelper.param.hasOneOrTwoParametersAndFirstIsBoolean(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        listenerMethodBody.add(call);
    }

    @Override
    protected void processParameters(JMethod listenerMethod, JInvocation itemSelectedCall, List<? extends VariableElement> parameters) {
        JClass narrowAdapterViewClass = this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
        JVar onItemClickParentParam = listenerMethod.param(narrowAdapterViewClass, "parent");
        listenerMethod.param(this.classes().VIEW, "view");
        JVar onItemClickPositionParam = listenerMethod.param(this.codeModel().INT, "position");
        listenerMethod.param(this.codeModel().LONG, "id");
        itemSelectedCall.arg(JExpr.TRUE);
        boolean hasItemParameter = parameters.size() == 2;
        boolean secondParameterIsInt = false;
        String secondParameterQualifiedName = null;
        if (hasItemParameter) {
            VariableElement secondParameter = parameters.get(1);
            TypeMirror secondParameterType = secondParameter.asType();
            secondParameterQualifiedName = ((Object)secondParameterType).toString();
            boolean bl = secondParameterIsInt = secondParameterType.getKind() == TypeKind.INT;
        }
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                itemSelectedCall.arg(onItemClickPositionParam);
            } else {
                itemSelectedCall.arg(JExpr.cast(this.refClass(secondParameterQualifiedName), JExpr.invoke((JExpression)onItemClickParentParam, "getAdapter").invoke("getItem").arg(onItemClickPositionParam)));
            }
        }
        this.onNothingSelectedMethod.param(narrowAdapterViewClass, "parent");
        JInvocation nothingSelectedCall = this.onNothingSelectedMethod.body().invoke(this.getMethodName());
        nothingSelectedCall.arg(JExpr.FALSE);
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                nothingSelectedCall.arg(JExpr.lit(-1));
            } else {
                nothingSelectedCall.arg(JExpr._null());
            }
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        this.onNothingSelectedMethod = listenerAnonymousClass.method(1, this.codeModel().VOID, "onNothingSelected");
        this.onNothingSelectedMethod.annotate(Override.class);
        return listenerAnonymousClass.method(1, this.codeModel().VOID, "onItemSelected");
    }

    @Override
    protected String getSetterName() {
        return "setOnItemSelectedListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().ON_ITEM_SELECTED_LISTENER;
    }

    @Override
    protected JType getViewClass() {
        return this.classes().ADAPTER_VIEW.narrow(this.codeModel().wildcard());
    }
}

