/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.LongClick;
import org.androidannotations.handler.AbstractListenerHandler;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class LongClickHandler
extends AbstractListenerHandler {
    public LongClickHandler(ProcessingEnvironment processingEnvironment) {
        super(LongClick.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoidOrBoolean(executableElement, valid);
        this.validatorHelper.param.zeroOrOneViewParameter(executableElement, valid);
    }

    @Override
    protected void makeCall(JBlock listenerMethodBody, JInvocation call, TypeMirror returnType) {
        boolean returnMethodResult;
        boolean bl = returnMethodResult = returnType.getKind() != TypeKind.VOID;
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
    }

    @Override
    protected void processParameters(JMethod listenerMethod, JInvocation call, List<? extends VariableElement> parameters) {
        boolean hasViewParameter = parameters.size() == 1;
        JVar viewParam = listenerMethod.param(this.classes().VIEW, "view");
        if (hasViewParameter) {
            call.arg(viewParam);
        }
    }

    @Override
    protected JMethod createListenerMethod(JDefinedClass listenerAnonymousClass) {
        return listenerAnonymousClass.method(1, this.codeModel().BOOLEAN, "onLongClick");
    }

    @Override
    protected String getSetterName() {
        return "setOnLongClickListener";
    }

    @Override
    protected JClass getListenerClass() {
        return this.classes().VIEW_ON_LONG_CLICK_LISTENER;
    }
}

