/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.androidannotations.annotations.OrmLiteDao;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class OrmLiteDaoHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private TargetAnnotationHelper annotationHelper;

    public OrmLiteDaoHandler(ProcessingEnvironment processingEnvironment) {
        super(OrmLiteDao.class, processingEnvironment);
        this.annotationHelper = new TargetAnnotationHelper(this.processingEnv, this.getTarget());
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasOrmLiteJars(element, valid);
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.extendsOrmLiteDaoWithValidModelParameter(element, valid);
        this.validatorHelper.hasASqlLiteOpenHelperParameterizedType(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror modelObjectTypeMirror = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "model");
        JExpression modelClass = this.refClass(((Object)modelObjectTypeMirror).toString()).dotclass();
        TypeMirror databaseHelperTypeMirror = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "helper");
        JFieldVar databaseHelperRef = holder.getDatabaseHelperRef(databaseHelperTypeMirror);
        JBlock initBody = holder.getInitBody();
        JInvocation injectExpr = this.elementExtendsRuntimeExceptionDao(element, modelObjectTypeMirror) ? this.classes().RUNTIME_EXCEPTION_DAO.staticInvoke("createDao").arg(databaseHelperRef.invoke("getConnectionSource")).arg(modelClass) : databaseHelperRef.invoke("getDao").arg(modelClass);
        JTryBlock tryBlock = initBody._try();
        tryBlock.body().assign(JExpr.ref(fieldName), injectExpr);
        JCatchBlock catchBlock = tryBlock._catch(this.classes().SQL_EXCEPTION);
        JVar exception = catchBlock.param("e");
        catchBlock.body().staticInvoke(this.classes().LOG, "e").arg(holder.getGeneratedClass().name()).arg("Could not create DAO " + fieldName).arg(exception);
    }

    private boolean elementExtendsRuntimeExceptionDao(Element element, TypeMirror modelObjectTypeMirror) {
        TypeMirror elementType = element.asType();
        TypeElement runtimeExceptionDaoTypeElement = this.annotationHelper.typeElementFromQualifiedName("com.j256.ormlite.dao.RuntimeExceptionDao");
        WildcardType wildcardType = this.annotationHelper.getTypeUtils().getWildcardType(null, null);
        DeclaredType runtimeExceptionDaoParameterizedType = this.annotationHelper.getTypeUtils().getDeclaredType(runtimeExceptionDaoTypeElement, modelObjectTypeMirror, wildcardType);
        return this.annotationHelper.isSubtype(elementType, runtimeExceptionDaoParameterizedType);
    }
}

