/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.sharedpreferences.Pref;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class PrefHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public PrefHandler(ProcessingEnvironment processingEnvironment) {
        super(Pref.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isSharedPreference(element, validatedElements, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror fieldTypeMirror = element.asType();
        String fieldType = ((Object)fieldTypeMirror).toString();
        if (fieldTypeMirror instanceof ErrorType || fieldTypeMirror.getKind() == TypeKind.ERROR) {
            String elementTypeName = ((Object)fieldTypeMirror).toString();
            String prefTypeName = elementTypeName.substring(0, elementTypeName.length() - "_".length());
            Set<? extends Element> sharedPrefElements = this.validatedModel.getRootAnnotatedElements(SharedPref.class.getName());
            for (Element element2 : sharedPrefElements) {
                TypeElement sharedPrefTypeElement = (TypeElement)element2;
                String sharedPrefSimpleName = sharedPrefTypeElement.getSimpleName().toString();
                String sharedPrefQualifiedName = sharedPrefTypeElement.getQualifiedName().toString();
                if (!sharedPrefSimpleName.equals(prefTypeName)) continue;
                fieldType = sharedPrefQualifiedName + "_";
                break;
            }
        }
        JBlock methodBody = holder.getInitBody();
        JFieldRef field = JExpr.ref(fieldName);
        methodBody.assign(field, JExpr._new(this.refClass(fieldType)).arg(holder.getContextRef()));
    }
}

