/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.SeekBarProgressChange;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.OnSeekBarChangeListenerHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class SeekBarProgressChangeHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper annotationHelper;

    public SeekBarProgressChangeHandler(ProcessingEnvironment processingEnvironment) {
        super(SeekBarProgressChange.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        this.validatorHelper.returnTypeIsVoid((ExecutableElement)element, valid);
        this.validatorHelper.hasSeekBarProgressChangeMethodParameters((ExecutableElement)element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) throws Exception {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int seekBarViewParameterPosition = -1;
        int progressParameterPosition = -1;
        int fromUserParameterPosition = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.widget.SeekBar".equals(((Object)parameterType).toString())) {
                seekBarViewParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() == TypeKind.INT || CanonicalNameConstants.INTEGER.equals(((Object)parameterType).toString())) {
                progressParameterPosition = i;
                continue;
            }
            if (parameterType.getKind() != TypeKind.BOOLEAN && !CanonicalNameConstants.BOOLEAN.equals(((Object)parameterType).toString())) continue;
            fromUserParameterPosition = i;
        }
        List<JFieldRef> idsRefs = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = holder.getOnSeekBarChangeListenerHolder(idRef);
            JBlock methodBody = onSeekBarChangeListenerHolder.getOnProgressChangedBody();
            JFieldRef activityRef = holder.getGeneratedClass().staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == seekBarViewParameterPosition) {
                    JVar seekBarViewParameter = onSeekBarChangeListenerHolder.getOnProgressChangedSeekBarParam();
                    textChangeCall.arg(seekBarViewParameter);
                    continue;
                }
                if (i == progressParameterPosition) {
                    JVar progressParameter = onSeekBarChangeListenerHolder.getOnProgressChangedProgressParam();
                    textChangeCall.arg(progressParameter);
                    continue;
                }
                if (i != fromUserParameterPosition) continue;
                JVar fromUserParameter = onSeekBarChangeListenerHolder.getOnProgressChangedFromUserParam();
                textChangeCall.arg(fromUserParameter);
            }
        }
    }
}

