/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import org.androidannotations.annotations.sharedpreferences.DefaultFloat;
import org.androidannotations.annotations.sharedpreferences.DefaultInt;
import org.androidannotations.annotations.sharedpreferences.DefaultLong;
import org.androidannotations.annotations.sharedpreferences.DefaultRes;
import org.androidannotations.annotations.sharedpreferences.DefaultString;
import org.androidannotations.annotations.sharedpreferences.SharedPref;
import org.androidannotations.api.sharedpreferences.BooleanPrefField;
import org.androidannotations.api.sharedpreferences.FloatPrefField;
import org.androidannotations.api.sharedpreferences.IntPrefField;
import org.androidannotations.api.sharedpreferences.LongPrefField;
import org.androidannotations.api.sharedpreferences.StringPrefField;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.GeneratingAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.holder.SharedPrefHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;
import org.androidannotations.rclass.IRClass;

public class SharedPrefHandler
extends BaseAnnotationHandler<SharedPrefHolder>
implements GeneratingAnnotationHandler<SharedPrefHolder> {
    private IdAnnotationHelper annotationHelper;

    public SharedPrefHandler(ProcessingEnvironment processingEnvironment) {
        super(SharedPref.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public SharedPrefHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        return new SharedPrefHolder(processHolder, annotatedElement);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        TypeElement typeElement = (TypeElement)element;
        this.validatorHelper.isInterface(typeElement, valid);
        List<? extends Element> inheritedMembers = this.processingEnv.getElementUtils().getAllMembers(typeElement);
        for (Element element2 : inheritedMembers) {
            if (((Object)element2.getEnclosingElement().asType()).toString().equals("java.lang.Object")) continue;
            this.validatorHelper.isPrefMethod(element2, valid);
            if (!valid.isValid()) continue;
            this.validatorHelper.hasCorrectDefaultAnnotation((ExecutableElement)element2, valid);
        }
    }

    @Override
    public void process(Element element, SharedPrefHolder holder) {
        this.generateConstructor(element, holder);
        this.generateFieldMethodAndEditorFieldMethod(element, holder);
    }

    private void generateConstructor(Element element, SharedPrefHolder holder) {
        SharedPref sharedPrefAnnotation = element.getAnnotation(SharedPref.class);
        SharedPref.Scope scope = sharedPrefAnnotation.value();
        int mode = sharedPrefAnnotation.mode();
        String interfaceSimpleName = element.getSimpleName().toString();
        JBlock constructorSuperBlock = holder.getConstructorSuperBlock();
        JVar contextParam = holder.getConstructorContextParam();
        switch (scope) {
            case ACTIVITY_DEFAULT: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam)).arg(JExpr.lit(mode)));
                break;
            }
            case ACTIVITY: {
                JMethod getLocalClassName = this.getLocalClassName(holder);
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam).plus(JExpr.lit("_" + interfaceSimpleName))).arg(JExpr.lit(mode)));
                break;
            }
            case UNIQUE: {
                constructorSuperBlock.invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.lit(interfaceSimpleName)).arg(JExpr.lit(mode)));
                break;
            }
            case APPLICATION_DEFAULT: {
                JClass preferenceManagerClass = this.refClass("android.preference.PreferenceManager");
                constructorSuperBlock.invoke("super").arg(preferenceManagerClass.staticInvoke("getDefaultSharedPreferences").arg(contextParam));
                break;
            }
        }
    }

    private JMethod getLocalClassName(SharedPrefHolder holder) {
        JClass stringClass = this.classes().STRING;
        JMethod getLocalClassName = holder.getGeneratedClass().method(20, stringClass, "getLocalClassName");
        JClass contextClass = this.classes().CONTEXT;
        JVar contextParam = getLocalClassName.param(contextClass, "context");
        JBlock body = getLocalClassName.body();
        JVar packageName = body.decl(stringClass, "packageName", contextParam.invoke("getPackageName"));
        JVar className = body.decl(stringClass, "className", contextParam.invoke("getClass").invoke("getName"));
        JVar packageLen = body.decl(this.codeModel().INT, "packageLen", packageName.invoke("length"));
        JExpression condition = className.invoke("startsWith").arg(packageName).not().cor(className.invoke("length").lte(packageLen)).cor(className.invoke("charAt").arg(packageLen).ne(JExpr.lit('.')));
        body._if(condition)._then()._return(className);
        body._return(className.invoke("substring").arg(packageLen.plus(JExpr.lit(1))));
        return getLocalClassName;
    }

    private void generateFieldMethodAndEditorFieldMethod(Element element, SharedPrefHolder sharedPrefHolder) {
        for (ExecutableElement method : this.getValidMethods(element)) {
            this.generateFieldMethod(sharedPrefHolder, method);
            sharedPrefHolder.createEditorFieldMethods(method);
        }
    }

    private List<ExecutableElement> getValidMethods(Element element) {
        List<? extends Element> members = element.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> validMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            validMethods.add(method);
        }
        return validMethods;
    }

    private void generateFieldMethod(SharedPrefHolder holder, ExecutableElement method) {
        String returnType = ((Object)method.getReturnType()).toString();
        JExpression defaultValue = null;
        if ("boolean".equals(returnType)) {
            DefaultBoolean defaultAnnotation = method.getAnnotation(DefaultBoolean.class);
            if (defaultAnnotation != null) {
                defaultValue = JExpr.lit(defaultAnnotation.value());
            }
            this.createFieldMethod(holder, method, defaultValue, IRClass.Res.BOOL, JExpr.lit(false), BooleanPrefField.class, "booleanField");
        } else if ("float".equals(returnType)) {
            DefaultFloat defaultAnnotation = method.getAnnotation(DefaultFloat.class);
            if (defaultAnnotation != null) {
                defaultValue = JExpr.lit(defaultAnnotation.value());
            }
            this.createFieldMethod(holder, method, defaultValue, IRClass.Res.INTEGER, JExpr.lit(0.0f), FloatPrefField.class, "floatField");
        } else if ("int".equals(returnType)) {
            DefaultInt defaultAnnotation = method.getAnnotation(DefaultInt.class);
            if (defaultAnnotation != null) {
                defaultValue = JExpr.lit(defaultAnnotation.value());
            }
            this.createFieldMethod(holder, method, defaultValue, IRClass.Res.INTEGER, JExpr.lit(0), IntPrefField.class, "intField");
        } else if ("long".equals(returnType)) {
            DefaultLong defaultAnnotation = method.getAnnotation(DefaultLong.class);
            if (defaultAnnotation != null) {
                defaultValue = JExpr.lit(defaultAnnotation.value());
            }
            this.createFieldMethod(holder, method, defaultValue, IRClass.Res.INTEGER, JExpr.lit(0L), LongPrefField.class, "longField");
        } else if (CanonicalNameConstants.STRING.equals(returnType)) {
            DefaultString defaultAnnotation = method.getAnnotation(DefaultString.class);
            if (defaultAnnotation != null) {
                defaultValue = JExpr.lit(defaultAnnotation.value());
            }
            this.createFieldMethod(holder, method, defaultValue, IRClass.Res.STRING, JExpr.lit(""), StringPrefField.class, "stringField");
        }
    }

    private void createFieldMethod(SharedPrefHolder holder, ExecutableElement method, JExpression defaultAnnotationValue, IRClass.Res res, JExpression defValue, Class<?> booleanPrefFieldClass, String fieldHelperMethodName) {
        JExpression defaultValue = defaultAnnotationValue;
        if (defaultAnnotationValue == null) {
            defaultValue = method.getAnnotation(DefaultRes.class) != null ? this.extractResValue(holder, method, res) : defValue;
        }
        String fieldName = method.getSimpleName().toString();
        holder.createFieldMethod(booleanPrefFieldClass, fieldName, fieldHelperMethodName, defaultValue);
    }

    private JExpression extractResValue(SharedPrefHolder holder, Element method, IRClass.Res res) {
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(this.processHolder, method, DefaultRes.class.getCanonicalName(), res, true);
        String resourceGetMethodName = null;
        switch (res) {
            case BOOL: {
                resourceGetMethodName = "getBoolean";
                break;
            }
            case INTEGER: {
                resourceGetMethodName = "getInteger";
                break;
            }
            case STRING: {
                resourceGetMethodName = "getString";
                break;
            }
        }
        return holder.getContextField().invoke("getResources").invoke(resourceGetMethodName).arg(idRef);
    }
}

