/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.Trace;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class TraceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public TraceHandler(ProcessingEnvironment processingEnvironment) {
        super(Trace.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.hasValidLogLevel(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        ExecutableElement executableElement = (ExecutableElement)element;
        String tag = this.extractTag(executableElement);
        int level = executableElement.getAnnotation(Trace.class).level();
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(method);
        JBlock methodBody = method.body();
        JInvocation isLoggableInvocation = this.classes().LOG.staticInvoke("isLoggable");
        isLoggableInvocation.arg(JExpr.lit(tag)).arg(this.logLevelFromInt(level, this.classes().LOG));
        JConditional ifStatement = methodBody._if(isLoggableInvocation);
        JInvocation currentTimeInvoke = this.classes().SYSTEM.staticInvoke("currentTimeMillis");
        JBlock _thenBody = ifStatement._then();
        JVar startDeclaration = _thenBody.decl(this.codeModel().LONG, "start", currentTimeInvoke);
        String methodName = "[" + element.toString() + "]";
        String logMethodName = this.logMethodNameFromLevel(level);
        JInvocation logEnterInvoke = this.classes().LOG.staticInvoke(logMethodName);
        logEnterInvoke.arg(tag);
        JExpression enterMessage = JExpr.lit("Entering " + methodName);
        logEnterInvoke.arg(enterMessage);
        _thenBody.add(logEnterInvoke);
        JTryBlock tryBlock = _thenBody._try();
        tryBlock.body().add(previousMethodBody);
        JBlock finallyBlock = tryBlock._finally();
        JVar durationDeclaration = finallyBlock.decl(this.codeModel().LONG, "duration", currentTimeInvoke.minus(startDeclaration));
        JInvocation logExitInvoke = this.classes().LOG.staticInvoke(logMethodName);
        logExitInvoke.arg(tag);
        JExpression exitMessage = JExpr.lit("Exiting " + methodName + ", duration in ms: ").plus(durationDeclaration);
        logExitInvoke.arg(exitMessage);
        finallyBlock.add(logExitInvoke);
        JBlock elseBlock = ifStatement._else();
        elseBlock.add(previousMethodBody);
    }

    private String logMethodNameFromLevel(int level) {
        switch (level) {
            case 3: {
                return "d";
            }
            case 2: {
                return "v";
            }
            case 4: {
                return "i";
            }
            case 5: {
                return "w";
            }
            case 6: {
                return "e";
            }
        }
        throw new IllegalArgumentException("Unrecognized Log level : " + level);
    }

    private JFieldRef logLevelFromInt(int level, JClass logClass) {
        switch (level) {
            case 3: {
                return logClass.staticRef("DEBUG");
            }
            case 2: {
                return logClass.staticRef("VERBOSE");
            }
            case 4: {
                return logClass.staticRef("INFO");
            }
            case 5: {
                return logClass.staticRef("WARN");
            }
            case 6: {
                return logClass.staticRef("ERROR");
            }
        }
        throw new IllegalArgumentException("Unrecognized log level. Given value:" + level);
    }

    private String extractTag(Element element) {
        Trace annotation = element.getAnnotation(Trace.class);
        String tag = annotation.tag();
        if ("NO_TAG".equals(tag)) {
            tag = element.getEnclosingElement().getSimpleName().toString();
        }
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        return tag;
    }
}

