/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler.rest;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.RestAnnotationHelper;
import org.androidannotations.holder.RestHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public abstract class RestMethodHandler
extends BaseAnnotationHandler<RestHolder> {
    protected final RestAnnotationHelper restAnnotationHelper;
    protected final APTCodeModelHelper codeModelHelper;

    public RestMethodHandler(Class<?> targetClass, ProcessingEnvironment processingEnvironment) {
        super(targetClass, processingEnvironment);
        this.restAnnotationHelper = new RestAnnotationHelper(this.processingEnv, this.getTarget());
        this.codeModelHelper = new APTCodeModelHelper();
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.notAlreadyValidated(element, validatedElements, valid);
        this.validatorHelper.enclosingElementHasRestAnnotation(element, validatedElements, valid);
        this.validatorHelper.throwsOnlyRestClientException((ExecutableElement)element, valid);
    }

    @Override
    public void process(Element element, RestHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        String methodName = element.getSimpleName().toString();
        JClass methodReturnClass = this.getMethodReturnClass(element, holder);
        boolean methodReturnVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
        JMethod method = holder.getGeneratedClass().method(1, methodReturnClass, methodName);
        method.annotate(Override.class);
        TreeMap<String, JVar> params = this.addMethodParams(executableElement, holder, method);
        JBlock methodBody = method.body();
        JInvocation exchangeCall = JExpr.invoke((JExpression)holder.getRestTemplateField(), "exchange");
        exchangeCall.arg(this.getUrl(element, holder));
        exchangeCall.arg(this.getHttpMethod());
        exchangeCall.arg(this.getRequestEntity(executableElement, holder, methodBody, params));
        exchangeCall.arg(this.getResponseClass(element, holder));
        JExpression urlVariables = this.getUrlVariables(element, holder, methodBody, params);
        if (urlVariables != null) {
            exchangeCall.arg(urlVariables);
        }
        JExpression returnCall = exchangeCall;
        JFieldRef result = this.setCookies(executableElement, holder, methodBody, exchangeCall);
        if (result != null) {
            returnCall = result;
        }
        if (methodReturnVoid && result == null) {
            this.insertRestTryCatchBlock(holder, methodBody, exchangeCall, methodReturnVoid);
        } else if (!methodReturnVoid) {
            returnCall = this.addResultCallMethod(returnCall, methodReturnClass);
            this.insertRestTryCatchBlock(holder, methodBody, returnCall, methodReturnVoid);
        }
    }

    protected JClass getMethodReturnClass(Element element, RestHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        return this.codeModelHelper.typeMirrorToJClass(executableElement.getReturnType(), holder);
    }

    protected TreeMap<String, JVar> addMethodParams(ExecutableElement executableElement, RestHolder restHolder, JMethod method) {
        List<? extends VariableElement> params = executableElement.getParameters();
        TreeMap<String, JVar> methodParams = new TreeMap<String, JVar>();
        for (VariableElement variableElement : params) {
            JVar param;
            String paramName = variableElement.getSimpleName().toString();
            String paramType = ((Object)variableElement.asType()).toString();
            if (variableElement.asType().getKind().isPrimitive()) {
                param = method.param(JType.parse(this.codeModel(), paramType), paramName);
            } else {
                JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(variableElement.asType(), restHolder);
                param = method.param(parameterClass, paramName);
            }
            methodParams.put(paramName, param);
        }
        return methodParams;
    }

    protected JExpression getUrl(Element element, RestHolder restHolder) {
        String urlSuffix = this.getUrlSuffix(element);
        JExpression url = JExpr.lit(this.getUrlSuffix(element));
        if (!urlSuffix.startsWith("http://") && !urlSuffix.startsWith("https://")) {
            url = JExpr.invoke((JExpression)restHolder.getRootUrlField(), "concat").arg(url);
        }
        return url;
    }

    protected abstract String getUrlSuffix(Element var1);

    protected JExpression getHttpMethod() {
        JClass httpMethod = this.classes().HTTP_METHOD;
        String simpleName = this.getTarget().substring(this.getTarget().lastIndexOf(46) + 1);
        String restMethodInCapitalLetters = simpleName.toUpperCase(Locale.ENGLISH);
        return httpMethod.staticRef(restMethodInCapitalLetters);
    }

    protected JExpression getRequestEntity(ExecutableElement element, RestHolder holder, JBlock methodBody, TreeMap<String, JVar> params) {
        JVar httpHeaders = this.restAnnotationHelper.declareHttpHeaders(element, holder, methodBody);
        JVar entitySentToServer = this.restAnnotationHelper.getEntitySentToServer(element, params);
        return this.restAnnotationHelper.declareHttpEntity(this.processHolder, methodBody, entitySentToServer, httpHeaders);
    }

    protected JExpression getResponseClass(Element element, RestHolder holder) {
        return this.restAnnotationHelper.getResponseClass(element, holder);
    }

    protected JExpression getUrlVariables(Element element, RestHolder holder, JBlock methodBody, TreeMap<String, JVar> params) {
        return this.restAnnotationHelper.declareUrlVariables((ExecutableElement)element, holder, methodBody, params);
    }

    protected JExpression addResultCallMethod(JExpression exchangeCall, JClass methodReturnClass) {
        if (methodReturnClass != null && !methodReturnClass.fullName().startsWith("org.springframework.http.ResponseEntity")) {
            return JExpr.invoke(exchangeCall, "getBody");
        }
        return exchangeCall;
    }

    private JFieldRef setCookies(ExecutableElement executableElement, RestHolder restHolder, JBlock methodBody, JInvocation exchangeCall) {
        String[] settingCookies = this.restAnnotationHelper.settingCookies(executableElement);
        if (settingCookies != null) {
            boolean methodReturnVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
            JClass methodReturnClass = this.getMethodReturnClass(executableElement, restHolder);
            JClass responseEntityClass = this.classes().RESPONSE_ENTITY.narrow(methodReturnVoid ? this.codeModel().VOID : methodReturnClass);
            JVar responseEntity = methodBody.decl(responseEntityClass, "response", exchangeCall);
            JClass stringListClass = this.classes().LIST.narrow(this.classes().STRING);
            JClass stringArrayClass = this.classes().STRING.array();
            JArray cookiesArray = JExpr.newArray(this.classes().STRING);
            for (String cookie : settingCookies) {
                cookiesArray.add(JExpr.lit(cookie));
            }
            JVar requestedCookiesVar = methodBody.decl(stringArrayClass, "requestedCookies", cookiesArray);
            JInvocation setCookiesList = JExpr.invoke((JExpression)responseEntity, "getHeaders").invoke("get").arg("Set-Cookie");
            JVar allCookiesList = methodBody.decl(stringListClass, "allCookies", setCookiesList);
            JForEach forEach = methodBody._if(allCookiesList.ne(JExpr._null()))._then().forEach(this.classes().STRING, "rawCookie", allCookiesList);
            JVar rawCookieVar = forEach.var();
            JBlock forLoopBody = forEach.body();
            JForEach innerForEach = forLoopBody.forEach(this.classes().STRING, "thisCookieName", requestedCookiesVar);
            JBlock innerBody = innerForEach.body();
            JBlock thenBlock = innerBody._if(JExpr.invoke((JExpression)rawCookieVar, "startsWith").arg(innerForEach.var()))._then();
            JInvocation valueEnd = rawCookieVar.invoke("indexOf").arg(JExpr.lit(';'));
            JVar valueEndVar = thenBlock.decl(this.codeModel().INT, "valueEnd", valueEnd);
            JBlock fixValueEndBlock = thenBlock._if(valueEndVar.eq(JExpr.lit(-1)))._then();
            fixValueEndBlock.assign(valueEndVar, rawCookieVar.invoke("length"));
            JExpression indexOfValue = rawCookieVar.invoke("indexOf").arg("=").plus(JExpr.lit(1));
            JInvocation cookieValue = rawCookieVar.invoke("substring").arg(indexOfValue).arg(valueEndVar);
            thenBlock.invoke((JExpression)restHolder.getAvailableCookiesField(), "put").arg(innerForEach.var()).arg(cookieValue);
            thenBlock._break();
            return JExpr.ref(responseEntity.name());
        }
        return null;
    }

    private void insertRestTryCatchBlock(RestHolder holder, JBlock body, JExpression returnCall, boolean methodReturnVoid) {
        JTryBlock tryBlock = body._try();
        if (methodReturnVoid) {
            tryBlock.body().add((JInvocation)returnCall);
        } else {
            tryBlock.body()._return(returnCall);
        }
        JCatchBlock jCatch = tryBlock._catch(this.classes().REST_CLIENT_EXCEPTION);
        JBlock catchBlock = jCatch.body();
        JConditional conditional = catchBlock._if(JOp.ne(holder.getRestErrorHandlerField(), JExpr._null()));
        JVar exceptionParam = jCatch.param("e");
        JBlock thenBlock = conditional._then();
        thenBlock.add(holder.getRestErrorHandlerField().invoke("onRestClientExceptionThrown").arg(exceptionParam));
        if (!methodReturnVoid) {
            thenBlock._return(JExpr._null());
        }
        conditional._else()._throw(exceptionParam);
    }
}

