/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSuperWildcard;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;

public class APTCodeModelHelper {
    public JClass typeMirrorToJClass(TypeMirror type, GeneratedClassHolder holder) {
        return this.typeMirrorToJClass(type, holder, Collections.<String, TypeMirror>emptyMap());
    }

    private JClass typeMirrorToJClass(TypeMirror type, GeneratedClassHolder holder, Map<String, TypeMirror> substitute) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            String declaredTypeName = declaredType.asElement().toString();
            JClass declaredClass = holder.refClass(declaredTypeName);
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            ArrayList<JClass> typeArgumentJClasses = new ArrayList<JClass>();
            for (TypeMirror typeMirror : typeArguments) {
                typeArgumentJClasses.add(this.typeMirrorToJClass(typeMirror, holder, substitute));
            }
            if (typeArgumentJClasses.size() > 0) {
                declaredClass = declaredClass.narrow(typeArgumentJClasses);
            }
            return declaredClass;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            TypeMirror bound = wildcardType.getExtendsBound();
            if (bound == null) {
                bound = wildcardType.getSuperBound();
                if (bound == null) {
                    return holder.classes().OBJECT.wildcard();
                }
                return this.superWildcard(this.typeMirrorToJClass(bound, holder, substitute));
            }
            TypeMirror extendsBound = wildcardType.getExtendsBound();
            if (extendsBound == null) {
                return holder.classes().OBJECT.wildcard();
            }
            return this.typeMirrorToJClass(extendsBound, holder, substitute).wildcard();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            JClass refClass = this.typeMirrorToJClass(arrayType.getComponentType(), holder, substitute);
            return refClass.array();
        }
        TypeMirror substituted = substitute.get(((Object)type).toString());
        if (substituted != null && type != substituted) {
            return this.typeMirrorToJClass(substituted, holder, substitute);
        }
        return holder.refClass(((Object)type).toString());
    }

    private JClass superWildcard(JClass bound) {
        return new JSuperWildcard(bound);
    }

    private Map<String, TypeMirror> getActualTypes(Types typeUtils, DeclaredType baseClass, TypeMirror annotatedClass) {
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        superTypes.add(annotatedClass);
        while (!superTypes.isEmpty()) {
            TypeMirror x = (TypeMirror)superTypes.remove(0);
            if (typeUtils.isSameType(typeUtils.erasure(x), typeUtils.erasure(baseClass))) {
                DeclaredType type = (DeclaredType)x;
                HashMap<String, TypeMirror> actualTypes = new HashMap<String, TypeMirror>();
                for (int i = 0; i < type.getTypeArguments().size(); ++i) {
                    TypeMirror formalArg;
                    TypeMirror actualArg = type.getTypeArguments().get(i);
                    if (typeUtils.isSameType(actualArg, formalArg = baseClass.getTypeArguments().get(i))) continue;
                    actualTypes.put(((Object)formalArg).toString(), actualArg);
                }
                return actualTypes;
            }
            superTypes.addAll(typeUtils.directSupertypes(x));
        }
        return Collections.emptyMap();
    }

    public JClass typeBoundsToJClass(GeneratedClassHolder holder, List<? extends TypeMirror> bounds) {
        return this.typeBoundsToJClass(holder, bounds, Collections.<String, TypeMirror>emptyMap());
    }

    private JClass typeBoundsToJClass(GeneratedClassHolder holder, List<? extends TypeMirror> bounds, Map<String, TypeMirror> actualTypes) {
        if (bounds.isEmpty()) {
            return holder.classes().OBJECT;
        }
        return this.typeMirrorToJClass(bounds.get(0), holder, actualTypes);
    }

    public JMethod overrideAnnotatedMethod(ExecutableElement executableElement, GeneratedClassHolder holder) {
        TypeMirror annotatedClass = holder.getAnnotatedElement().asType();
        DeclaredType baseClass = (DeclaredType)executableElement.getEnclosingElement().asType();
        Types typeUtils = holder.processingEnvironment().getTypeUtils();
        Map<String, TypeMirror> actualTypes = this.getActualTypes(typeUtils, baseClass, annotatedClass);
        LinkedHashMap<String, JClass> methodTypes = new LinkedHashMap<String, JClass>();
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            JClass jClassBounds = this.typeBoundsToJClass(holder, bounds, actualTypes);
            methodTypes.put(typeParameterElement.toString(), jClassBounds);
        }
        actualTypes.keySet().removeAll(methodTypes.keySet());
        String methodName = executableElement.getSimpleName().toString();
        JClass jClass = this.typeMirrorToJClass(executableElement.getReturnType(), holder, actualTypes);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < executableElement.getParameters().size(); ++i) {
            VariableElement parameter = executableElement.getParameters().get(i);
            String parameterName = parameter.getSimpleName().toString();
            JClass jClass2 = this.typeMirrorToJClass(parameter.asType(), holder, actualTypes);
            parameters.add(new Parameter(parameterName, jClass2));
        }
        JMethod existingMethod = this.findAlreadyGeneratedMethod(holder.getGeneratedClass(), methodName, parameters);
        if (existingMethod != null) {
            return existingMethod;
        }
        JMethod method = holder.getGeneratedClass().method(1, jClass, methodName);
        method.annotate(Override.class);
        for (Map.Entry entry : methodTypes.entrySet()) {
            method.generify((String)entry.getKey(), (JClass)entry.getValue());
        }
        for (Parameter parameter : parameters) {
            method.param(8, parameter.jClass, parameter.name);
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            JClass thrownType = this.typeMirrorToJClass(typeMirror, holder, actualTypes);
            method._throws(thrownType);
        }
        this.callSuperMethod(method, holder, method.body());
        return method;
    }

    private JMethod findAlreadyGeneratedMethod(JDefinedClass definedClass, String methodName, List<Parameter> parameters) {
        block0: for (JMethod method : definedClass.methods()) {
            if (!method.name().equals(methodName) || method.params().size() != parameters.size()) continue;
            int i = 0;
            for (JVar param : method.params()) {
                String searchedParamType = parameters.get((int)i).jClass.name();
                if (!param.type().name().equals(searchedParamType)) continue block0;
                ++i;
            }
            return method;
        }
        return null;
    }

    public void callSuperMethod(JMethod superMethod, GeneratedClassHolder holder, JBlock callBlock) {
        JFieldRef activitySuper = holder.getGeneratedClass().staticRef("super");
        JInvocation superCall = JExpr.invoke((JExpression)activitySuper, superMethod);
        for (JVar param : superMethod.params()) {
            superCall.arg(param);
        }
        JType returnType = superMethod.type();
        if (returnType.fullName().equals("void")) {
            callBlock.add(superCall);
        } else {
            callBlock._return(superCall);
        }
    }

    public JBlock removeBody(JMethod method) {
        JBlock body = method.body();
        try {
            Field bodyField = JMethod.class.getDeclaredField("body");
            bodyField.setAccessible(true);
            bodyField.set(method, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JBlock clonedBody = new JBlock(false, false);
        for (Object statement : body.getContents()) {
            if (statement instanceof JVar) {
                JVar var = (JVar)statement;
                try {
                    Field varInitField = JVar.class.getDeclaredField("init");
                    varInitField.setAccessible(true);
                    JExpression varInit = (JExpression)varInitField.get(var);
                    clonedBody.decl(var.type(), var.name(), varInit);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            clonedBody.add((JStatement)statement);
        }
        return clonedBody;
    }

    public void replaceSuperCall(JMethod method, JBlock replacement) {
        String superCallStart = "super." + method.name() + "(";
        JBlock oldBody = this.removeBody(method);
        JBlock newBody = method.body();
        for (Object content : oldBody.getContents()) {
            StringWriter writer = new StringWriter();
            JFormatter formatter = new JFormatter(writer);
            JStatement statement = (JStatement)content;
            statement.state(formatter);
            String statementString = writer.getBuffer().toString();
            if (statementString.startsWith(superCallStart)) {
                newBody.add(replacement);
                continue;
            }
            newBody.add(statement);
        }
    }

    public String getIdStringFromIdFieldRef(JFieldRef idRef) {
        try {
            Field nameField = JFieldRef.class.getDeclaredField("name");
            nameField.setAccessible(true);
            String name = (String)nameField.get(idRef);
            if (name != null) {
                return name;
            }
            Field varField = JFieldRef.class.getDeclaredField("var");
            varField.setAccessible(true);
            JVar var = (JVar)varField.get(idRef);
            if (var != null) {
                return var.name();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Unable to extract target name from JFieldRef");
    }

    public JDefinedClass createDelegatingAnonymousRunnableClass(EComponentHolder holder, JMethod delegatedMethod) {
        JCodeModel codeModel = holder.codeModel();
        JBlock previousMethodBody = this.removeBody(delegatedMethod);
        JDefinedClass anonymousRunnableClass = codeModel.anonymousClass(Runnable.class);
        JMethod runMethod = anonymousRunnableClass.method(1, codeModel.VOID, "run");
        runMethod.annotate(Override.class);
        runMethod.body().add(previousMethodBody);
        return anonymousRunnableClass;
    }

    public List<ExecutableElement> getMethods(TypeElement typeElement) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(ElementFilter.methodsIn(enclosedElements));
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType dt = (DeclaredType)typeMirror;
            methods.addAll(ElementFilter.methodsIn(dt.asElement().getEnclosedElements()));
        }
        return methods;
    }

    public JMethod implementMethod(GeneratedClassHolder holder, List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        ExecutableElement method = this.getMethod(methods, methodName, returnType, parameterTypes);
        JMethod jmethod = null;
        if (method != null) {
            JType jcReturnType = returnType.equals(TypeKind.VOID.toString()) ? holder.codeModel().VOID : holder.refClass(returnType);
            jmethod = holder.getGeneratedClass().method(1, jcReturnType, method.getSimpleName().toString());
            jmethod.annotate(Override.class);
            for (int i = 0; i < method.getParameters().size(); ++i) {
                VariableElement param = method.getParameters().get(i);
                jmethod.param(holder.refClass(parameterTypes[i]), param.getSimpleName().toString());
            }
        }
        return jmethod;
    }

    private ExecutableElement getMethod(List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        for (ExecutableElement method : methods) {
            String methodReturnType;
            List<? extends VariableElement> parameters = method.getParameters();
            String string = methodReturnType = method.getReturnType().getKind() == TypeKind.VOID ? TypeKind.VOID.toString() : ((Object)method.getReturnType()).toString();
            if (parameters.size() != parameterTypes.length || !methodReturnType.equals(returnType) || methodName != null && !method.getSimpleName().toString().equals(methodName)) continue;
            boolean validMethod = true;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement param = parameters.get(i);
                if (((Object)param.asType()).toString().equals(parameterTypes[i])) continue;
                validMethod = false;
                break;
            }
            if (!validMethod) continue;
            return method;
        }
        return null;
    }

    public static class Parameter {
        public final String name;
        public final JClass jClass;

        public Parameter(String name, JClass jClass) {
            this.name = name;
            this.jClass = jClass;
        }
    }
}

