/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.Pair;
import org.androidannotations.holder.HasIntentBuilder;

public class IntentBuilder {
    private static final int MIN_SDK_WITH_FRAGMENT_SUPPORT = 11;
    protected HasIntentBuilder holder;
    protected AndroidManifest androidManifest;
    protected JFieldVar contextField;
    protected JClass contextClass;
    protected JClass intentClass;
    protected JFieldVar fragmentField;
    protected JFieldVar fragmentSupportField;
    protected Map<Pair<TypeMirror, String>, JMethod> putExtraMethods = new HashMap<Pair<TypeMirror, String>, JMethod>();
    protected Elements elementUtils;
    protected Types typeUtils;
    protected APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public IntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        this.holder = holder;
        this.androidManifest = androidManifest;
        this.elementUtils = holder.processingEnvironment().getElementUtils();
        this.typeUtils = holder.processingEnvironment().getTypeUtils();
        this.contextClass = holder.classes().CONTEXT;
        this.intentClass = holder.classes().INTENT;
    }

    public void build() throws JClassAlreadyExistsException {
        this.createClass();
        this.createConstructor();
        this.createAdditionalConstructor();
        this.createGet();
        this.createFlags();
        this.createIntent();
    }

    private void createClass() throws JClassAlreadyExistsException {
        this.holder.setIntentBuilderClass(this.holder.getGeneratedClass()._class(17, "IntentBuilder_"));
        this.contextField = this.holder.getIntentBuilderClass().field(4, this.contextClass, "context_");
        this.holder.setIntentField(this.holder.getIntentBuilderClass().field(12, this.intentClass, "intent_"));
    }

    private void createConstructor() {
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorContextParam = constructor.param(this.contextClass, "context");
        JBlock constructorBody = constructor.body();
        constructorBody.assign(this.contextField, constructorContextParam);
        constructorBody.assign(this.holder.getIntentField(), JExpr._new(this.intentClass).arg(constructorContextParam).arg(this.holder.getGeneratedClass().dotclass()));
    }

    private void createAdditionalConstructor() {
        if (this.hasFragmentInClasspath()) {
            this.fragmentField = this.addFragmentConstructor(this.holder.classes().FRAGMENT, "fragment_");
        }
        if (this.hasFragmentSupportInClasspath()) {
            this.fragmentSupportField = this.addFragmentConstructor(this.holder.classes().SUPPORT_V4_FRAGMENT, "fragmentSupport_");
        }
    }

    private void createGet() {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.intentClass, "get");
        method.body()._return(this.holder.getIntentField());
    }

    private void createFlags() {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.getIntentBuilderClass(), "flags");
        JVar flagsParam = method.param(this.holder.codeModel().INT, "flags");
        JBlock body = method.body();
        body.invoke((JExpression)this.holder.getIntentField(), "setFlags").arg(flagsParam);
        body._return(JExpr._this());
    }

    private void createIntent() {
        JVar fragmentParam;
        JMethod method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
        JVar contextParam = method.param(this.contextClass, "context");
        method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(contextParam));
        if (this.hasFragmentInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().FRAGMENT, "fragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
        if (this.hasFragmentSupportInClasspath()) {
            method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
            fragmentParam = method.param(this.holder.classes().SUPPORT_V4_FRAGMENT, "supportFragment");
            method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(fragmentParam));
        }
    }

    private JFieldVar addFragmentConstructor(JClass fragmentClass, String fieldName) {
        JFieldVar fragmentField = this.holder.getIntentBuilderClass().field(4, fragmentClass, fieldName);
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorFragmentParam = constructor.param(fragmentClass, "fragment");
        JBlock constructorBody = constructor.body();
        constructorBody.assign(fragmentField, constructorFragmentParam);
        constructorBody.assign(this.contextField, constructorFragmentParam.invoke("getActivity"));
        constructorBody.assign(this.holder.getIntentField(), JExpr._new(this.holder.classes().INTENT).arg(this.contextField).arg(this.holder.getGeneratedClass().dotclass()));
        return fragmentField;
    }

    private boolean hasFragmentInClasspath() {
        boolean fragmentExistsInSdk = this.androidManifest.getMinSdkVersion() >= 11;
        return fragmentExistsInSdk && this.elementUtils.getTypeElement("android.app.Fragment") != null;
    }

    private boolean hasFragmentSupportInClasspath() {
        return this.elementUtils.getTypeElement("android.support.v4.app.Fragment") != null;
    }

    public JMethod getPutExtraMethod(TypeMirror elementType, String parameterName, JFieldVar extraKeyField) {
        Pair<TypeMirror, String> signature = new Pair<TypeMirror, String>(elementType, parameterName);
        JMethod putExtraMethod = this.putExtraMethods.get(signature);
        if (putExtraMethod == null) {
            putExtraMethod = this.addPutExtraMethod(elementType, parameterName, extraKeyField);
            this.putExtraMethods.put(signature, putExtraMethod);
        }
        return putExtraMethod;
    }

    private JMethod addPutExtraMethod(TypeMirror elementType, String parameterName, JFieldVar extraKeyField) {
        boolean castToSerializable = false;
        boolean castToParcelable = false;
        if (elementType.getKind() == TypeKind.DECLARED) {
            Elements elementUtils = this.holder.processingEnvironment().getElementUtils();
            TypeMirror parcelableType = elementUtils.getTypeElement("android.os.Parcelable").asType();
            if (!this.typeUtils.isSubtype(elementType, parcelableType)) {
                TypeMirror stringType = elementUtils.getTypeElement(CanonicalNameConstants.STRING).asType();
                if (!this.typeUtils.isSubtype(elementType, stringType)) {
                    castToSerializable = true;
                }
            } else {
                TypeMirror serializableType = elementUtils.getTypeElement(CanonicalNameConstants.SERIALIZABLE).asType();
                if (this.typeUtils.isSubtype(elementType, serializableType)) {
                    castToParcelable = true;
                }
            }
        }
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.getIntentBuilderClass(), parameterName);
        JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(elementType, this.holder);
        JVar extraParameterVar = method.param(parameterClass, parameterName);
        JBlock body = method.body();
        JInvocation invocation = body.invoke((JExpression)this.holder.getIntentField(), "putExtra").arg(extraKeyField);
        if (castToSerializable) {
            invocation.arg(JExpr.cast(this.holder.classes().SERIALIZABLE, extraParameterVar));
        } else if (castToParcelable) {
            invocation.arg(JExpr.cast(this.holder.classes().PARCELABLE, extraParameterVar));
        } else {
            invocation.arg(extraParameterVar);
        }
        body._return(JExpr._this());
        return method;
    }
}

