/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.process.IsValid;

public class ValidatorParameterHelper {
    private static final List<String> ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES = Arrays.asList("android.view.MenuItem", "com.actionbarsherlock.view.MenuItem");
    protected final TargetAnnotationHelper annotationHelper;

    public ValidatorParameterHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
    }

    public void zeroOrOneParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero or one parameter, instead of " + parameters.size());
        }
    }

    public void zeroParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero parameter, instead of " + parameters.size());
        }
    }

    public void zeroOrOneViewParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.view.View", valid);
    }

    public void zeroOrOneMenuItemParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES, valid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, String parameterTypeQualifiedName, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, Arrays.asList(parameterTypeQualifiedName), valid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, List<String> parameterTypeQualifiedNames, IsValid valid) {
        VariableElement parameter;
        TypeMirror parameterType;
        this.zeroOrOneParameter(executableElement, valid);
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 1 && !parameterTypeQualifiedNames.contains(((Object)(parameterType = (parameter = parameters.get(0)).asType())).toString())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with no parameter or a parameter of type " + parameterTypeQualifiedNames + ", not " + parameterType);
        }
    }

    public void zeroOrOneBundleParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.os.Bundle", valid);
    }

    public void hasOneOrTwoParametersAndFirstIsBoolean(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1 || parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 1 or 2 parameter, instead of " + parameters.size());
        } else {
            VariableElement firstParameter = parameters.get(0);
            TypeKind parameterKind = firstParameter.asType().getKind();
            if (parameterKind != TypeKind.BOOLEAN && !firstParameter.toString().equals(CanonicalNameConstants.BOOLEAN)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter should be a boolean");
            }
        }
    }

    public void hasZeroOrOneViewOrTwoViewBooleanParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 0) {
            return;
        }
        if (parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 0 or 1(View) or 2(View, boolean) parameter, instead of " + parameters.size());
        } else {
            VariableElement secondParameter;
            String secondParameterType;
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (!firstParameterType.equals("android.view.View")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.view.View, not a " + firstParameterType);
            }
            if (parameters.size() == 2 && !(secondParameterType = ((Object)(secondParameter = parameters.get(1)).asType()).toString()).equals(CanonicalNameConstants.BOOLEAN) && !secondParameterType.equals("boolean")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the second parameter must be a " + CanonicalNameConstants.BOOLEAN + " or boolean, not a " + secondParameterType);
            }
        }
    }

    public void hasZeroOrOneCompoundButtonOrTwoCompoundButtonBooleanParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 0) {
            return;
        }
        if (parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 0 or 1(CompoundButton) or 2(CompoundButton, boolean) parameter, instead of " + parameters.size());
        } else {
            VariableElement secondParameter;
            String secondParameterType;
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (!firstParameterType.equals("android.widget.CompoundButton")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.widget.CompoundButton, not a " + firstParameterType);
            }
            if (parameters.size() == 2 && !(secondParameterType = ((Object)(secondParameter = parameters.get(1)).asType()).toString()).equals(CanonicalNameConstants.BOOLEAN) && !secondParameterType.equals("boolean")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the second parameter must be a " + CanonicalNameConstants.BOOLEAN + " or boolean, not a " + secondParameterType);
            }
        }
    }

    public void hasOneMotionEventOrTwoMotionEventViewParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1 || parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 1 (MotionEvent) or 2 (MotionEvent, View) parameters, instead of " + parameters.size());
        } else {
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (parameters.size() == 1 && !firstParameterType.equals("android.view.MotionEvent")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the parameter must be a android.view.MotionEvent, not a " + firstParameterType);
            }
            if (parameters.size() == 2) {
                boolean isMotionAndView;
                VariableElement secondParameter = parameters.get(1);
                String secondParameterType = ((Object)secondParameter.asType()).toString();
                boolean isViewAndMotion = firstParameterType.equals("android.view.View") && secondParameterType.equals("android.view.MotionEvent");
                boolean bl = isMotionAndView = firstParameterType.equals("android.view.MotionEvent") && secondParameterType.equals("android.view.View");
                if (!isViewAndMotion && !isMotionAndView) {
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(executableElement, "the parameters must be a android.view.View and a android.view.MotionEvent, not a " + firstParameterType + " and a " + secondParameterType);
                }
            }
        }
    }

    public void hasOneOrTwoParametersAndFirstIsDb(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "There should be at least 1 parameter: a android.database.sqlite.SQLiteDatabase");
        } else {
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (!firstParameterType.equals("android.database.sqlite.SQLiteDatabase")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.database.sqlite.SQLiteDatabase, not a " + firstParameterType);
            }
        }
    }

    public void hasExactlyOneParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() != 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with exactly one parameter, instead of " + parameters.size());
        }
    }
}

