/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.lang.model.element.TypeElement;
import org.androidannotations.helper.ActionBarSherlockHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.HoloEverywhereHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.holder.InstanceStateHolder;
import org.androidannotations.holder.OnActivityResultHolder;
import org.androidannotations.process.ProcessHolder;

public class EFragmentHolder
extends EComponentWithViewSupportHolder
implements HasInstanceState,
HasOptionsMenu,
HasOnActivityResult {
    private JFieldVar contentView;
    private JBlock setContentViewBlock;
    private JVar inflater;
    private JVar container;
    private JDefinedClass fragmentBuilderClass;
    private JFieldVar fragmentArgumentsBuilderField;
    private JMethod injectArgsMethod;
    private JBlock injectArgsBlock;
    private JVar injectBundleArgs;
    private InstanceStateHolder instanceStateHolder = new InstanceStateHolder(this);
    private OnActivityResultHolder onActivityResultHolder = new OnActivityResultHolder(this);
    private JBlock onCreateOptionsMenuMethodBody;
    private JVar onCreateOptionsMenuMenuInflaterVar;
    private JVar onCreateOptionsMenuMenuParam;
    private JVar onOptionsItemSelectedItem;
    private JVar onOptionsItemSelectedItemId;
    private JBlock onOptionsItemSelectedIfElseBlock;

    public EFragmentHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.createOnCreate();
        this.createOnViewCreated();
        this.createFragmentBuilder();
    }

    private void createOnCreate() {
        JMethod onCreate = this.generatedClass.method(1, this.codeModel().VOID, "onCreate");
        onCreate.annotate(Override.class);
        JVar onCreateSavedInstanceState = onCreate.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock onCreateBody = onCreate.body();
        JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifier(onCreateBody);
        this.createFindViewById();
        onCreateBody.invoke(this.getInit()).arg(onCreateSavedInstanceState);
        onCreateBody.invoke(JExpr._super(), onCreate).arg(onCreateSavedInstanceState);
        this.viewNotifierHelper.resetPreviousNotifier(onCreateBody, previousNotifier);
    }

    private void createOnViewCreated() {
        JMethod onViewCreated = this.generatedClass.method(1, this.codeModel().VOID, "onViewCreated");
        onViewCreated.annotate(Override.class);
        JVar view = onViewCreated.param(this.classes().VIEW, "view");
        JVar savedInstanceState = onViewCreated.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock onViewCreatedBody = onViewCreated.body();
        onViewCreatedBody.invoke(JExpr._super(), onViewCreated).arg(view).arg(savedInstanceState);
        this.viewNotifierHelper.invokeViewChanged(onViewCreatedBody);
    }

    private void createFindViewById() {
        JMethod findViewById = this.generatedClass.method(1, this.classes().VIEW, "findViewById");
        JVar idParam = findViewById.param(this.codeModel().INT, "id");
        JBlock body = findViewById.body();
        JFieldVar contentView = this.getContentView();
        body._if(contentView.eq(JExpr._null()))._then()._return(JExpr._null());
        body._return(contentView.invoke(findViewById).arg(idParam));
    }

    private void createFragmentBuilder() throws JClassAlreadyExistsException {
        this.fragmentBuilderClass = this.generatedClass._class(17, "FragmentBuilder_");
        this.fragmentArgumentsBuilderField = this.fragmentBuilderClass.field(4, this.classes().BUNDLE, "args_");
        this.createFragmentBuilderConstructor();
        this.createFragmentBuilderBuild();
        this.createFragmentBuilderCreate();
    }

    private void createFragmentBuilderConstructor() {
        JMethod constructor = this.fragmentBuilderClass.constructor(4);
        JBlock constructorBody = constructor.body();
        constructorBody.assign(this.fragmentArgumentsBuilderField, JExpr._new(this.classes().BUNDLE));
    }

    private void createFragmentBuilderBuild() {
        JMethod method = this.fragmentBuilderClass.method(1, this.generatedClass._extends(), "build");
        JBlock body = method.body();
        JVar fragment = body.decl(this.generatedClass, "fragment_", JExpr._new(this.generatedClass));
        body.invoke((JExpression)fragment, "setArguments").arg(this.fragmentArgumentsBuilderField);
        body._return(fragment);
    }

    private void createFragmentBuilderCreate() {
        JMethod method = this.generatedClass.method(17, this.fragmentBuilderClass, "builder");
        method.body()._return(JExpr._new(this.fragmentBuilderClass));
    }

    private void setOnCreateOptionsMenu() {
        JClass menuClass = this.classes().MENU;
        JClass menuInflaterClass = this.classes().MENU_INFLATER;
        if (this.usesActionBarSherlock()) {
            menuClass = this.classes().SHERLOCK_MENU;
            menuInflaterClass = this.classes().SHERLOCK_MENU_INFLATER;
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().VOID, "onCreateOptionsMenu");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onCreateOptionsMenuMenuParam = method.param(menuClass, "menu");
        this.onCreateOptionsMenuMenuInflaterVar = method.param(menuInflaterClass, "inflater");
        this.onCreateOptionsMenuMethodBody = methodBody.block();
        methodBody.invoke(JExpr._super(), method).arg(this.onCreateOptionsMenuMenuParam).arg(this.onCreateOptionsMenuMenuInflaterVar);
        this.getInitBody().invoke("setHasOptionsMenu").arg(JExpr.TRUE);
    }

    private void setOnOptionsItemSelected() {
        JClass menuItemClass = this.classes().MENU_ITEM;
        if (this.usesActionBarSherlock()) {
            menuItemClass = this.classes().SHERLOCK_MENU_ITEM;
        }
        JMethod method = this.generatedClass.method(1, this.codeModel().BOOLEAN, "onOptionsItemSelected");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onOptionsItemSelectedItem = method.param(menuItemClass, "item");
        JVar handled = methodBody.decl(this.codeModel().BOOLEAN, "handled", JExpr.invoke(JExpr._super(), method).arg(this.onOptionsItemSelectedItem));
        methodBody._if(handled)._then()._return(JExpr.TRUE);
        this.onOptionsItemSelectedItemId = methodBody.decl(this.codeModel().INT, "itemId_", this.onOptionsItemSelectedItem.invoke("getItemId"));
        this.onOptionsItemSelectedIfElseBlock = methodBody.block();
        methodBody._return(JExpr.FALSE);
    }

    private boolean usesActionBarSherlock() {
        return new ActionBarSherlockHelper(new AnnotationHelper(this.processingEnvironment())).usesActionBarSherlock(this);
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr.invoke("getActivity");
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, this.codeModel().VOID, "init_");
        this.init.param(this.classes().BUNDLE, "savedInstanceState");
    }

    public JFieldVar getContentView() {
        if (this.contentView == null) {
            this.setContentView();
            this.setOnCreateView();
        }
        return this.contentView;
    }

    private void setContentView() {
        this.contentView = this.generatedClass.field(4, this.classes().VIEW, "contentView_");
    }

    private void setOnCreateView() {
        JMethod onCreateView = this.generatedClass.method(1, this.classes().VIEW, "onCreateView");
        onCreateView.annotate(Override.class);
        HoloEverywhereHelper holoEverywhereHelper = new HoloEverywhereHelper(this);
        JClass inflaterClass = holoEverywhereHelper.usesHoloEverywhere() ? this.classes().HOLO_EVERYWHERE_LAYOUT_INFLATER : this.classes().LAYOUT_INFLATER;
        this.inflater = onCreateView.param(inflaterClass, "inflater");
        this.container = onCreateView.param(this.classes().VIEW_GROUP, "container");
        JVar savedInstanceState = onCreateView.param(this.classes().BUNDLE, "savedInstanceState");
        JBlock body = onCreateView.body();
        body.assign(this.contentView, JExpr._super().invoke(onCreateView).arg(this.inflater).arg(this.container).arg(savedInstanceState));
        this.setContentViewBlock = body.block();
        body._return(this.contentView);
    }

    public JBlock getSetContentViewBlock() {
        if (this.setContentViewBlock == null) {
            this.setOnCreateView();
        }
        return this.setContentViewBlock;
    }

    public JVar getInflater() {
        if (this.inflater == null) {
            this.setOnCreateView();
        }
        return this.inflater;
    }

    public JVar getContainer() {
        if (this.container == null) {
            this.setOnCreateView();
        }
        return this.container;
    }

    public JDefinedClass getBuilderClass() {
        return this.fragmentBuilderClass;
    }

    public JFieldVar getBuilderArgsField() {
        return this.fragmentArgumentsBuilderField;
    }

    public JMethod getInjectArgsMethod() {
        if (this.injectArgsMethod == null) {
            this.setInjectArgs();
        }
        return this.injectArgsMethod;
    }

    public JBlock getInjectArgsBlock() {
        if (this.injectArgsBlock == null) {
            this.setInjectArgs();
        }
        return this.injectArgsBlock;
    }

    public JVar getInjectBundleArgs() {
        if (this.injectBundleArgs == null) {
            this.setInjectArgs();
        }
        return this.injectBundleArgs;
    }

    private void setInjectArgs() {
        this.injectArgsMethod = this.generatedClass.method(4, this.codeModel().VOID, "injectFragmentArguments_");
        JBlock injectExtrasBody = this.injectArgsMethod.body();
        this.injectBundleArgs = injectExtrasBody.decl(this.classes().BUNDLE, "args_", JExpr.invoke("getArguments"));
        this.injectArgsBlock = injectExtrasBody._if(this.injectBundleArgs.ne(JExpr._null()))._then();
        this.getInitBody().invoke(this.injectArgsMethod);
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        return this.instanceStateHolder.getSaveStateMethodBody();
    }

    @Override
    public JVar getSaveStateBundleParam() {
        return this.instanceStateHolder.getSaveStateBundleParam();
    }

    @Override
    public JMethod getRestoreStateMethod() {
        return this.instanceStateHolder.getRestoreStateMethod();
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        return this.instanceStateHolder.getRestoreStateBundleParam();
    }

    @Override
    public JBlock getOnCreateOptionsMenuMethodBody() {
        if (this.onCreateOptionsMenuMethodBody == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMethodBody;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuInflaterVar() {
        if (this.onCreateOptionsMenuMenuInflaterVar == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuInflaterVar;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuParam() {
        if (this.onCreateOptionsMenuMenuParam == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuParam;
    }

    @Override
    public JVar getOnOptionsItemSelectedItem() {
        if (this.onOptionsItemSelectedItem == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItem;
    }

    @Override
    public JVar getOnOptionsItemSelectedItemId() {
        if (this.onOptionsItemSelectedItemId == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItemId;
    }

    @Override
    public JBlock getOnOptionsItemSelectedIfElseBlock() {
        if (this.onOptionsItemSelectedIfElseBlock == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedIfElseBlock;
    }

    @Override
    public JBlock getOnActivityResultCaseBlock(int requestCode) {
        return this.onActivityResultHolder.getCaseBlock(requestCode);
    }

    @Override
    public JVar getOnActivityResultDataParam() {
        return this.onActivityResultHolder.getDataParam();
    }

    @Override
    public JVar getOnActivityResultResultCodeParam() {
        return this.onActivityResultHolder.getResultCodeParam();
    }
}

