/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.process.ProcessHolder;

public class EViewHolder
extends EComponentWithViewSupportHolder {
    protected static final String ALREADY_INFLATED_COMMENT = "The mAlreadyInflated_ hack is needed because of an Android bug\nwhich leads to infinite calls of onFinishInflate()\nwhen inflating a layout with a parent and using\nthe <merge /> tag.";
    private static final String SUPPRESS_WARNING_COMMENT = "We use @SuppressWarning here because our java code\ngenerator doesn't know that there is no need\nto import OnXXXListeners from View as we already\nare in a View.";
    protected JBlock initBody;
    protected JMethod onFinishInflate;
    protected JFieldVar alreadyInflated;

    public EViewHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.addSuppressWarning();
        this.createConstructorAndBuilder();
    }

    @Override
    protected void setGeneratedClass() throws Exception {
        String annotatedComponentQualifiedName = this.annotatedElement.getQualifiedName().toString();
        String generatedBeanQualifiedName = annotatedComponentQualifiedName + "_";
        JClass annotatedComponent = this.codeModel().directClass(annotatedComponentQualifiedName);
        int modifiers = this.annotatedElement.getModifiers().contains((Object)Modifier.ABSTRACT) ? 33 : 9;
        this.generatedClass = this.codeModel()._class(modifiers, generatedBeanQualifiedName, ClassType.CLASS);
        this.generatedClass._extends(annotatedComponent);
    }

    private void addSuppressWarning() {
        this.generatedClass.annotate(SuppressWarnings.class).param("value", "unused");
        this.generatedClass.javadoc().append(SUPPRESS_WARNING_COMMENT);
    }

    private void createConstructorAndBuilder() {
        ArrayList<ExecutableElement> constructors = new ArrayList<ExecutableElement>();
        for (Element element : this.annotatedElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            constructors.add((ExecutableElement)element);
        }
        for (ExecutableElement executableElement : constructors) {
            JMethod copyConstructor = this.generatedClass.constructor(1);
            JMethod staticHelper = this.generatedClass.method(17, this.generatedClass._extends(), "build");
            JBlock body = copyConstructor.body();
            JInvocation superCall = body.invoke("super");
            JInvocation newInvocation = JExpr._new(this.generatedClass);
            for (VariableElement variableElement : executableElement.getParameters()) {
                String paramName = variableElement.getSimpleName().toString();
                String paramType = ((Object)variableElement.asType()).toString();
                copyConstructor.param(this.refClass(paramType), paramName);
                staticHelper.param(this.refClass(paramType), paramName);
                superCall.arg(JExpr.ref(paramName));
                newInvocation.arg(JExpr.ref(paramName));
            }
            JVar newCall = staticHelper.body().decl(this.generatedClass, "instance", newInvocation);
            staticHelper.body().invoke((JExpression)newCall, this.getOnFinishInflate());
            staticHelper.body()._return(newCall);
            body.invoke(this.getInit());
        }
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr.invoke("getContext");
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, this.codeModel().VOID, "init_");
        this.viewNotifierHelper.wrapInitWithNotifier();
    }

    @Override
    public JBlock getInitBody() {
        if (this.initBody == null) {
            this.setInit();
        }
        return this.initBody;
    }

    public void setInitBody(JBlock initBody) {
        this.initBody = initBody;
    }

    public JMethod getOnFinishInflate() {
        if (this.onFinishInflate == null) {
            this.setOnFinishInflate();
        }
        return this.onFinishInflate;
    }

    protected void setOnFinishInflate() {
        this.onFinishInflate = this.generatedClass.method(1, this.codeModel().VOID, "onFinishInflate");
        this.onFinishInflate.annotate(Override.class);
        this.onFinishInflate.javadoc().append(ALREADY_INFLATED_COMMENT);
        JBlock ifNotInflated = this.onFinishInflate.body()._if(this.getAlreadyInflated().not())._then();
        ifNotInflated.assign(this.getAlreadyInflated(), JExpr.TRUE);
        this.getInit();
        this.viewNotifierHelper.invokeViewChanged(ifNotInflated);
        this.onFinishInflate.body().invoke(JExpr._super(), "onFinishInflate");
    }

    public JFieldVar getAlreadyInflated() {
        if (this.alreadyInflated == null) {
            this.setAlreadyInflated();
        }
        return this.alreadyInflated;
    }

    private void setAlreadyInflated() {
        this.alreadyInflated = this.generatedClass.field(4, JType.parse(this.codeModel(), "boolean"), "alreadyInflated_", JExpr.FALSE);
    }
}

