/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import org.androidannotations.holder.EComponentWithViewSupportHolder;

public class OnSeekBarChangeListenerHolder {
    private EComponentWithViewSupportHolder holder;
    private JDefinedClass listenerClass;
    private JBlock onProgressChangedBody;
    private JVar onProgressChangedSeekBarParam;
    private JVar onProgressChangedProgressParam;
    private JVar onProgressChangedFromUserParam;
    private JBlock onStartTrackingTouchBody;
    private JVar onStartTrackingTouchSeekBarParam;
    private JBlock onStopTrackingTouchBody;
    private JVar onStopTrackingTouchSeekBarParam;

    public OnSeekBarChangeListenerHolder(EComponentWithViewSupportHolder holder, JDefinedClass onSeekbarChangeListenerClass) {
        this.holder = holder;
        this.listenerClass = onSeekbarChangeListenerClass;
        this.createOnProgressChanged();
        this.createOnStartTrackingTouch();
        this.createOnStopTrackingTouch();
    }

    private void createOnProgressChanged() {
        JMethod onProgressChangedMethod = this.listenerClass.method(1, this.holder.codeModel().VOID, "onProgressChanged");
        onProgressChangedMethod.annotate(Override.class);
        this.onProgressChangedBody = onProgressChangedMethod.body();
        this.onProgressChangedSeekBarParam = onProgressChangedMethod.param(this.holder.classes().SEEKBAR, "seekBar");
        this.onProgressChangedProgressParam = onProgressChangedMethod.param(this.holder.codeModel().INT, "progress");
        this.onProgressChangedFromUserParam = onProgressChangedMethod.param(this.holder.codeModel().BOOLEAN, "fromUser");
    }

    private void createOnStartTrackingTouch() {
        JMethod onStartTrackingTouchMethod = this.listenerClass.method(1, this.holder.codeModel().VOID, "onStartTrackingTouch");
        onStartTrackingTouchMethod.annotate(Override.class);
        this.onStartTrackingTouchBody = onStartTrackingTouchMethod.body();
        this.onStartTrackingTouchSeekBarParam = onStartTrackingTouchMethod.param(this.holder.classes().SEEKBAR, "seekBar");
    }

    private void createOnStopTrackingTouch() {
        JMethod onStopTrackingTouchMethod = this.listenerClass.method(1, this.holder.codeModel().VOID, "onStopTrackingTouch");
        onStopTrackingTouchMethod.annotate(Override.class);
        this.onStopTrackingTouchBody = onStopTrackingTouchMethod.body();
        this.onStopTrackingTouchSeekBarParam = onStopTrackingTouchMethod.param(this.holder.classes().SEEKBAR, "seekBar");
    }

    public JBlock getOnProgressChangedBody() {
        return this.onProgressChangedBody;
    }

    public JVar getOnProgressChangedSeekBarParam() {
        return this.onProgressChangedSeekBarParam;
    }

    public JVar getOnProgressChangedProgressParam() {
        return this.onProgressChangedProgressParam;
    }

    public JVar getOnProgressChangedFromUserParam() {
        return this.onProgressChangedFromUserParam;
    }

    public JBlock getOnStartTrackingTouchBody() {
        return this.onStartTrackingTouchBody;
    }

    public JVar getOnStartTrackingTouchSeekBarParam() {
        return this.onStartTrackingTouchSeekBarParam;
    }

    public JBlock getOnStopTrackingTouchBody() {
        return this.onStopTrackingTouchBody;
    }

    public JVar getOnStopTrackingTouchSeekBarParam() {
        return this.onStopTrackingTouchSeekBarParam;
    }
}

