/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.androidannotations.api.rest.RestErrorHandler;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.holder.BaseGeneratedClassHolder;
import org.androidannotations.process.ProcessHolder;

public class RestHolder
extends BaseGeneratedClassHolder {
    private JMethod init;
    private JFieldVar rootUrlField;
    private JFieldVar restTemplateField;
    private JFieldVar availableHeadersField;
    private JFieldVar availableCookiesField;
    private JFieldVar authenticationField;
    private JFieldVar restErrorHandlerField;

    public RestHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.implementMethods();
    }

    @Override
    protected void setGeneratedClass() throws Exception {
        String annotatedComponentQualifiedName = this.annotatedElement.getQualifiedName().toString();
        String subComponentQualifiedName = annotatedComponentQualifiedName + "_";
        JClass annotatedComponent = this.codeModel().directClass(annotatedComponentQualifiedName);
        this.generatedClass = this.codeModel()._class(9, subComponentQualifiedName, ClassType.CLASS);
        this.generatedClass._implements(annotatedComponent);
    }

    private void implementMethods() {
        List<ExecutableElement> methods = this.codeModelHelper.getMethods(this.getAnnotatedElement());
        this.implementGetRestTemplate(methods);
        this.implementSetRestTemplate(methods);
        this.implementGetRootUrl(methods);
        this.implementSetRootUrl(methods);
        this.implementSetBasicAuth(methods);
        this.implementSetAuthentication(methods);
        this.implementGetCookie(methods);
        this.implementGetHeader(methods);
        this.implementSetCookie(methods);
        this.implementSetHeader(methods);
        this.implementSetErrorHandler(methods);
    }

    private void implementGetRestTemplate(List<ExecutableElement> methods) {
        JMethod getRestTemplateMethod = this.codeModelHelper.implementMethod(this, methods, null, "org.springframework.web.client.RestTemplate", new String[0]);
        if (getRestTemplateMethod != null) {
            getRestTemplateMethod.body()._return(this.getRestTemplateField());
        }
    }

    private void implementSetRestTemplate(List<ExecutableElement> methods) {
        JMethod setRestTemplateMethod = this.codeModelHelper.implementMethod(this, methods, null, TypeKind.VOID.toString(), "org.springframework.web.client.RestTemplate");
        if (setRestTemplateMethod != null) {
            setRestTemplateMethod.body().assign(JExpr._this().ref(this.getRestTemplateField()), setRestTemplateMethod.params().get(0));
        }
    }

    private void implementGetRootUrl(List<ExecutableElement> methods) {
        JMethod getRootUrlMethod = this.codeModelHelper.implementMethod(this, methods, "getRootUrl", CanonicalNameConstants.STRING, new String[0]);
        if (getRootUrlMethod != null) {
            getRootUrlMethod.body()._return(this.getRootUrlField());
        }
    }

    private void implementSetRootUrl(List<ExecutableElement> methods) {
        JMethod setRootUrlMethod = this.codeModelHelper.implementMethod(this, methods, "setRootUrl", TypeKind.VOID.toString(), CanonicalNameConstants.STRING);
        if (setRootUrlMethod != null) {
            setRootUrlMethod.body().assign(JExpr._this().ref(this.getRootUrlField()), setRootUrlMethod.params().get(0));
        }
    }

    private void implementSetBasicAuth(List<ExecutableElement> methods) {
        JMethod setAuthMethod = this.codeModelHelper.implementMethod(this, methods, "setHttpBasicAuth", TypeKind.VOID.toString(), CanonicalNameConstants.STRING, CanonicalNameConstants.STRING);
        if (setAuthMethod != null) {
            JClass basicAuthClass = this.classes().HTTP_BASIC_AUTHENTICATION;
            JInvocation basicAuthentication = JExpr._new(basicAuthClass).arg(setAuthMethod.params().get(0)).arg(setAuthMethod.params().get(1));
            setAuthMethod.body().assign(JExpr._this().ref(this.getAuthenticationField()), basicAuthentication);
        }
    }

    private void implementSetAuthentication(List<ExecutableElement> methods) {
        JMethod setAuthMethod = this.codeModelHelper.implementMethod(this, methods, "setAuthentication", TypeKind.VOID.toString(), "org.springframework.http.HttpAuthentication");
        if (setAuthMethod != null) {
            setAuthMethod.body().assign(JExpr._this().ref(this.getAuthenticationField()), setAuthMethod.params().get(0));
        }
    }

    private void implementGetCookie(List<ExecutableElement> methods) {
        JMethod getCookieMethod = this.codeModelHelper.implementMethod(this, methods, "getCookie", CanonicalNameConstants.STRING, CanonicalNameConstants.STRING);
        if (getCookieMethod != null) {
            JInvocation cookieValue = JExpr.invoke((JExpression)this.getAvailableCookiesField(), "get").arg(getCookieMethod.params().get(0));
            getCookieMethod.body()._return(cookieValue);
        }
    }

    private void implementGetHeader(List<ExecutableElement> methods) {
        JMethod getHeaderMethod = this.codeModelHelper.implementMethod(this, methods, "getHeader", CanonicalNameConstants.STRING, CanonicalNameConstants.STRING);
        if (getHeaderMethod != null) {
            JInvocation headerValue = JExpr.invoke((JExpression)this.getAvailableHeadersField(), "get").arg(getHeaderMethod.params().get(0));
            getHeaderMethod.body()._return(headerValue);
        }
    }

    private void implementSetCookie(List<ExecutableElement> methods) {
        JMethod setCookieMethod = this.codeModelHelper.implementMethod(this, methods, "setCookie", TypeKind.VOID.toString(), CanonicalNameConstants.STRING, CanonicalNameConstants.STRING);
        if (setCookieMethod != null) {
            setCookieMethod.body().invoke((JExpression)this.getAvailableCookiesField(), "put").arg(setCookieMethod.params().get(0)).arg(setCookieMethod.params().get(1));
        }
    }

    private void implementSetHeader(List<ExecutableElement> methods) {
        JMethod setHeaderMethod = this.codeModelHelper.implementMethod(this, methods, "setHeader", TypeKind.VOID.toString(), CanonicalNameConstants.STRING, CanonicalNameConstants.STRING);
        if (setHeaderMethod != null) {
            setHeaderMethod.body().invoke((JExpression)this.getAvailableHeadersField(), "put").arg(setHeaderMethod.params().get(0)).arg(setHeaderMethod.params().get(1));
        }
    }

    private void implementSetErrorHandler(List<ExecutableElement> methods) {
        JMethod setErrorHandlerMethod = this.codeModelHelper.implementMethod(this, methods, "setRestErrorHandler", TypeKind.VOID.toString(), RestErrorHandler.class.getName());
        if (setErrorHandlerMethod != null) {
            setErrorHandlerMethod.body().assign(JExpr._this().ref(this.getRestErrorHandlerField()), setErrorHandlerMethod.params().get(0));
        }
    }

    public JMethod getInit() {
        if (this.init == null) {
            this.setInit();
        }
        return this.init;
    }

    private void setInit() {
        this.init = this.getGeneratedClass().constructor(1);
    }

    public JFieldVar getRootUrlField() {
        if (this.rootUrlField == null) {
            this.setRootUrlField();
        }
        return this.rootUrlField;
    }

    private void setRootUrlField() {
        this.rootUrlField = this.getGeneratedClass().field(4, this.classes().STRING, "rootUrl");
    }

    public JFieldVar getRestTemplateField() {
        if (this.restTemplateField == null) {
            this.setRestTemplateField();
        }
        return this.restTemplateField;
    }

    private void setRestTemplateField() {
        this.restTemplateField = this.getGeneratedClass().field(4, this.classes().REST_TEMPLATE, "restTemplate");
        this.getInit().body().assign(this.restTemplateField, JExpr._new(this.classes().REST_TEMPLATE));
    }

    public JFieldVar getAvailableHeadersField() {
        if (this.availableHeadersField == null) {
            this.setAvailableHeadersField();
        }
        return this.availableHeadersField;
    }

    private void setAvailableHeadersField() {
        JClass stringClass = this.classes().STRING;
        JClass mapClass = this.classes().HASH_MAP.narrow(stringClass, stringClass);
        this.availableHeadersField = this.getGeneratedClass().field(4, mapClass, "availableHeaders");
        this.getInit().body().assign(this.availableHeadersField, JExpr._new(mapClass));
    }

    public JFieldVar getAvailableCookiesField() {
        if (this.availableCookiesField == null) {
            this.setAvailableCookiesField();
        }
        return this.availableCookiesField;
    }

    private void setAvailableCookiesField() {
        JClass stringClass = this.classes().STRING;
        JClass mapClass = this.classes().HASH_MAP.narrow(stringClass, stringClass);
        this.availableCookiesField = this.getGeneratedClass().field(4, mapClass, "availableCookies");
        this.getInit().body().assign(this.availableCookiesField, JExpr._new(mapClass));
    }

    public JFieldVar getAuthenticationField() {
        if (this.authenticationField == null) {
            this.setAuthenticationField();
        }
        return this.authenticationField;
    }

    private void setAuthenticationField() {
        this.authenticationField = this.getGeneratedClass().field(4, this.classes().HTTP_AUTHENTICATION, "authentication");
    }

    public JFieldVar getRestErrorHandlerField() {
        if (this.restErrorHandlerField == null) {
            this.setRestErrorHandlerField();
        }
        return this.restErrorHandlerField;
    }

    private void setRestErrorHandlerField() {
        JClass restErrorHandlerClass = this.refClass(RestErrorHandler.class.getName());
        this.restErrorHandlerField = this.getGeneratedClass().field(4, restErrorHandlerClass, "restErrorHandler");
    }
}

