/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.rebound;

import com.facebook.rebound.ReentrantCallback;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringClock;
import com.facebook.rebound.SpringLooper;
import com.facebook.rebound.SpringSystemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class BaseSpringSystem {
    private final Map<String, Spring> mSpringRegistry = new HashMap<String, Spring>();
    private final Set<Spring> mActiveSprings = new CopyOnWriteArraySet<Spring>();
    private final SpringClock mClock;
    private final SpringLooper mSpringLooper;
    private long mLastTimeMillis = -1L;
    private ReentrantCallback<SpringSystemListener> mListeners = new ReentrantCallback();
    private boolean mIdle = true;

    public BaseSpringSystem(SpringClock clock, SpringLooper springLooper) {
        if (clock == null) {
            throw new IllegalArgumentException("clock is required");
        }
        if (springLooper == null) {
            throw new IllegalArgumentException("springLooper is required");
        }
        this.mClock = clock;
        this.mSpringLooper = springLooper;
        this.mSpringLooper.setSpringSystem(this);
    }

    public boolean getIsIdle() {
        return this.mIdle;
    }

    public Spring createSpring() {
        Spring spring = new Spring(this);
        this.registerSpring(spring);
        return spring;
    }

    public Spring getSpringById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is required");
        }
        return this.mSpringRegistry.get(id);
    }

    public List<Spring> getAllSprings() {
        Collection<Spring> collection = this.mSpringRegistry.values();
        ArrayList<Spring> list = collection instanceof List ? (ArrayList<Spring>)collection : new ArrayList<Spring>(collection);
        return Collections.unmodifiableList(list);
    }

    void registerSpring(Spring spring) {
        if (spring == null) {
            throw new IllegalArgumentException("spring is required");
        }
        if (this.mSpringRegistry.containsKey(spring.getId())) {
            throw new IllegalArgumentException("spring is already registered");
        }
        this.mSpringRegistry.put(spring.getId(), spring);
    }

    void deregisterSpring(Spring spring) {
        if (spring == null) {
            throw new IllegalArgumentException("spring is required");
        }
        this.mActiveSprings.remove(spring);
        this.mSpringRegistry.remove(spring.getId());
    }

    void advance(long time, long deltaTime) {
        for (Spring spring : this.mActiveSprings) {
            if (spring.systemShouldAdvance()) {
                spring.advance((double)time / 1000.0, (double)deltaTime / 1000.0);
                continue;
            }
            this.mActiveSprings.remove(spring);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() {
        long currentTimeMillis = this.mClock.now();
        if (this.mLastTimeMillis == -1L) {
            this.mLastTimeMillis = currentTimeMillis - 1L;
        }
        long ellapsedMillis = currentTimeMillis - this.mLastTimeMillis;
        this.mLastTimeMillis = currentTimeMillis;
        for (SpringSystemListener listener : this.mListeners) {
            listener.onBeforeIntegrate(this);
        }
        this.advance(currentTimeMillis, ellapsedMillis);
        Iterator<SpringSystemListener> i$ = this;
        synchronized (i$) {
            if (this.mActiveSprings.isEmpty()) {
                this.mIdle = true;
                this.mLastTimeMillis = -1L;
            }
        }
        for (SpringSystemListener listener : this.mListeners) {
            listener.onAfterIntegrate(this);
        }
        if (this.mIdle) {
            this.mSpringLooper.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateSpring(String springId) {
        Spring spring = this.mSpringRegistry.get(springId);
        if (spring == null) {
            throw new IllegalArgumentException("springId " + springId + " does not reference a registered spring");
        }
        BaseSpringSystem baseSpringSystem = this;
        synchronized (baseSpringSystem) {
            this.mActiveSprings.add(spring);
            if (this.getIsIdle()) {
                this.mIdle = false;
                this.mSpringLooper.start();
            }
        }
    }

    public void addListener(SpringSystemListener newListener) {
        if (newListener == null) {
            throw new IllegalArgumentException("newListener is required");
        }
        this.mListeners.addListener(newListener);
    }

    public void removeListener(SpringSystemListener listenerToRemove) {
        if (listenerToRemove == null) {
            throw new IllegalArgumentException("listenerToRemove is required");
        }
        this.mListeners.removeListener(listenerToRemove);
    }

    public void removeAllListeners() {
        this.mListeners.clear();
    }
}

