package com.example.skindemo;


import com.example.skindemo.R.layout;

import android.app.Activity;
import android.content.SharedPreferences;
import android.widget.LinearLayout;

/**
 * PadQzoneƤ
 *
 */
public class SkinSettingManager {


	public final static String SKIN_PREF = "skinSetting";
	
	public SharedPreferences skinSettingPreference;
	
	private int[] skinResources = { R.drawable.default_wallpaper,
			R.drawable.wallpaper_c,R.drawable.wallpaper_d,R.drawable.wallpaper_f,
			R.drawable.wallpaper_g,R.drawable.aabbcc
	};
	
	private Activity mActivity;
    private LinearLayout mlayout;	
	public SkinSettingManager(Activity activity,LinearLayout layout) {
		this.mActivity = activity;	
		this.mlayout=layout;
		skinSettingPreference = mActivity.getSharedPreferences(SKIN_PREF, 3);
	}
	public SkinSettingManager(Activity activity) {
		this.mActivity = activity;	
		skinSettingPreference = mActivity.getSharedPreferences(SKIN_PREF, 3);
	}
	/**
	 * ȡǰƤ
	 * 
	 * @return
	 */
	public int getSkinType() {
		String key = "skin_type";
		return skinSettingPreference.getInt(key, 0);
	}

	/**
	 * Ƥдȫȥ
	 * 
	 * @param j
	 */
	public void setSkinType(int j) {
		SharedPreferences.Editor editor = skinSettingPreference.edit();
		String key  = "skin_type";
		
		editor.putInt(key, j);
		editor.commit();
	}
	
	/**
	 * ȡǰƤıͼԴid
	 * 
	 * @return
	 */
	public int getCurrentSkinRes() {
		int skinLen = skinResources.length;
		int getSkinLen = getSkinType();
		if(getSkinLen >= skinLen){
			getSkinLen = 0;
		}
		
		return skinResources[getSkinLen];
	}
	
	/**
	 * ڵƤťлƤ
	 */
	public void toggleSkins(int skinType){
		setSkinType(skinType);
		mActivity.getWindow().setBackgroundDrawable(null);
		try {
			mActivity.getWindow().setBackgroundDrawableResource(getCurrentSkinRes());
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}
		
	/**
	 * ڳʼƤ
	 */
//	public void initSkins(){	
//		System.out.println("------->00");
//		mActivity.getWindow().setBackgroundDrawableResource(getCurrentSkinRes());
//	}
	public void initSkins(){	
		if(mlayout==null){
			mActivity.getWindow().setBackgroundDrawableResource(getCurrentSkinRes());
		}else{
				mlayout.setBackgroundResource(getCurrentSkinRes());;
		}
	}
}
