<?php

namespace Imi\Server\View\Engine;

use Imi\Server\Http\Message\Response;

/**
 * PHP原生模版引擎.
 */
class Php implements IEngine
{
    /**
     * @param \Imi\Server\Http\Message\Response $response
     * @param string                            $fileName
     * @param array                             $data
     *
     * @return \Imi\Server\Http\Message\Response
     */
    public function render(Response $response, $fileName, $data = []): Response
    {
        if (!is_file($fileName))
        {
            return $response;
        }
        $closure = function ($__renderFileName, $__renderData) {
            if (\is_array($__renderData))
            {
                extract($__renderData);
            }
            include $__renderFileName;
        };
        ob_start();
        $closure($fileName, $data);

        return $response->write(ob_get_clean());
    }
}
