<?php
namespace addons\address;  // 注意命名空间规范
use think\Addons;

class Widget extends Addons // 需继承Addons类
{
    // 该插件的基础信息
    public $info = [
        'name' => 'address',   // 插件标识
        'title' => '会员地址',  // 插件名称
        'author' => 'RGCMS',  // 插件作者
        'is_admin' => true,
        'version' => '0.1',  // 插件版本
        'description' => "会员多地址管理"  // 插件描述
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        if(strtolower(config('database.type')) == 'sqlite') {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."address` (";
            $sql_config .= "`id` INTEGER PRIMARY KEY AUTOINCREMENT,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`province` INT DEFAULT 0,";
            $sql_config .= "`city` INT DEFAULT 0,";
            $sql_config .= "`district` INT DEFAULT 0,";
            $sql_config .= "`isdefault` INT DEFAULT 0,";
            $sql_config .= "`name` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`zipcode` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`mobile` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`address` TEXT DEFAULT NULL,";
            $sql_config .= "`tel` VARCHAR(255) DEFAULT NULL";
            $sql_config .= ");";
        } else {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."address`(";
            $sql_config .= "`id` INT(10) NOT NULL AUTO_INCREMENT,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`province` INT DEFAULT 0,";
            $sql_config .= "`city` INT DEFAULT 0,";
            $sql_config .= "`district` INT DEFAULT 0,";
            $sql_config .= "`isdefault` INT DEFAULT 0,";
            $sql_config .= "`name` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`zipcode` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`mobile` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "`address` TEXT DEFAULT NULL,";
            $sql_config .= "`tel` VARCHAR(255) DEFAULT NULL,";
            $sql_config .= "PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件-会员多地址管理';";
        }
        try {
            \think\Db::execute($sql_config);
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        try {
            \think\Db::execute("DROP TABLE IF EXISTS `".config('database.prefix')."address`;");
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }

}