<?php
namespace addons\address\controller;
use think\addons\Controller;
use Request;
use Db;

class Index extends Controller
{
    protected $userid;
    protected function initialize()
    {
        parent::initialize();
        $this->isInstall();
        if(!Request::isPost()) abort(404,lang('content_error'));
        if(!session('?userid')) $this->error('请登录后操作');
        $this->userid = session('userid');
    }

    // 新增
    public function add()
    {
        Request::filter(['trim','strip_tags','htmlspecialchars']);
        $count = Db::name('address')->whereUserId($this->userid)->count();
        if($count > 5) $this->error('最多只能设置5条地址信息');
        $data = Request::post();
        $province = $data['province'];
        $city = $data['city'];
        $district = $data['district'];
        if($province == -1) $this->error('请选择省');
        if($city == -1) $this->error('请选择城市');
        if($district == -1) $this->error('请选择区县');
        $validate = new \think\Validate;
        $rule = ['name|姓名' => 'require','address|详细地址' => 'require','province|省份' => 'require','city|城市' => 'require','district|区县' => 'require','mobile|手机号' => 'require|mobile'];
        $validate->rule($rule);
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }
        $data['isdefault'] = 0;
        $data['user_id'] = $this->userid;
        $result = Db::name('address')->strict(false)->insert($data);
        if ($result) {
            $this->success('新增成功',uUrl('user','address','index'));
        } else {
            $this->error('新增失败');
        }
    }

    // 编辑
    public function edit($id)
    {
        $info = Db::name('address')->where(['id' => $id,'user_id' => $this->userid])->find();
        if(!$info) $this->error('数据不存在');
        Request::filter(['trim','strip_tags','htmlspecialchars']);
        $data = Request::post();
        $province = $data['province'];
        $city = $data['city'];
        $district = $data['district'];
        if($province == -1) $this->error('请选择省');
        if($city == -1) $this->error('请选择城市');
        if($district == -1) $this->error('请选择区县');
        $validate = new \think\Validate;
        $rule = ['name|姓名' => 'require','address|详细地址' => 'require','province|省份' => 'require','city|城市' => 'require','district|区县' => 'require','mobile|手机号' => 'require|mobile'];
        $validate->rule($rule);
        if (!$validate->check($data)) {
            $this->error($validate->getError());
        }
        $data['user_id'] = $this->userid;
        $result = Db::name('address')->strict(false)->where(['id' => $info['id']])->update($data);
        if ($result) {
            $this->success('修改成功',uUrl('user','address','index'));
        } else {
            $this->error('修改失败');
        }
    }

    // 删除
    public function del()
    {
        $id = Request::post('id');
        $result = Db::name('address')->where(['id' => $id,'user_id' => $this->userid])->where('isdefault','<>',1)->delete();
        if ($result) {
            $this->success('删除成功',uUrl('user','address','index'));
        } else {
            $this->error('删除失败');
        }
    }

    // 设默认
    public function setdft()
    {
        $id = Request::post('id');
        $info = Db::name('address')->where(['id' => $id,'user_id' => $this->userid])->find();
        if(!$info) $this->error('数据不存在');
        if($info['isdefault']) $this->error('该地址已是默认');
        Db::name('address')->where(['user_id' => $this->userid,'isdefault' => 1])->setField('isdefault',0);
        $result = Db::name('address')->where(['user_id' => $this->userid,'id' => $id])->setField('isdefault',1);
        if ($result) {
            $this->success('设置成功',uUrl('user','address','index'));
        } else {
            $this->error('设置失败');
        }
    }
}