<?php
namespace addons\favorite;  // 注意命名空间规范
use think\Addons;

class Widget extends Addons // 需继承Addons类
{
    // 该插件的基础信息
    public $info = [
        'name' => 'favorite',   // 插件标识
        'title' => '内容收藏',  // 插件名称
        'author' => 'RGCMS',  // 插件作者
        'is_admin' => true,
        'version' => '0.1',  // 插件版本
        'description' => "会员对模型内容的收藏和取消收藏",  // 插件描述
        'help' => "详情页.标签调用：<br>{:hook('favoritehook')}"
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        if(strtolower(config('database.type')) == 'sqlite') {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."favorite` (";
            $sql_config .= "`id` INTEGER PRIMARY KEY AUTOINCREMENT,";
            $sql_config .= "`cmsmodels_id` INT DEFAULT NULL,";
            $sql_config .= "`cid` INT DEFAULT NULL,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`create_time` BIGINT DEFAULT 0";
            $sql_config .= ");";
        } else {
            $sql_config = "CREATE TABLE IF NOT EXISTS `".config('database.prefix')."favorite`(";
            $sql_config .= "`id` INT(10) NOT NULL AUTO_INCREMENT,";
            $sql_config .= "`cmsmodels_id` INT DEFAULT NULL,";
            $sql_config .= "`cid` INT DEFAULT NULL,";
            $sql_config .= "`user_id` INT DEFAULT 0,";
            $sql_config .= "`create_time` BIGINT DEFAULT 0,";
            $sql_config .= "PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件-内容模型收藏';";
        }
        try {
            \think\Db::execute($sql_config);
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        try {
            \think\Db::execute("DROP TABLE IF EXISTS `".config('database.prefix')."favorite`;");
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }

    public function favoritehook($param)
    {
        $config = $this->getConfig(true);
        return $this->fetch('index/info',compact('config'));
    }

}